/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.group;

import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.AbstractGroupImpl;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.group.QuarantineGroup;
import brooklyn.entity.trait.Startable;
import brooklyn.management.Task;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuarantineGroupImpl
extends AbstractGroupImpl
implements QuarantineGroup {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntity.class);

    @Override
    protected void initEnrichers() {
    }

    @Override
    public void expungeMembers(boolean stopFirst) {
        ImmutableSet members = ImmutableSet.copyOf(this.getMembers());
        RuntimeException exception = null;
        if (stopFirst) {
            LinkedHashMap tasks = Maps.newLinkedHashMap();
            for (Entity member : members) {
                if (!(member instanceof Startable)) continue;
                Task task = Effectors.invocation(member, Startable.STOP, ImmutableMap.of()).asTask();
                tasks.put(member, task);
            }
            DynamicTasks.queueIfPossible(Tasks.parallel("stopping " + tasks.size() + " member" + Strings.s((int)tasks.size()) + " (parallel)", tasks.values())).orSubmitAsync(this);
            try {
                this.waitForTasksOnExpungeMembers(tasks);
            }
            catch (RuntimeException e) {
                Exceptions.propagateIfFatal((Throwable)e);
                exception = e;
                LOG.warn("Problem stopping members of quarantine group " + this + " (rethrowing after unmanaging members): " + e);
            }
        }
        for (Entity member : members) {
            this.removeMember(member);
            Entities.unmanage(member);
        }
        if (exception != null) {
            throw exception;
        }
    }

    protected Map<Entity, Throwable> waitForTasksOnExpungeMembers(Map<? extends Entity, ? extends Task<?>> tasks) {
        LinkedHashMap errors = Maps.newLinkedHashMap();
        for (Map.Entry<Entity, Task<?>> entry : tasks.entrySet()) {
            Entity member = entry.getKey();
            Task<?> task = entry.getValue();
            try {
                task.get();
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Throwable t) {
                Throwable interesting = Exceptions.getFirstInteresting((Throwable)t);
                LOG.error("Quarantine group " + this + " failed to stop quarantined entity " + member + " (removing): " + interesting, interesting);
                LOG.debug("Trace for: Quarantine group " + this + " failed to stop quarantined entity " + member + " (removing): " + t, t);
                errors.put(member, t);
            }
        }
        return errors;
    }
}

