/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.group;

import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.BasicGroup;
import brooklyn.entity.basic.DynamicGroupImpl;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.group.DynamicMultiGroup;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.util.collections.MutableMap;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class DynamicMultiGroupImpl
extends DynamicGroupImpl
implements DynamicMultiGroup {
    private transient FunctionFeed rescan;

    public static Function<Entity, String> bucketFromAttribute(AttributeSensor<?> sensor, String defaultValue) {
        return new BucketFromAttribute(sensor, defaultValue);
    }

    public static Function<Entity, String> bucketFromAttribute(AttributeSensor<?> sensor) {
        return DynamicMultiGroupImpl.bucketFromAttribute(sensor, null);
    }

    @Override
    public void init() {
        super.init();
        this.setAttribute(BUCKETS, ImmutableMap.of());
        this.connectScanner();
    }

    private void connectScanner() {
        Long interval = (Long)this.getConfig(RESCAN_INTERVAL);
        if (interval != null && interval > 0L) {
            this.rescan = FunctionFeed.builder().entity(this).poll(((FunctionPollConfig)new FunctionPollConfig(RESCAN).period(interval, TimeUnit.SECONDS)).callable(new Callable<Void>(){

                @Override
                public Void call() throws Exception {
                    DynamicMultiGroupImpl.this.rescanEntities();
                    return null;
                }
            })).build();
        }
    }

    @Override
    public void rebind() {
        super.rebind();
        if (this.rescan == null) {
            this.connectScanner();
        }
    }

    @Override
    public void stop() {
        super.stop();
        if (this.rescan != null && this.rescan.isActivated()) {
            this.rescan.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEntityAdded(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.onEntityAdded(item);
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEntityRemoved(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.onEntityRemoved(item);
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onEntityChanged(Entity item) {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.onEntityChanged(item);
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void rescanEntities() {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            super.rescanEntities();
            this.distributeEntities();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void distributeEntities() {
        Object object = this.memberChangeMutex;
        synchronized (object) {
            Function bucketFunction = (Function)this.getConfig(BUCKET_FUNCTION);
            EntitySpec bucketSpec = (EntitySpec)this.getConfig(BUCKET_SPEC);
            if (bucketFunction == null || bucketSpec == null) {
                return;
            }
            MutableMap buckets = MutableMap.copyOf((Map)((Map)this.getAttribute(BUCKETS)));
            ImmutableListMultimap entityMapping = Multimaps.index((Iterable)Iterables.filter(this.getMembers(), (Predicate)Predicates.compose((Predicate)Predicates.notNull(), (Function)bucketFunction)), (Function)bucketFunction);
            for (String name : entityMapping.keySet()) {
                BasicGroup bucket = (BasicGroup)buckets.get(name);
                if (bucket == null) {
                    bucket = (BasicGroup)this.addChild((EntitySpec)EntitySpec.create((EntitySpec)bucketSpec).displayName(name));
                    Entities.manage(bucket);
                    buckets.put(name, bucket);
                }
                bucket.setMembers(entityMapping.get((Object)name));
            }
            ImmutableSet empty = ImmutableSet.copyOf((Collection)Sets.difference(buckets.keySet(), (Set)entityMapping.keySet()));
            for (String name : empty) {
                Group removed = (Group)buckets.remove(name);
                this.removeChild((Entity)removed);
                Entities.unmanage((Entity)removed);
            }
            this.setAttribute(BUCKETS, ImmutableMap.copyOf((Map)buckets));
        }
    }

    public static class BucketFromAttribute
    implements Function<Entity, String> {
        private final AttributeSensor<?> sensor;
        private final String defaultValue;

        public BucketFromAttribute(AttributeSensor<?> sensor, String defaultValue) {
            this.sensor = (AttributeSensor)Preconditions.checkNotNull(sensor, (Object)"sensor");
            this.defaultValue = defaultValue;
        }

        public String apply(@Nullable Entity input) {
            Object value = input.getAttribute(this.sensor);
            if (value == null) {
                return this.defaultValue;
            }
            return String.valueOf(value);
        }
    }
}

