/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.group;

import brooklyn.enricher.Enrichers;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractGroupImpl;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityFactory;
import brooklyn.entity.basic.EntityFactoryForLocation;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.group.DynamicFabric;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Changeable;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.management.Task;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.collections.MutableList;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicFabricImpl
extends AbstractGroupImpl
implements DynamicFabric {
    private static final Logger logger = LoggerFactory.getLogger(DynamicFabricImpl.class);

    @Override
    public void init() {
        super.init();
        this.addEnricher(((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)((Enrichers.AggregatorBuilder)Enrichers.builder().aggregating((AttributeSensor)Changeable.GROUP_SIZE).publishing(FABRIC_SIZE).fromMembers()).computingSum()).valueToReportIfNoSensors(0)).build());
        this.setAttribute(SERVICE_UP, false);
    }

    protected EntitySpec<?> getMemberSpec() {
        return (EntitySpec)this.getConfig(MEMBER_SPEC);
    }

    protected EntityFactory<?> getFactory() {
        return (EntityFactory)this.getConfig(FACTORY);
    }

    protected String getDisplayNamePrefix() {
        return (String)this.getConfig(DISPLAY_NAME_PREFIX);
    }

    protected String getDisplayNameSuffix() {
        return (String)this.getConfig(DISPLAY_NAME_SUFFIX);
    }

    @Override
    public void setMemberSpec(EntitySpec<?> memberSpec) {
        this.setConfigEvenIfOwned(MEMBER_SPEC, memberSpec);
    }

    @Override
    public void setFactory(EntityFactory<?> factory) {
        this.setConfigEvenIfOwned(FACTORY, factory);
    }

    @Override
    public void start(Collection<? extends Location> locsO) {
        MutableList newLocations;
        if (locsO != null) {
            this.addLocations(locsO);
        }
        if ((newLocations = MutableList.copyOf(locsO)).isEmpty()) {
            newLocations.addAll(this.getLocations());
        }
        Preconditions.checkNotNull((Object)newLocations, (Object)"locations must be supplied");
        Preconditions.checkArgument((newLocations.size() >= 1 ? 1 : 0) != 0, (Object)"One or more locations must be supplied");
        int locIndex = 0;
        ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
        try {
            LinkedHashMap tasks = Maps.newLinkedHashMap();
            for (Entity child : this.getChildren()) {
                if (!(child instanceof Startable)) continue;
                this.addMember(child);
                Location it = null;
                if (child.getLocations().isEmpty() && !newLocations.isEmpty()) {
                    it = (Location)newLocations.get(locIndex++ % newLocations.size());
                    ((EntityInternal)child).addLocations(Arrays.asList(it));
                }
                tasks.put(child, Entities.submit((Entity)this, Effectors.invocation(child, START, ImmutableMap.of((Object)"locations", (Object)(it == null ? ImmutableList.of() : ImmutableList.of(it)))).asTask()));
            }
            while (locIndex-- > 0 && !newLocations.isEmpty()) {
                newLocations.remove(0);
            }
            for (Location it : newLocations) {
                Entity e = this.addCluster(it);
                ((EntityInternal)e).addLocations(Arrays.asList(it));
                if (!(e instanceof Startable)) continue;
                Task task = Entities.submit((Entity)this, Effectors.invocation(e, START, ImmutableMap.of((Object)"locations", (Object)ImmutableList.of((Object)it))).asTask());
                tasks.put(e, task);
            }
            this.waitForTasksOnStart(tasks);
            ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
            this.setAttribute(SERVICE_UP, true);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    protected void waitForTasksOnStart(Map<Entity, Task<?>> tasks) {
        for (Map.Entry<Entity, Task<?>> entry : tasks.entrySet()) {
            try {
                entry.getValue().get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw Throwables.propagate((Throwable)e);
            }
            catch (ExecutionException ee) {
                throw Throwables.propagate((Throwable)ee.getCause());
            }
        }
    }

    @Override
    public void stop() {
        ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPING);
        try {
            Iterable stoppableChildren = Iterables.filter(this.getChildren(), (Predicate)Predicates.instanceOf(Startable.class));
            Task<?> invoke = Entities.invokeEffector((EntityLocal)this, stoppableChildren, Startable.STOP);
            if (invoke != null) {
                invoke.get();
            }
            ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPED);
            this.setAttribute(SERVICE_UP, false);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void restart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Integer getFabricSize() {
        int result = 0;
        for (Entity child : this.getChildren()) {
            result += ((Integer)GroovyJavaMethods.elvis((Object)child.getAttribute(Changeable.GROUP_SIZE), (Object)0)).intValue();
        }
        return result;
    }

    @Override
    public boolean removeChild(Entity child) {
        boolean changed = super.removeChild(child);
        if (changed) {
            this.removeMember(child);
        }
        return changed;
    }

    protected Map getCustomChildFlags() {
        Map result = (Map)this.getConfig(CUSTOM_CHILD_FLAGS);
        return result == null ? ImmutableMap.of() : result;
    }

    protected Entity addCluster(Location location) {
        String locationName = (String)GroovyJavaMethods.elvis((Object[])new Object[]{location.getDisplayName(), location.getDisplayName(), null});
        LinkedHashMap creation = Maps.newLinkedHashMap();
        creation.putAll(this.getCustomChildFlags());
        if (GroovyJavaMethods.truth((Object)this.getDisplayNamePrefix()) || GroovyJavaMethods.truth((Object)this.getDisplayNameSuffix())) {
            String displayName = "" + GroovyJavaMethods.elvis((Object)this.getDisplayNamePrefix(), (Object)"") + GroovyJavaMethods.elvis((Object)locationName, (Object)"unnamed") + GroovyJavaMethods.elvis((Object)this.getDisplayNameSuffix(), (Object)"");
            creation.put("displayName", displayName);
        }
        logger.info("Creating entity in fabric {} at {}{}", new Object[]{this, location, creation != null && !creation.isEmpty() ? ", properties " + creation : ""});
        Entity entity = this.createCluster(location, creation);
        if (locationName != null) {
            if (entity.getDisplayName() == null) {
                ((EntityLocal)entity).setDisplayName(entity.getEntityType().getSimpleName() + " (" + locationName + ")");
            } else if (!entity.getDisplayName().contains(locationName)) {
                ((EntityLocal)entity).setDisplayName(entity.getDisplayName() + " (" + locationName + ")");
            }
        }
        if (entity.getParent() == null) {
            entity.setParent((Entity)this);
        }
        Entities.manage(entity);
        this.addMember(entity);
        return entity;
    }

    protected Entity createCluster(Location location, Map flags) {
        EntitySpec<?> memberSpec = this.getMemberSpec();
        if (memberSpec != null) {
            return this.addChild(EntitySpec.create(memberSpec).configure(flags));
        }
        EntityFactory<?> factory = this.getFactory();
        if (factory == null) {
            throw new IllegalStateException("No member spec nor entity factory supplied for dynamic fabric " + this);
        }
        EntityFactory<Object> factoryToUse = factory instanceof EntityFactoryForLocation ? ((EntityFactoryForLocation)((Object)factory)).newFactoryForLocation(location) : factory;
        Object entity = factoryToUse.newEntity(flags, this);
        if (entity == null) {
            throw new IllegalStateException("EntityFactory factory routine returned null entity, in " + this);
        }
        return entity;
    }
}

