/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.group;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractGroupImpl;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityFactory;
import brooklyn.entity.basic.EntityFactoryForLocation;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.QuorumCheck;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.group.DynamicCluster;
import brooklyn.entity.group.QuarantineGroup;
import brooklyn.entity.group.StopFailedRuntimeException;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.trait.Startable;
import brooklyn.entity.trait.StartableMethods;
import brooklyn.location.Location;
import brooklyn.location.MachineProvisioningLocation;
import brooklyn.location.basic.Locations;
import brooklyn.location.cloud.AvailabilityZoneExtension;
import brooklyn.management.Task;
import brooklyn.policy.Policy;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.ReferenceWithError;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.JavaClassNames;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskTags;
import brooklyn.util.task.Tasks;
import brooklyn.util.text.StringPredicates;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicClusterImpl
extends AbstractGroupImpl
implements DynamicCluster {
    private static final Logger LOG;
    protected final Object mutex = new Object[0];
    private static final Function<Collection<Entity>, Entity> defaultRemovalStrategy;

    @Override
    public void init() {
        super.init();
    }

    @Override
    protected void initEnrichers() {
        if (this.getConfigRaw(UP_QUORUM_CHECK, true).isAbsent() && (Integer)this.getConfig(INITIAL_SIZE) == 0) {
            this.setConfig(UP_QUORUM_CHECK, QuorumCheck.QuorumChecks.atLeastOneUnlessEmpty());
            this.setAttribute(SERVICE_UP, true);
        } else {
            this.setAttribute(SERVICE_UP, false);
        }
        super.initEnrichers();
        ServiceStateLogic.newEnricherFromChildrenUp().checkMembersOnly().requireUpChildren((QuorumCheck)this.getConfig(UP_QUORUM_CHECK)).addTo(this);
    }

    @Override
    public void setRemovalStrategy(Function<Collection<Entity>, Entity> val) {
        this.setConfig(REMOVAL_STRATEGY, Preconditions.checkNotNull(val, (Object)"removalStrategy"));
    }

    protected Function<Collection<Entity>, Entity> getRemovalStrategy() {
        Function<Collection<Entity>, Entity> result = (Function<Collection<Entity>, Entity>)this.getConfig(REMOVAL_STRATEGY);
        return result != null ? result : defaultRemovalStrategy;
    }

    @Override
    public void setZonePlacementStrategy(DynamicCluster.NodePlacementStrategy val) {
        this.setConfig(ZONE_PLACEMENT_STRATEGY, Preconditions.checkNotNull((Object)val, (Object)"zonePlacementStrategy"));
    }

    protected DynamicCluster.NodePlacementStrategy getZonePlacementStrategy() {
        return (DynamicCluster.NodePlacementStrategy)Preconditions.checkNotNull(this.getConfig(ZONE_PLACEMENT_STRATEGY), (Object)"zonePlacementStrategy config");
    }

    @Override
    public void setZoneFailureDetector(DynamicCluster.ZoneFailureDetector val) {
        this.setConfig(ZONE_FAILURE_DETECTOR, Preconditions.checkNotNull((Object)val, (Object)"zoneFailureDetector"));
    }

    protected DynamicCluster.ZoneFailureDetector getZoneFailureDetector() {
        return (DynamicCluster.ZoneFailureDetector)Preconditions.checkNotNull(this.getConfig(ZONE_FAILURE_DETECTOR), (Object)"zoneFailureDetector config");
    }

    protected EntitySpec<?> getMemberSpec() {
        return (EntitySpec)this.getConfig(MEMBER_SPEC);
    }

    @Deprecated
    protected EntityFactory<?> getFactory() {
        return (EntityFactory)this.getConfig(FACTORY);
    }

    @Override
    public void setMemberSpec(EntitySpec<?> memberSpec) {
        this.setConfigEvenIfOwned(MEMBER_SPEC, memberSpec);
    }

    @Override
    @Deprecated
    public void setFactory(EntityFactory<?> factory) {
        this.setConfigEvenIfOwned(FACTORY, factory);
    }

    private Location getLocation() {
        Collection<? extends Location> ll = Locations.getLocationsCheckingAncestors(this.getLocations(), this);
        try {
            return (Location)Iterables.getOnlyElement(ll);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            if (ll.isEmpty()) {
                throw new IllegalStateException("No location available for " + this);
            }
            throw new IllegalStateException("Ambiguous location for " + this + "; expected one but had " + ll);
        }
    }

    protected boolean isAvailabilityZoneEnabled() {
        return (Boolean)this.getConfig(ENABLE_AVAILABILITY_ZONES);
    }

    protected boolean isQuarantineEnabled() {
        return (Boolean)this.getConfig(QUARANTINE_FAILED_ENTITIES);
    }

    protected QuarantineGroup getQuarantineGroup() {
        return (QuarantineGroup)this.getAttribute(QUARANTINE_GROUP);
    }

    protected int getInitialQuorumSize() {
        int initialSize = (Integer)this.getConfig(INITIAL_SIZE);
        int initialQuorumSize = (Integer)this.getConfig(INITIAL_QUORUM_SIZE);
        if (initialQuorumSize < 0) {
            initialQuorumSize = initialSize;
        }
        if (initialQuorumSize > initialSize) {
            LOG.warn("On start of cluster {}, misconfigured initial quorum size {} greater than initial size{}; using {}", new Object[]{initialQuorumSize, initialSize, initialSize});
            initialQuorumSize = initialSize;
        }
        return initialQuorumSize;
    }

    @Override
    public void start(Collection<? extends Location> locsO) {
        if (locsO != null) {
            Preconditions.checkArgument((locsO.size() <= 1 ? 1 : 0) != 0, (String)"Wrong number of locations supplied to start %s: %s", (Object[])new Object[]{this, locsO});
            this.addLocations(locsO);
        }
        Location loc = this.getLocation();
        EntitySpec spec = (EntitySpec)this.getConfig(MEMBER_SPEC);
        if (spec != null) {
            this.setDefaultDisplayName("Cluster of " + JavaClassNames.simpleClassName((Class)spec.getType()) + " (" + loc + ")");
        }
        if (this.isAvailabilityZoneEnabled()) {
            this.setAttribute(SUB_LOCATIONS, this.findSubLocations(loc));
        }
        ServiceStateLogic.setExpectedState(this, Lifecycle.STARTING);
        ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((EntityLocal)this, START);
        try {
            this.doStart();
            DynamicTasks.waitForLast();
        }
        catch (Exception e) {
            ServiceStateLogic.ServiceProblemsLogic.updateProblemsIndicator((EntityLocal)this, START, (Object)("start failed with error: " + e));
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            ServiceStateLogic.setExpectedState(this, Lifecycle.RUNNING);
        }
    }

    protected void doStart() {
        QuarantineGroup quarantineGroup;
        if (this.isQuarantineEnabled() && ((quarantineGroup = (QuarantineGroup)this.getAttribute(QUARANTINE_GROUP)) == null || !Entities.isManaged(quarantineGroup))) {
            quarantineGroup = (QuarantineGroup)this.addChild((EntitySpec)EntitySpec.create(QuarantineGroup.class).displayName("quarantine"));
            Entities.manage(quarantineGroup);
            this.setAttribute(QUARANTINE_GROUP, quarantineGroup);
        }
        int initialSize = (Integer)this.getConfig(INITIAL_SIZE);
        int initialQuorumSize = this.getInitialQuorumSize();
        Exception internalError = null;
        try {
            this.resize(initialSize);
        }
        catch (Exception e) {
            Exceptions.propagateIfFatal((Throwable)e);
            LOG.debug("Error resizing " + this + " to size " + initialSize + " (collecting and handling): " + e, (Throwable)e);
            internalError = e;
        }
        Iterable<Task<?>> failed = Tasks.failed(Tasks.children(Tasks.current()));
        boolean noFailed = Iterables.isEmpty(failed);
        boolean severalFailed = Iterables.size(failed) > 1;
        int currentSize = this.getCurrentSize();
        if (currentSize < initialQuorumSize) {
            String message = currentSize == 0 && !noFailed ? (severalFailed ? "All nodes in cluster " + this + " failed" : "Node in cluster " + this + " failed") : "On start of cluster " + this + ", failed to get to initial size of " + initialSize + "; size is " + this.getCurrentSize() + (initialQuorumSize != initialSize ? " (initial quorum size is " + initialQuorumSize + ")" : "");
            Throwable firstError = Tasks.getError((Task)Maybe.next(failed.iterator()).orNull());
            if (firstError == null && internalError != null) {
                firstError = internalError;
            }
            if (firstError != null) {
                message = severalFailed ? message + "; first failure is: " + Exceptions.collapseText((Throwable)firstError) : message + ": " + Exceptions.collapseText((Throwable)firstError);
            }
            throw new IllegalStateException(message, firstError);
        }
        if (currentSize < initialSize) {
            LOG.warn("On start of cluster {}, size {} reached initial minimum quorum size of {} but did not reach desired size {}; continuing", new Object[]{this, currentSize, initialQuorumSize, initialSize});
        }
        for (Policy it : this.getPolicies()) {
            it.resume();
        }
    }

    protected List<Location> findSubLocations(Location loc) {
        List<Location> subLocations;
        if (!loc.hasExtension(AvailabilityZoneExtension.class)) {
            throw new IllegalStateException("Availability zone extension not supported for location " + loc);
        }
        AvailabilityZoneExtension zoneExtension = (AvailabilityZoneExtension)loc.getExtension(AvailabilityZoneExtension.class);
        Collection zoneNames = (Collection)this.getConfig(AVAILABILITY_ZONE_NAMES);
        Integer numZones = (Integer)this.getConfig(NUM_AVAILABILITY_ZONES);
        if (zoneNames == null || zoneNames.isEmpty()) {
            if (numZones != null) {
                subLocations = zoneExtension.getSubLocations(numZones);
                Preconditions.checkArgument((numZones > 0 ? 1 : 0) != 0, (String)"numZones must be greater than zero: %s", (Object[])new Object[]{numZones});
                if (numZones > subLocations.size()) {
                    throw new IllegalStateException("Number of required zones (" + numZones + ") not satisfied in " + loc + "; only " + subLocations.size() + " available: " + subLocations);
                }
            } else {
                subLocations = zoneExtension.getAllSubLocations();
            }
        } else {
            subLocations = zoneExtension.getSubLocationsByName((Predicate<? super String>)StringPredicates.equalToAny((Iterable)zoneNames), zoneNames.size());
            if (zoneNames.size() > subLocations.size()) {
                throw new IllegalStateException("Number of required zones (" + zoneNames.size() + " - " + zoneNames + ") not satisfied in " + loc + "; only " + subLocations.size() + " available: " + subLocations);
            }
        }
        LOG.info("Returning {} sub-locations: {}", (Object)subLocations.size(), (Object)Iterables.toString(subLocations));
        return subLocations;
    }

    @Override
    public void stop() {
        ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPING);
        try {
            for (Policy it : this.getPolicies()) {
                it.suspend();
            }
            int size = this.getCurrentSize();
            if (size > 0) {
                this.shrink(-size);
            }
            this.resize(0);
            StartableMethods.stop(this);
            ServiceStateLogic.setExpectedState(this, Lifecycle.STOPPED);
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState(this, Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    @Override
    public void restart() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer resize(Integer desiredSize) {
        Object object = this.mutex;
        synchronized (object) {
            int originalSize = this.getCurrentSize();
            int delta = desiredSize - originalSize;
            if (delta != 0) {
                LOG.info("Resize {} from {} to {}", new Object[]{this, originalSize, desiredSize});
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("Resize no-op {} from {} to {}", new Object[]{this, originalSize, desiredSize});
            }
            this.resizeByDelta(delta);
        }
        return this.getCurrentSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String replaceMember(String memberId) {
        Entity member = this.getEntityManager().getEntity(memberId);
        LOG.info("In {}, replacing member {} ({})", new Object[]{this, memberId, member});
        if (member == null) {
            throw new NoSuchElementException("In " + this + ", entity " + memberId + " cannot be resolved, so not replacing");
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.getMembers().contains(member)) {
                throw new NoSuchElementException("In " + this + ", entity " + member + " is not a member so not replacing");
            }
            Location memberLoc = null;
            if (this.isAvailabilityZoneEnabled()) {
                List<Location> subLocations = this.findSubLocations(this.getLocation());
                Collection actualMemberLocs = member.getLocations();
                boolean foundMatch = false;
                Iterator iter = actualMemberLocs.iterator();
                while (!foundMatch && iter.hasNext()) {
                    Location actualMemberLoc;
                    Location contenderMemberLoc = actualMemberLoc = (Location)iter.next();
                    do {
                        if (subLocations.contains(contenderMemberLoc)) {
                            memberLoc = contenderMemberLoc;
                            foundMatch = true;
                            LOG.debug("In {} replacing member {} ({}), inferred its sub-location is {}", new Object[]{this, memberId, member, memberLoc});
                        }
                        contenderMemberLoc = contenderMemberLoc.getParent();
                    } while (!foundMatch && contenderMemberLoc != null);
                }
                if (!foundMatch) {
                    if (actualMemberLocs.isEmpty()) {
                        memberLoc = subLocations.get(0);
                        LOG.warn("In {} replacing member {} ({}), has no locations; falling back to first availability zone: {}", new Object[]{this, memberId, member, memberLoc});
                    } else {
                        memberLoc = (Location)Iterables.tryFind((Iterable)actualMemberLocs, (Predicate)Predicates.instanceOf(MachineProvisioningLocation.class)).or(Iterables.getFirst((Iterable)actualMemberLocs, null));
                        LOG.warn("In {} replacing member {} ({}), could not find matching sub-location; falling back to its actual location: {}", new Object[]{this, memberId, member, memberLoc});
                    }
                } else if (memberLoc == null) {
                    throw new IllegalStateException("Unexpected condition! cluster=" + this + "; member=" + member + "; actualMemberLocs=" + actualMemberLocs);
                }
            } else {
                memberLoc = this.getLocation();
            }
            Entity replacement = this.replaceMember(member, memberLoc, (Map<?, ?>)ImmutableMap.of());
            return replacement.getId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Entity replaceMember(Entity member, Location memberLoc, Map<?, ?> extraFlags) {
        Object object = this.mutex;
        synchronized (object) {
            ReferenceWithError<Optional<Entity>> added = this.addInSingleLocation(memberLoc, extraFlags);
            if (!((Optional)added.getWithoutError()).isPresent()) {
                String msg = String.format("In %s, failed to grow, to replace %s; not removing", this, member);
                if (added.hasError()) {
                    throw new IllegalStateException(msg, added.getError());
                }
                throw new IllegalStateException(msg);
            }
            try {
                this.stopAndRemoveNode(member);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                throw new StopFailedRuntimeException("replaceMember failed to stop and remove old member " + member.getId(), e);
            }
            return (Entity)((Optional)added.getWithError()).get();
        }
    }

    protected Multimap<Location, Entity> getMembersByLocation() {
        LinkedHashMultimap result = LinkedHashMultimap.create();
        for (Entity member : this.getMembers()) {
            Collection memberLocs = member.getLocations();
            Location memberLoc = (Location)Iterables.getFirst((Iterable)memberLocs, null);
            if (memberLoc == null) continue;
            result.put((Object)memberLoc, (Object)member);
        }
        return result;
    }

    protected List<Location> getNonFailedSubLocations() {
        ArrayList result = Lists.newArrayList();
        LinkedHashSet failed = Sets.newLinkedHashSet();
        List<Location> subLocations = this.findSubLocations(this.getLocation());
        Set oldFailedSubLocations = (Set)this.getAttribute(FAILED_SUB_LOCATIONS);
        if (oldFailedSubLocations == null) {
            oldFailedSubLocations = ImmutableSet.of();
        }
        for (Location subLocation : subLocations) {
            if (this.getZoneFailureDetector().hasFailed(subLocation)) {
                failed.add(subLocation);
                continue;
            }
            result.add(subLocation);
        }
        Sets.SetView newlyFailed = Sets.difference((Set)failed, (Set)oldFailedSubLocations);
        Sets.SetView newlyRecovered = Sets.difference((Set)oldFailedSubLocations, (Set)failed);
        this.setAttribute(FAILED_SUB_LOCATIONS, failed);
        this.setAttribute(SUB_LOCATIONS, result);
        if (newlyFailed.size() > 0) {
            LOG.warn("Detected probably zone failures for {}: {}", (Object)this, (Object)newlyFailed);
        }
        if (newlyRecovered.size() > 0) {
            LOG.warn("Detected probably zone recoveries for {}: {}", (Object)this, (Object)newlyRecovered);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Entity> resizeByDelta(int delta) {
        Object object = this.mutex;
        synchronized (object) {
            if (delta > 0) {
                return this.grow(delta);
            }
            if (delta < 0) {
                return this.shrink(delta);
            }
            return ImmutableList.of();
        }
    }

    protected Collection<Entity> grow(int delta) {
        List<Object> chosenLocations;
        List memberLocations;
        Preconditions.checkArgument((delta > 0 ? 1 : 0) != 0, (Object)"Must call grow with positive delta.");
        List list = memberLocations = this.getMemberSpec() == null ? null : this.getMemberSpec().getLocations();
        if (memberLocations != null && memberLocations.size() > 0) {
            if (this.isAvailabilityZoneEnabled()) {
                LOG.warn("Cluster {} has availability-zone enabled, but memberSpec overrides location with {}; using memberSpec's location; availability-zone behaviour will not apply", (Object)this, (Object)memberLocations);
            }
            chosenLocations = Collections.nCopies(delta, memberLocations.get(0));
        } else if (this.isAvailabilityZoneEnabled()) {
            List<Location> subLocations = this.getNonFailedSubLocations();
            Multimap<Location, Entity> membersByLocation = this.getMembersByLocation();
            chosenLocations = this.getZonePlacementStrategy().locationsForAdditions(membersByLocation, subLocations, delta);
            if (chosenLocations.size() != delta) {
                throw new IllegalStateException("Node placement strategy chose " + Iterables.size(chosenLocations) + ", when expected delta " + delta + " in " + this);
            }
        } else {
            chosenLocations = Collections.nCopies(delta, this.getLocation());
        }
        return (Collection)this.addInEachLocation((Iterable<Location>)chosenLocations, (Map<?, ?>)ImmutableMap.of()).getWithError();
    }

    protected Collection<Entity> shrink(int delta) {
        Preconditions.checkArgument((delta < 0 ? 1 : 0) != 0, (Object)"Must call shrink with negative delta.");
        int size = this.getCurrentSize();
        if (-delta > size) {
            LOG.warn("Call to shrink " + this + " by " + delta + " when size is " + size + "; amending");
            delta = -size;
        }
        if (delta == 0) {
            return ImmutableList.of();
        }
        List<Entity> removedEntities = this.pickAndRemoveMembers(delta * -1);
        Task<?> invoke = Entities.invokeEffector((EntityLocal)this, Iterables.filter(removedEntities, Startable.class), Startable.STOP, Collections.emptyMap());
        try {
            invoke.get();
            List<Entity> list = removedEntities;
            return list;
        }
        catch (Exception e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            for (Entity removedEntity : removedEntities) {
                this.discardNode(removedEntity);
            }
        }
    }

    protected ReferenceWithError<Optional<Entity>> addInSingleLocation(Location location, Map<?, ?> flags) {
        Optional result;
        ReferenceWithError<Collection<Entity>> added = this.addInEachLocation((Iterable<Location>)ImmutableList.of((Object)location), flags);
        Optional optional = result = Iterables.isEmpty((Iterable)((Iterable)added.getWithoutError())) ? Optional.absent() : Optional.of((Object)Iterables.getOnlyElement((Iterable)((Iterable)added.get())));
        if (!added.hasError()) {
            return ReferenceWithError.newInstanceWithoutError((Object)result);
        }
        if (added.masksErrorIfPresent()) {
            return ReferenceWithError.newInstanceMaskingError((Object)result, (Throwable)added.getError());
        }
        return ReferenceWithError.newInstanceThrowingError((Object)result, (Throwable)added.getError());
    }

    protected ReferenceWithError<Collection<Entity>> addInEachLocation(Iterable<Location> locations, Map<?, ?> flags) {
        ArrayList addedEntities = Lists.newArrayList();
        LinkedHashMap addedEntityLocations = Maps.newLinkedHashMap();
        LinkedHashMap tasks = Maps.newLinkedHashMap();
        for (Location loc : locations) {
            Entity entity = this.addNode(loc, flags);
            addedEntities.add(entity);
            addedEntityLocations.put(entity, loc);
            if (!(entity instanceof Startable)) continue;
            ImmutableMap args = ImmutableMap.of((Object)"locations", (Object)ImmutableList.of((Object)loc));
            Task task = Effectors.invocation(entity, Startable.START, args).asTask();
            tasks.put(entity, task);
        }
        Task<List<?>> parallel = Tasks.parallel("starting " + tasks.size() + " node" + Strings.s((int)tasks.size()) + " (parallel)", tasks.values());
        TaskTags.markInessential(parallel);
        DynamicTasks.queueIfPossible(parallel).orSubmitAsync(this);
        Map<Entity, Throwable> errors = this.waitForTasksOnEntityStart(tasks);
        if (this.isAvailabilityZoneEnabled()) {
            for (Map.Entry entry : addedEntityLocations.entrySet()) {
                Entity entity = (Entity)entry.getKey();
                Location loc = (Location)entry.getValue();
                Throwable err = errors.get(entity);
                if (err == null) {
                    this.getZoneFailureDetector().onStartupSuccess(loc, entity);
                    continue;
                }
                this.getZoneFailureDetector().onStartupFailure(loc, entity, err);
            }
        }
        MutableList result = MutableList.builder().addAll((Iterable)addedEntities).removeAll(errors.keySet()).build();
        if (!errors.isEmpty()) {
            if (this.isQuarantineEnabled()) {
                this.quarantineFailedNodes(errors.keySet());
            } else {
                this.cleanupFailedNodes(errors.keySet());
            }
            return ReferenceWithError.newInstanceMaskingError((Object)result, (Throwable)Exceptions.create(errors.values()));
        }
        return ReferenceWithError.newInstanceWithoutError((Object)result);
    }

    protected void quarantineFailedNodes(Collection<Entity> failedEntities) {
        for (Entity entity : failedEntities) {
            this.emit(ENTITY_QUARANTINED, entity);
            this.getQuarantineGroup().addMember(entity);
            this.removeMember(entity);
        }
    }

    protected void cleanupFailedNodes(Collection<Entity> failedEntities) {
        for (Entity entity : failedEntities) {
            this.discardNode(entity);
        }
    }

    protected Map<Entity, Throwable> waitForTasksOnEntityStart(Map<? extends Entity, ? extends Task<?>> tasks) {
        LinkedHashMap errors = Maps.newLinkedHashMap();
        for (Map.Entry<Entity, Task<?>> entry : tasks.entrySet()) {
            Entity entity = entry.getKey();
            Task<?> task = entry.getValue();
            try {
                task.get();
            }
            catch (InterruptedException e) {
                throw Exceptions.propagate((Throwable)e);
            }
            catch (Throwable t) {
                Throwable interesting = Exceptions.getFirstInteresting((Throwable)t);
                LOG.error("Cluster " + this + " failed to start entity " + entity + " (removing): " + interesting, interesting);
                LOG.debug("Trace for: Cluster " + this + " failed to start entity " + entity + " (removing): " + t, t);
                errors.put(entity, t);
            }
        }
        return errors;
    }

    @Override
    public boolean removeChild(Entity child) {
        boolean changed = super.removeChild(child);
        if (changed) {
            this.removeMember(child);
        }
        return changed;
    }

    protected Map<?, ?> getCustomChildFlags() {
        return (Map)this.getConfig(CUSTOM_CHILD_FLAGS);
    }

    @Override
    public Entity addNode(Location loc, Map<?, ?> extraFlags) {
        MutableMap createFlags = MutableMap.builder().putAll(this.getCustomChildFlags()).putAll(extraFlags).build();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Creating and adding a node to cluster {}({}) with properties {}", new Object[]{this, this.getId(), createFlags});
        }
        Entity entity = this.createNode(loc, (Map<?, ?>)createFlags);
        ((EntityLocal)entity).setAttribute(CLUSTER_MEMBER, (Object)true);
        ((EntityLocal)entity).setAttribute(CLUSTER, (Object)this);
        Entities.manage(entity);
        this.addMember(entity);
        return entity;
    }

    protected Entity createNode(@Nullable Location loc, Map<?, ?> flags) {
        EntitySpec<?> memberSpec = null;
        if (this.getMembers().isEmpty()) {
            memberSpec = (EntitySpec<?>)this.getConfig(FIRST_MEMBER_SPEC);
        }
        if (memberSpec == null) {
            memberSpec = this.getMemberSpec();
        }
        if (memberSpec != null) {
            return this.addChild(EntitySpec.create(memberSpec).configure(flags).location(loc));
        }
        EntityFactory<?> factory = this.getFactory();
        if (factory == null) {
            throw new IllegalStateException("No member spec nor entity factory supplied for dynamic cluster " + this);
        }
        EntityFactory<Object> factoryToUse = factory instanceof EntityFactoryForLocation ? ((EntityFactoryForLocation)((Object)factory)).newFactoryForLocation(loc) : factory;
        Object entity = factoryToUse.newEntity(flags, this);
        if (entity == null) {
            throw new IllegalStateException("EntityFactory factory routine returned null entity, in " + this);
        }
        if (entity.getParent() == null) {
            entity.setParent((Entity)this);
        }
        return entity;
    }

    @Deprecated
    protected Entity createNode(Map<?, ?> flags) {
        return this.createNode(this.getLocation(), flags);
    }

    protected List<Entity> pickAndRemoveMembers(int delta) {
        if (delta == 0) {
            return Lists.newArrayList();
        }
        if (delta == 1 && !this.isAvailabilityZoneEnabled()) {
            Maybe<Entity> member = this.tryPickAndRemoveMember();
            return member.isPresent() ? ImmutableList.of((Object)member.get()) : ImmutableList.of();
        }
        Preconditions.checkState((this.getMembers().size() > 0 ? 1 : 0) != 0, (Object)("Attempt to remove a node (delta " + delta + ") when members is empty, from cluster " + this));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing a node from {}", (Object)this);
        }
        if (this.isAvailabilityZoneEnabled()) {
            Multimap<Location, Entity> membersByLocation = this.getMembersByLocation();
            List<Entity> entities = this.getZonePlacementStrategy().entitiesToRemove(membersByLocation, delta);
            Preconditions.checkState((entities.size() == delta ? 1 : 0) != 0, (String)"Incorrect num entity chosen for removal from %s (%s when expected %s)", (Object[])new Object[]{this.getId(), entities.size(), delta});
            for (Entity entity : entities) {
                this.removeMember(entity);
            }
            return entities;
        }
        ArrayList entities = Lists.newArrayList();
        for (int i = 0; i < delta; ++i) {
            Maybe<Entity> member = this.tryPickAndRemoveMember();
            if (!member.isPresent()) continue;
            entities.add(member.get());
        }
        return entities;
    }

    private Maybe<Entity> tryPickAndRemoveMember() {
        assert (!this.isAvailabilityZoneEnabled()) : "should instead call pickAndRemoveMembers(int) if using availability zones";
        Collection<Entity> members = this.getMembers();
        if (members.isEmpty()) {
            return Maybe.absent();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing a node from {}", (Object)this);
        }
        Entity entity = (Entity)this.getRemovalStrategy().apply(members);
        Preconditions.checkNotNull((Object)entity, (Object)("No entity chosen for removal from " + this.getId()));
        this.removeMember(entity);
        return Maybe.of((Object)entity);
    }

    protected void discardNode(Entity entity) {
        this.removeMember(entity);
        Entities.unmanage(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopAndRemoveNode(Entity member) {
        block5: {
            this.removeMember(member);
            try {
                if (!(member instanceof Startable)) break block5;
                Task task = member.invoke(Startable.STOP, Collections.emptyMap());
                try {
                    task.get();
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
            finally {
                Entities.unmanage(member);
            }
        }
    }

    static {
        TypeCoercions.registerAdapter(String.class, DynamicCluster.NodePlacementStrategy.class, new Function<String, DynamicCluster.NodePlacementStrategy>(){

            public DynamicCluster.NodePlacementStrategy apply(String input) {
                ClassLoader classLoader = DynamicCluster.NodePlacementStrategy.class.getClassLoader();
                Optional strategy = Reflections.invokeConstructorWithArgs((ClassLoader)classLoader, (String)input, (Object[])new Object[0]);
                if (strategy.isPresent()) {
                    return (DynamicCluster.NodePlacementStrategy)strategy.get();
                }
                throw new IllegalStateException("Failed to create NodePlacementStrategy " + input);
            }
        });
        TypeCoercions.registerAdapter(String.class, DynamicCluster.ZoneFailureDetector.class, new Function<String, DynamicCluster.ZoneFailureDetector>(){

            public DynamicCluster.ZoneFailureDetector apply(String input) {
                ClassLoader classLoader = DynamicCluster.ZoneFailureDetector.class.getClassLoader();
                Optional detector = Reflections.invokeConstructorWithArgs((ClassLoader)classLoader, (String)input, (Object[])new Object[0]);
                if (detector.isPresent()) {
                    return (DynamicCluster.ZoneFailureDetector)detector.get();
                }
                throw new IllegalStateException("Failed to create ZoneFailureDetector " + input);
            }
        });
        RendererHints.register(FIRST, RendererHints.namedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        RendererHints.register(CLUSTER, RendererHints.namedActionWithUrl("Open", DelegateEntity.EntityUrl.entityUrl()));
        LOG = LoggerFactory.getLogger(DynamicClusterImpl.class);
        defaultRemovalStrategy = new Function<Collection<Entity>, Entity>(){

            public Entity apply(Collection<Entity> contenders) {
                long newestTime = 0L;
                Entity newest = null;
                for (Entity contender : contenders) {
                    boolean newer;
                    boolean bl = newer = contender.getCreationTime() > newestTime;
                    if ((!(contender instanceof Startable) || !newer) && (newest instanceof Startable || !(contender instanceof Startable) && !newer)) continue;
                    newest = contender;
                    newestTime = contender.getCreationTime();
                }
                return newest;
            }
        };
    }
}

