/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.group;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.AbstractGroup;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityFactory;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.group.Cluster;
import brooklyn.entity.group.DynamicClusterImpl;
import brooklyn.entity.group.QuarantineGroup;
import brooklyn.entity.group.zoneaware.BalancingNodePlacementStrategy;
import brooklyn.entity.group.zoneaware.ProportionalZoneFailureDetector;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.entity.trait.MemberReplaceable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.location.Location;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@ImplementedBy(value=DynamicClusterImpl.class)
public interface DynamicCluster
extends AbstractGroup,
Cluster,
MemberReplaceable {
    public static final MethodEffector<Collection<Entity>> RESIZE_BY_DELTA = new MethodEffector(DynamicCluster.class, "resizeByDelta");
    @SetFromFlag(value="quarantineFailedEntities")
    public static final ConfigKey<Boolean> QUARANTINE_FAILED_ENTITIES = ConfigKeys.newBooleanConfigKey("dynamiccluster.quarantineFailedEntities", "If true, will quarantine entities that fail to start; if false, will get rid of them (i.e. delete them)", true);
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = Attributes.SERVICE_STATE_ACTUAL;
    public static final BasicNotificationSensor<Entity> ENTITY_QUARANTINED = new BasicNotificationSensor<Entity>(Entity.class, "dynamiccluster.entityQuarantined", "Entity failed to start, and has been quarantined");
    public static final AttributeSensor<QuarantineGroup> QUARANTINE_GROUP = Sensors.newSensor(QuarantineGroup.class, "dynamiccluster.quarantineGroup", "Group of quarantined entities that failed to start");
    @SetFromFlag(value="initialQuorumSize")
    public static final ConfigKey<Integer> INITIAL_QUORUM_SIZE = ConfigKeys.newIntegerConfigKey("cluster.initial.quorumSize", "Initial cluster quorum size - number of initial nodes that must have been successfully started to report success (if < 0, then use value of INITIAL_SIZE)", -1);
    @SetFromFlag(value="memberSpec")
    public static final ConfigKey<EntitySpec<?>> MEMBER_SPEC = ConfigKeys.newConfigKey(new TypeToken<EntitySpec<?>>(){}, "dynamiccluster.memberspec", "entity spec for creating new cluster members", null);
    @SetFromFlag(value="firstMemberSpec")
    public static final ConfigKey<EntitySpec<?>> FIRST_MEMBER_SPEC = ConfigKeys.newConfigKey(new TypeToken<EntitySpec<?>>(){}, "dynamiccluster.firstmemberspec", "entity spec for creating new cluster members, used for the very first member if different", null);
    @Deprecated
    @SetFromFlag(value="factory")
    public static final ConfigKey<EntityFactory> FACTORY = ConfigKeys.newConfigKey(EntityFactory.class, "dynamiccluster.factory", "factory for creating new cluster members", null);
    @SetFromFlag(value="removalStrategy")
    public static final ConfigKey<Function<Collection<Entity>, Entity>> REMOVAL_STRATEGY = ConfigKeys.newConfigKey(new TypeToken<Function<Collection<Entity>, Entity>>(){}, "dynamiccluster.removalstrategy", "strategy for deciding what to remove when down-sizing", null);
    @SetFromFlag(value="customChildFlags")
    public static final ConfigKey<Map> CUSTOM_CHILD_FLAGS = ConfigKeys.newConfigKey(Map.class, "dynamiccluster.customChildFlags", "Additional flags to be passed to children when they are being created", ImmutableMap.of());
    @SetFromFlag(value="enableAvailabilityZones")
    public static final ConfigKey<Boolean> ENABLE_AVAILABILITY_ZONES = ConfigKeys.newBooleanConfigKey("dynamiccluster.zone.enable", "Whether to use availability zones, or just deploy everything into the generic location", false);
    @SetFromFlag(value="zoneFailureDetector")
    public static final ConfigKey<ZoneFailureDetector> ZONE_FAILURE_DETECTOR = ConfigKeys.newConfigKey(ZoneFailureDetector.class, "dynamiccluster.zone.failureDetector", "Zone failure detector", new ProportionalZoneFailureDetector(2, Duration.ONE_HOUR, 0.9));
    @SetFromFlag(value="zonePlacementStrategy")
    public static final ConfigKey<NodePlacementStrategy> ZONE_PLACEMENT_STRATEGY = ConfigKeys.newConfigKey(NodePlacementStrategy.class, "dynamiccluster.zone.placementStrategy", "Node placement strategy", new BalancingNodePlacementStrategy());
    @SetFromFlag(value="availabilityZoneNames")
    public static final ConfigKey<Collection<String>> AVAILABILITY_ZONE_NAMES = ConfigKeys.newConfigKey(new TypeToken<Collection<String>>(){}, "dynamiccluster.availabilityZones", "availability zones to use (if non-null, overrides other configuration)", null);
    @SetFromFlag(value="numAvailabilityZones")
    public static final ConfigKey<Integer> NUM_AVAILABILITY_ZONES = ConfigKeys.newIntegerConfigKey("dynamiccluster.numAvailabilityZones", "number of availability zones to use (will attempt to auto-discover this number)");
    public static final AttributeSensor<List<Location>> SUB_LOCATIONS = new BasicAttributeSensor<List<Location>>(new TypeToken<List<Location>>(){}, "dynamiccluster.subLocations", "Locations for each availability zone to use");
    public static final AttributeSensor<Set<Location>> FAILED_SUB_LOCATIONS = new BasicAttributeSensor<Set<Location>>(new TypeToken<Set<Location>>(){}, "dynamiccluster.failedSubLocations", "Sub locations that seem to have failed");
    public static final AttributeSensor<Boolean> CLUSTER_MEMBER = Sensors.newBooleanSensor("cluster.member", "Set on an entity if it is a member of a cluster");
    public static final AttributeSensor<Entity> CLUSTER = Sensors.newSensor(Entity.class, "cluster.entity", "The cluster an entity is a member of");

    @Effector(description="Changes the size of the cluster.")
    public Collection<Entity> resizeByDelta(@EffectorParam(name="delta", description="The change in number of nodes") int var1);

    public void setRemovalStrategy(Function<Collection<Entity>, Entity> var1);

    public void setZonePlacementStrategy(NodePlacementStrategy var1);

    public void setZoneFailureDetector(ZoneFailureDetector var1);

    public void setMemberSpec(EntitySpec<?> var1);

    @Deprecated
    public void setFactory(EntityFactory<?> var1);

    public Entity addNode(Location var1, Map<?, ?> var2);

    @Beta
    public static interface ZoneFailureDetector {
        public void onStartupSuccess(Location var1, Entity var2);

        public void onStartupFailure(Location var1, Entity var2, Throwable var3);

        public boolean hasFailed(Location var1);
    }

    @Beta
    public static interface NodePlacementStrategy {
        public List<Location> locationsForAdditions(Multimap<Location, Entity> var1, Collection<? extends Location> var2, int var3);

        public List<Entity> entitiesToRemove(Multimap<Location, Entity> var1, int var2);
    }
}

