/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.effector;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.ParameterType;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.location.basic.Machines;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskQueueingContext;
import brooklyn.management.internal.EffectorUtils;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.task.DynamicSequentialTask;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.TaskBuilder;
import brooklyn.util.task.Tasks;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class EffectorTasks {
    private static final Logger log = LoggerFactory.getLogger(EffectorTasks.class);

    public static <T> ConfigKey<T> asConfigKey(ParameterType<T> t) {
        return ConfigKeys.newConfigKey(t.getParameterClass(), t.getName());
    }

    public static <T> ParameterTask<T> parameter(ParameterType<T> t) {
        return new ParameterTask<T>(EffectorTasks.asConfigKey(t)).name("parameter " + t);
    }

    public static <T> ParameterTask<T> parameter(Class<T> type, String name) {
        return new ParameterTask<T>(ConfigKeys.newConfigKey(type, name)).name("parameter " + name + " (" + type + ")");
    }

    public static <T> ParameterTask<T> parameter(ConfigKey<T> p) {
        return new ParameterTask<T>(p);
    }

    public static <T> EffectorTaskFactory<T> of(final Task<T> task) {
        return new EffectorTaskFactory<T>(){

            @Override
            public Task<T> newTask(Entity entity, Effector<T> effector, ConfigBag parameters) {
                return task;
            }
        };
    }

    public static Entity findEntity() {
        return (Entity)Preconditions.checkNotNull((Object)BrooklynTaskTags.getTargetOrContextEntity(Tasks.current()), (Object)"This must be executed in a task whose execution context has a target or context entity (i.e. it must be run from within an effector)");
    }

    public static <T extends Entity> T findEntity(Class<T> type) {
        Entity t = EffectorTasks.findEntity();
        return (T)((Entity)Reflections.cast((Object)t, type));
    }

    public static SshMachineLocation findSshMachine() {
        return EffectorTasks.getSshMachine(EffectorTasks.findEntity());
    }

    public static SshMachineLocation getSshMachine(Entity entity) {
        try {
            return (SshMachineLocation)Machines.findUniqueSshMachineLocation(entity.getLocations()).get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Entity " + entity + " (in " + Tasks.current() + ") requires a single SshMachineLocation, but has " + entity.getLocations(), e);
        }
    }

    public static WinRmMachineLocation getWinRmMachine(Entity entity) {
        try {
            return (WinRmMachineLocation)Machines.findUniqueWinRmMachineLocation(entity.getLocations()).get();
        }
        catch (Exception e) {
            throw new IllegalStateException("Entity " + entity + " (in " + Tasks.current() + ") requires a single WinRmMachineLocation, but has " + entity.getLocations(), e);
        }
    }

    public static class ParameterTask<T>
    implements EffectorTaskFactory<T> {
        final ConfigKey<T> p;
        private TaskBuilder<T> builder;

        public ParameterTask(ConfigKey<T> p) {
            this.p = p;
            this.builder = Tasks.builder().name("parameter " + p);
        }

        public ParameterTask<T> name(String taskName) {
            this.builder.name(taskName);
            return this;
        }

        @Override
        public Task<T> newTask(Entity entity, Effector<T> effector, final ConfigBag parameters) {
            return this.builder.body(new Callable<T>(){

                @Override
                public T call() throws Exception {
                    return parameters.get(ParameterTask.this.p);
                }
            }).build();
        }
    }

    static class EffectorMarkingTaskFactory<T>
    implements EffectorTaskFactory<T> {
        private final EffectorTaskFactory<T> effectorTaskFactory;

        public EffectorMarkingTaskFactory(EffectorTaskFactory<T> effectorTaskFactory) {
            this.effectorTaskFactory = effectorTaskFactory;
        }

        @Override
        public Task<T> newTask(final Entity entity, final Effector<T> effector, ConfigBag parameters) {
            if (this.effectorTaskFactory instanceof EffectorBodyTaskFactory) {
                return this.effectorTaskFactory.newTask(entity, effector, parameters).asTask();
            }
            if (BrooklynTaskTags.isInEffectorTask(Tasks.current(), entity, effector, false)) {
                return this.effectorTaskFactory.newTask(entity, effector, parameters).asTask();
            }
            return new EffectorBodyTaskFactory<T>(new EffectorBody<T>(){

                @Override
                public T call(ConfigBag parameters) {
                    TaskAdaptable t = DynamicTasks.queue(EffectorMarkingTaskFactory.this.effectorTaskFactory.newTask(entity, effector, parameters));
                    return t.asTask().getUnchecked();
                }
            }).newTask(entity, effector, parameters);
        }
    }

    public static class EffectorBodyTaskFactory<T>
    implements EffectorTaskFactory<T> {
        private final EffectorBody<T> effectorBody;

        public EffectorBodyTaskFactory(EffectorBody<T> effectorBody) {
            this.effectorBody = effectorBody;
        }

        @Override
        public Task<T> newTask(final Entity entity, final Effector<T> effector, final ConfigBag parameters) {
            final AtomicReference<2> dst = new AtomicReference<2>();
            dst.set(new DynamicSequentialTask<T>(this.getFlagsForTaskInvocationAt(entity, effector, parameters), new Callable<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T call() throws Exception {
                    try {
                        DynamicTasks.setTaskQueueingContext((TaskQueueingContext)dst.get());
                        Object t = EffectorBodyTaskFactory.this.effectorBody.call(parameters);
                        return t;
                    }
                    finally {
                        DynamicTasks.removeTaskQueueingContext();
                    }
                }
            }){

                @Override
                public void handleException(Throwable throwable) throws Exception {
                    EffectorUtils.handleEffectorException(entity, effector, throwable);
                }
            });
            return (Task)dst.get();
        }

        @Deprecated
        protected final Map<Object, Object> getFlagsForTaskInvocationAt(Entity entity, Effector<?> effector) {
            return this.getFlagsForTaskInvocationAt(entity, effector, null);
        }

        protected Map<Object, Object> getFlagsForTaskInvocationAt(Entity entity, Effector<?> effector, ConfigBag parameters) {
            return EffectorUtils.getTaskFlagsForEffectorInvocation(entity, effector, parameters);
        }
    }

    public static interface EffectorTaskFactory<T> {
        public TaskAdaptable<T> newTask(Entity var1, Effector<T> var2, ConfigBag var3);
    }
}

