/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.effector;

import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.Tasks;
import com.google.common.annotations.Beta;

@Beta
public abstract class EffectorBody<T> {
    public abstract T call(ConfigBag var1);

    protected EntityInternal entity() {
        return (EntityInternal)BrooklynTaskTags.getTargetOrContextEntity(Tasks.current());
    }

    protected <V extends TaskAdaptable<?>> V queue(V task) {
        return DynamicTasks.queue(task);
    }

    protected <V extends TaskAdaptable<?>> void queue(V task1, V task2, V ... tasks) {
        DynamicTasks.queue(task1);
        DynamicTasks.queue(task2);
        for (V task : tasks) {
            DynamicTasks.queue(task);
        }
    }

    protected <V extends TaskFactory<?>> void queue(V task1, V task2, V ... tasks) {
        DynamicTasks.queue(task1.newTask());
        DynamicTasks.queue(task2.newTask());
        for (V task : tasks) {
            DynamicTasks.queue(task.newTask());
        }
    }

    protected <U extends TaskAdaptable<?>> U queue(TaskFactory<U> task) {
        return (U)DynamicTasks.queue(task.newTask());
    }

    @Deprecated
    protected Task<?> last() {
        return DynamicTasks.getTaskQueuingContext().last();
    }

    protected Task<?> waitForLast() {
        return DynamicTasks.waitForLast();
    }

    protected <V> V last(Class<V> type) {
        Task<?> last = this.waitForLast();
        if (last == null) {
            throw new IllegalStateException("No last task available (in " + DynamicTasks.getTaskQueuingContext() + ")");
        }
        if (!Tasks.isQueuedOrSubmitted(last)) {
            throw new IllegalStateException("Last task " + last + " has not been queued or submitted; will not block on its result");
        }
        return TypeCoercions.coerce(last.getUnchecked(), type);
    }
}

