/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.effector;

import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.proxying.EntityInitializer;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.Sensors;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.Boxing;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;

@Beta
public class AddSensor<T>
implements EntityInitializer {
    public static final ConfigKey<String> SENSOR_NAME = ConfigKeys.newStringConfigKey("name", "The name of the sensor to create");
    public static final ConfigKey<Duration> SENSOR_PERIOD = ConfigKeys.newConfigKey(Duration.class, "period", "Period, including units e.g. 1m or 5s or 200ms; default 5 minutes", Duration.FIVE_MINUTES);
    public static final ConfigKey<String> SENSOR_TYPE = ConfigKeys.newStringConfigKey("targetType", "Target type for the value; default String", "java.lang.String");
    protected final String name;
    protected final Duration period;
    protected final String type;
    protected final AttributeSensor<T> sensor;

    public AddSensor(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public AddSensor(ConfigBag params) {
        this.name = (String)Preconditions.checkNotNull((Object)params.get(SENSOR_NAME), (Object)"Name must be supplied when defining a sensor");
        this.period = params.get(SENSOR_PERIOD);
        this.type = params.get(SENSOR_TYPE);
        this.sensor = this.newSensor();
    }

    public void apply(EntityLocal entity) {
        ((EntityInternal)entity).getMutableEntityType().addSensor((Sensor<?>)this.sensor);
    }

    private AttributeSensor<T> newSensor() {
        String className = this.getFullClassName(this.type);
        Class<T> clazz = this.getType(className);
        return Sensors.newSensor(clazz, this.name);
    }

    protected Class<T> getType(String className) {
        try {
            Maybe primitive = Boxing.getPrimitiveType((String)className);
            if (primitive.isPresent()) {
                return (Class)primitive.get();
            }
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            if (!className.contains(".")) {
                try {
                    return Class.forName("java.lang." + className);
                }
                catch (ClassNotFoundException e2) {
                    throw new IllegalArgumentException("Invalid target type for sensor " + this.name + ": " + className + " (also tried java.lang." + className + ")");
                }
            }
            throw new IllegalArgumentException("Invalid target type for sensor " + this.name + ": " + className);
        }
    }

    protected String getFullClassName(String className) {
        if (className.equalsIgnoreCase("string")) {
            return "java.lang.String";
        }
        if (className.equalsIgnoreCase("int") || className.equalsIgnoreCase("integer")) {
            return "java.lang.Integer";
        }
        if (className.equalsIgnoreCase("long")) {
            return "java.lang.Long";
        }
        if (className.equalsIgnoreCase("float")) {
            return "java.lang.Float";
        }
        if (className.equalsIgnoreCase("double")) {
            return "java.lang.Double";
        }
        if (className.equalsIgnoreCase("bool") || className.equalsIgnoreCase("boolean")) {
            return "java.lang.Boolean";
        }
        if (className.equalsIgnoreCase("byte")) {
            return "java.lang.Byte";
        }
        if (className.equalsIgnoreCase("char") || className.equalsIgnoreCase("character")) {
            return "java.lang.Character";
        }
        if (className.equalsIgnoreCase("object")) {
            return "java.lang.Object";
        }
        return className;
    }
}

