/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.effector;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.effector.AddEffector;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.management.internal.EntityManagementUtils;
import brooklyn.util.config.ConfigBag;
import com.google.common.annotations.Beta;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public class AddChildrenEffector
extends AddEffector {
    private static final Logger log = LoggerFactory.getLogger(AddChildrenEffector.class);
    public static final ConfigKey<Object> BLUEPRINT_YAML = ConfigKeys.newConfigKey(Object.class, "blueprint_yaml");
    public static final ConfigKey<String> BLUEPRINT_TYPE = ConfigKeys.newStringConfigKey("blueprint_type");
    public static final ConfigKey<Boolean> AUTO_START = ConfigKeys.newBooleanConfigKey("auto_start");

    public AddChildrenEffector(ConfigBag params) {
        super(AddChildrenEffector.newEffectorBuilder(params).build());
    }

    public AddChildrenEffector(Map<String, String> params) {
        this(ConfigBag.newInstance(params));
    }

    public static Effectors.EffectorBuilder<List<String>> newEffectorBuilder(ConfigBag params) {
        Effectors.EffectorBuilder<List<String>> eff = AddEffector.newEffectorBuilder(List.class, params);
        eff.impl(new Body(eff.buildAbstract(), params));
        return eff;
    }

    protected static class Body
    extends EffectorBody<List<String>> {
        private final Effector<?> effector;
        private final String blueprintBase;
        private final Boolean autostart;

        public Body(Effector<?> eff, ConfigBag params) {
            this.effector = eff;
            String newBlueprint = null;
            Object yaml = params.get(BLUEPRINT_YAML);
            if (yaml instanceof Map) {
                newBlueprint = new Gson().toJson(yaml);
            } else if (yaml instanceof String) {
                newBlueprint = (String)yaml;
            } else if (yaml != null) {
                throw new IllegalArgumentException(this + " requires map or string in " + BLUEPRINT_YAML + "; not " + yaml.getClass() + " (" + yaml + ")");
            }
            String blueprintType = params.get(BLUEPRINT_TYPE);
            if (blueprintType != null) {
                if (newBlueprint != null) {
                    throw new IllegalArgumentException(this + " cannot take both " + BLUEPRINT_TYPE + " and " + BLUEPRINT_YAML);
                }
                newBlueprint = "services: [ { type: " + blueprintType + " } ]";
            }
            if (newBlueprint == null) {
                throw new IllegalArgumentException(this + " requires either " + BLUEPRINT_TYPE + " or " + BLUEPRINT_YAML);
            }
            this.blueprintBase = newBlueprint;
            this.autostart = params.get(AUTO_START);
        }

        @Override
        public List<String> call(ConfigBag params) {
            params = AddEffector.getMergedParams(this.effector, params);
            String blueprint = this.blueprintBase;
            if (!params.isEmpty()) {
                blueprint = blueprint + "\n" + "brooklyn.config: " + new Gson().toJson(params.getAllConfig());
            }
            log.debug(this + " adding children to " + this.entity() + ":\n" + blueprint);
            EntityManagementUtils.CreationResult<List<Entity>, List<String>> result = EntityManagementUtils.addChildren(this.entity(), blueprint, this.autostart);
            log.debug(this + " added children to " + this.entity() + ": " + result.get());
            return (List)result.task().getUnchecked();
        }
    }
}

