/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.drivers.downloads;

import brooklyn.config.StringConfigMap;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.drivers.downloads.BasicDownloadTargets;
import brooklyn.entity.drivers.downloads.DownloadResolverManager;
import brooklyn.entity.drivers.downloads.DownloadSubstituters;
import brooklyn.util.text.Strings;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadProducerFromProperties
implements Function<DownloadResolverManager.DownloadRequirement, DownloadResolverManager.DownloadTargets> {
    private static final Logger LOG = LoggerFactory.getLogger(DownloadProducerFromProperties.class);
    public static final String DOWNLOAD_CONF_PREFIX = "brooklyn.downloads.";
    private final StringConfigMap config;

    public DownloadProducerFromProperties(StringConfigMap config) {
        this.config = config;
    }

    public DownloadResolverManager.DownloadTargets apply(DownloadResolverManager.DownloadRequirement downloadRequirement) {
        List<Rule> rules = this.generateRules();
        BasicDownloadTargets.Builder result = BasicDownloadTargets.builder();
        for (Rule rule : rules) {
            if (!rule.matches(downloadRequirement.getEntityDriver(), downloadRequirement.getAddonName())) continue;
            result.addAll(rule.resolve(downloadRequirement));
        }
        return result.build();
    }

    private List<Rule> generateRules() {
        ArrayList result = Lists.newArrayList();
        Map<String, String> subconfig = DownloadProducerFromProperties.filterAndStripPrefix(this.config.asMapWithStringKeys(), DOWNLOAD_CONF_PREFIX);
        Map<String, String> forall = DownloadProducerFromProperties.filterAndStripPrefix(subconfig, "all.");
        String fallbackUrlForAll = forall.get("fallbackurl");
        String urlForAll = forall.get("url");
        Map<String, String> forSpecificEntities = DownloadProducerFromProperties.filterAndStripPrefix(subconfig, "entity.");
        Map<String, Map<String, String>> splitBySpecificEntity = DownloadProducerFromProperties.splitByPrefix(forSpecificEntities);
        for (Map.Entry<String, Map<String, String>> entry : splitBySpecificEntity.entrySet()) {
            String fallbackUrlForEntity;
            String entityType = entry.getKey();
            Map<String, String> forentity = entry.getValue();
            String urlForEntity = forentity.get("url");
            if (urlForEntity == null) {
                urlForEntity = urlForAll;
            }
            if ((fallbackUrlForEntity = forentity.get("fallbackurl")) == null) {
                fallbackUrlForEntity = fallbackUrlForAll;
            }
            result.add(new EntitySpecificRule(entityType, urlForEntity, fallbackUrlForEntity));
            Map<String, String> forSpecificAddons = DownloadProducerFromProperties.filterAndStripPrefix(forentity, "addon.");
            Map<String, Map<String, String>> splitBySpecificAddon = DownloadProducerFromProperties.splitByPrefix(forSpecificAddons);
            for (Map.Entry<String, Map<String, String>> entry2 : splitBySpecificAddon.entrySet()) {
                String addonName = entry2.getKey();
                Map<String, String> foraddon = entry2.getValue();
                String urlForAddon = foraddon.get("url");
                if (urlForAddon == null) {
                    urlForAddon = urlForEntity;
                }
                String fallbackUrlForAddon = foraddon.get("fallbackurl");
                if (fallbackUrlForEntity == null) {
                    fallbackUrlForAddon = fallbackUrlForEntity;
                }
                result.add(new EntityAddonSpecificRule(entityType, addonName, urlForAddon, fallbackUrlForAddon));
            }
        }
        if (!forall.isEmpty()) {
            result.add(new UniversalRule(urlForAll, fallbackUrlForAll));
        }
        return result;
    }

    private static Map<String, String> filterAndStripPrefix(Map<String, ?> config, String prefix) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, ?> entry : config.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            Object value = entry.getValue();
            result.put(key.substring(prefix.length()), value == null ? null : value.toString());
        }
        return result;
    }

    private static Map<String, Map<String, String>> splitByPrefix(Map<String, String> config) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<String, String> entry : config.entrySet()) {
            String key = entry.getKey();
            String keysuffix = key.substring(key.indexOf(".") + 1);
            String keyprefix = key.substring(0, key.length() - keysuffix.length() - 1);
            String value = entry.getValue();
            Map submap = (Map)result.get(keyprefix);
            if (submap == null) {
                submap = Maps.newLinkedHashMap();
                result.put(keyprefix, submap);
            }
            submap.put(keysuffix, value);
        }
        return result;
    }

    private static class EntityAddonSpecificRule
    extends Rule {
        private final String entityType;
        private final String addonName;

        EntityAddonSpecificRule(String entityType, String addonName, String url, String fallbackUrl) {
            super(url, fallbackUrl);
            this.entityType = (String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType");
            this.addonName = (String)Preconditions.checkNotNull((Object)addonName, (Object)"addonName");
        }

        @Override
        boolean matches(EntityDriver driver, String addon) {
            String actualType = driver.getEntity().getEntityType().getName();
            String actualSimpleType = actualType.substring(actualType.lastIndexOf(".") + 1);
            return this.addonName.equals(addon) && this.entityType.equalsIgnoreCase(actualSimpleType);
        }
    }

    private static class EntitySpecificRule
    extends Rule {
        private final String entityType;

        EntitySpecificRule(String entityType, String url, String fallbackUrl) {
            super(url, fallbackUrl);
            this.entityType = (String)Preconditions.checkNotNull((Object)entityType, (Object)"entityType");
        }

        @Override
        boolean matches(EntityDriver driver, String addon) {
            String actualType = driver.getEntity().getEntityType().getName();
            String actualSimpleType = actualType.substring(actualType.lastIndexOf(".") + 1);
            return addon == null && this.entityType.equalsIgnoreCase(actualSimpleType);
        }
    }

    private static class UniversalRule
    extends Rule {
        UniversalRule(String url, String fallbackUrl) {
            super(url, fallbackUrl);
        }

        @Override
        boolean matches(EntityDriver driver, String addon) {
            return true;
        }
    }

    private static abstract class Rule {
        private final String url;
        private final String fallbackUrl;

        Rule(String url, String fallbackUrl) {
            this.url = url;
            this.fallbackUrl = fallbackUrl;
        }

        abstract boolean matches(EntityDriver var1, String var2);

        DownloadResolverManager.DownloadTargets resolve(DownloadResolverManager.DownloadRequirement req) {
            String[] parts;
            EntityDriver driver = req.getEntityDriver();
            ArrayList primaries = Lists.newArrayList();
            ArrayList fallbacks = Lists.newArrayList();
            if (Strings.isEmpty((CharSequence)this.url)) {
                String defaulturl = (String)driver.getEntity().getAttribute(Attributes.DOWNLOAD_URL);
                if (defaulturl != null) {
                    primaries.add(defaulturl);
                }
            } else {
                for (String part : parts = this.url.split(";")) {
                    if (part.isEmpty()) continue;
                    primaries.add(part.trim());
                }
            }
            if (this.fallbackUrl != null) {
                for (String part : parts = this.fallbackUrl.split(";")) {
                    if (part.isEmpty()) continue;
                    fallbacks.add(part.trim());
                }
            }
            BasicDownloadTargets.Builder result = BasicDownloadTargets.builder();
            for (String baseurl : primaries) {
                result.addPrimary(DownloadSubstituters.substitute(req, baseurl));
            }
            for (String baseurl : fallbacks) {
                result.addFallback(DownloadSubstituters.substitute(req, baseurl));
            }
            return result.build();
        }
    }
}

