/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.drivers.downloads;

import brooklyn.entity.drivers.downloads.DownloadResolverManager;
import brooklyn.util.collections.MutableList;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;

public class BasicDownloadTargets
implements DownloadResolverManager.DownloadTargets {
    private static final DownloadResolverManager.DownloadTargets EMPTY = BasicDownloadTargets.builder().build();
    private final List<String> primaries;
    private final List<String> fallbacks;
    private final boolean canContinueResolving;

    public static DownloadResolverManager.DownloadTargets empty() {
        return EMPTY;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected BasicDownloadTargets(Builder builder) {
        this.primaries = ImmutableList.copyOf((Collection)builder.primaries);
        this.fallbacks = MutableList.builder().addAll((Iterable)builder.fallbacks).removeAll((Iterable)builder.primaries).build().asUnmodifiable();
        this.canContinueResolving = builder.canContinueResolving;
    }

    public List<String> getPrimaryLocations() {
        return this.primaries;
    }

    public List<String> getFallbackLocations() {
        return this.fallbacks;
    }

    public boolean canContinueResolving() {
        return this.canContinueResolving;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("primaries", this.primaries).add("fallbacks", this.fallbacks).add("canContinueResolving", this.canContinueResolving).toString();
    }

    public static class Builder {
        private List<String> primaries = Lists.newArrayList();
        private List<String> fallbacks = Lists.newArrayList();
        private boolean canContinueResolving = true;

        public Builder addAll(DownloadResolverManager.DownloadTargets other) {
            this.addPrimaries(other.getPrimaryLocations());
            this.addFallbacks(other.getFallbackLocations());
            return this;
        }

        public Builder addPrimary(String val) {
            Preconditions.checkNotNull((Object)val, (Object)"val");
            if (!this.primaries.contains(val)) {
                this.primaries.add(val);
            }
            return this;
        }

        public Builder addPrimaries(Iterable<String> vals) {
            for (String val : (Iterable)Preconditions.checkNotNull(vals, (Object)"vals")) {
                this.addPrimary(val);
            }
            return this;
        }

        public Builder addFallback(String val) {
            Preconditions.checkNotNull((Object)val, (Object)"val");
            if (!this.fallbacks.contains(val)) {
                this.fallbacks.add(val);
            }
            return this;
        }

        public Builder addFallbacks(Iterable<String> vals) {
            for (String val : (Iterable)Preconditions.checkNotNull(vals, (Object)"vals")) {
                this.addFallback(val);
            }
            return this;
        }

        public Builder canContinueResolving(boolean val) {
            this.canContinueResolving = val;
            return this;
        }

        public BasicDownloadTargets build() {
            return new BasicDownloadTargets(this);
        }
    }
}

