/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.drivers.downloads;

import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.drivers.downloads.DownloadResolverManager;
import brooklyn.util.collections.MutableMap;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class BasicDownloadRequirement
implements DownloadResolverManager.DownloadRequirement {
    private final EntityDriver entityDriver;
    private final String addonName;
    private final Map<String, ?> properties;

    public static BasicDownloadRequirement copy(DownloadResolverManager.DownloadRequirement req, Map<String, ?> additionalProperties) {
        MutableMap props = MutableMap.builder().putAll(req.getProperties()).putAll(additionalProperties).build();
        if (req.getAddonName() == null) {
            return new BasicDownloadRequirement(req.getEntityDriver(), (Map<String, ?>)props);
        }
        return new BasicDownloadRequirement(req.getEntityDriver(), req.getAddonName(), (Map<String, ?>)props);
    }

    public BasicDownloadRequirement(EntityDriver driver) {
        this(driver, (Map<String, ?>)ImmutableMap.of());
    }

    public BasicDownloadRequirement(EntityDriver driver, Map<String, ?> properties) {
        this.entityDriver = (EntityDriver)Preconditions.checkNotNull((Object)driver, (Object)"entityDriver");
        this.addonName = null;
        this.properties = (Map)Preconditions.checkNotNull(properties, (Object)"properties");
    }

    public BasicDownloadRequirement(EntityDriver entityDriver, String addonName, Map<String, ?> properties) {
        this.entityDriver = (EntityDriver)Preconditions.checkNotNull((Object)entityDriver, (Object)"entityDriver");
        this.addonName = (String)Preconditions.checkNotNull((Object)addonName, (Object)"addonName");
        this.properties = (Map)Preconditions.checkNotNull(properties, (Object)"properties");
    }

    public EntityDriver getEntityDriver() {
        return this.entityDriver;
    }

    public String getAddonName() {
        return this.addonName;
    }

    public Map<String, ?> getProperties() {
        return this.properties;
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("driver", (Object)this.entityDriver).add("addon", (Object)this.addonName).omitNullValues().toString();
    }
}

