/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.drivers;

import brooklyn.entity.Entity;
import brooklyn.entity.drivers.DriverDependentEntity;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.drivers.EntityDriverManager;
import brooklyn.location.Location;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedHashMap;
import java.util.Map;

public class RegistryEntityDriverFactory
implements EntityDriverManager {
    private final Map<DriverLocationTuple, Class<? extends EntityDriver>> registry = new LinkedHashMap<DriverLocationTuple, Class<? extends EntityDriver>>();

    public <D extends EntityDriver> D build(DriverDependentEntity<D> entity, Location location) {
        Class<D> driverClass = this.lookupDriver(entity.getDriverInterface(), location);
        return (D)((EntityDriver)this.newDriverInstance(driverClass, (Entity)entity, location));
    }

    public boolean hasDriver(DriverDependentEntity<?> entity, Location location) {
        return this.lookupDriver(entity.getDriverInterface(), location) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <D extends EntityDriver> void registerDriver(Class<D> driverInterface, Class<? extends Location> locationClazz, Class<? extends D> driverClazz) {
        Map<DriverLocationTuple, Class<? extends EntityDriver>> map = this.registry;
        synchronized (map) {
            this.registry.put(new DriverLocationTuple(driverInterface, locationClazz), driverClazz);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <D extends EntityDriver> Class<? extends D> lookupDriver(Class<D> driverInterface, Location location) {
        Map<DriverLocationTuple, Class<? extends EntityDriver>> map = this.registry;
        synchronized (map) {
            for (DriverLocationTuple contender : this.registry.keySet()) {
                if (!contender.matches(driverInterface, location)) continue;
                return this.registry.get(contender);
            }
        }
        return null;
    }

    private <D> Constructor<D> getConstructor(Class<? extends D> driverClass) {
        for (Constructor<?> constructor : driverClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 2) continue;
            return constructor;
        }
        throw new RuntimeException(String.format("Class [%s] has no constructor with 2 arguments", driverClass.getName()));
    }

    private <D> D newDriverInstance(Class<D> driverClass, Entity entity, Location location) {
        Constructor<D> constructor = this.getConstructor(driverClass);
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(entity, location);
        }
        catch (InstantiationException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
        catch (InvocationTargetException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static class DriverLocationTuple {
        private final Class<? extends EntityDriver> driverInterface;
        private final Class<? extends Location> locationClazz;

        public DriverLocationTuple(Class<? extends EntityDriver> driverInterface, Class<? extends Location> locationClazz) {
            this.driverInterface = (Class)Preconditions.checkNotNull(driverInterface, (Object)"driver interface");
            this.locationClazz = (Class)Preconditions.checkNotNull(locationClazz, (Object)"location class");
        }

        public boolean matches(Class<? extends EntityDriver> driver, Location location) {
            return this.driverInterface.isAssignableFrom(driver) && this.locationClazz.isInstance(location);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.driverInterface, this.locationClazz});
        }

        public boolean equals(Object other) {
            if (!(other instanceof DriverLocationTuple)) {
                return false;
            }
            DriverLocationTuple o = (DriverLocationTuple)other;
            return this.driverInterface.equals(o.driverInterface) && this.locationClazz.equals(o.locationClazz);
        }
    }
}

