/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.drivers;

import brooklyn.entity.drivers.DriverDependentEntity;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.location.Location;
import brooklyn.location.basic.SshMachineLocation;
import brooklyn.location.basic.WinRmMachineLocation;
import brooklyn.location.paas.PaasLocation;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.ReferenceWithError;
import brooklyn.util.text.Strings;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectiveEntityDriverFactory {
    private static final Logger LOG = LoggerFactory.getLogger(ReflectiveEntityDriverFactory.class);
    protected final Map<String, DriverInferenceRule> rules = MutableMap.of();

    public ReflectiveEntityDriverFactory() {
        this.addRule("ssh-location-driver-inference-rule", new DriverInferenceForSshLocation());
        this.addRule("paas-location-driver-inference-rule", new DriverInferenceForPaasLocation());
        this.addRule("winrm-location-driver-inference-rule", new DriverInferenceForWinRmLocation());
    }

    public DriverInferenceRule addRule(String identifier, DriverInferenceRule rule) {
        DriverInferenceRule oldRule = this.rules.remove(identifier);
        this.rules.put(identifier, rule);
        LOG.debug("Added driver mapping rule " + rule);
        return oldRule;
    }

    public DriverInferenceRule addClassFullNameMapping(String expectedClassFullName, String newClassFullName) {
        DriverInferenceByRenamingClassFullName rule = new DriverInferenceByRenamingClassFullName(expectedClassFullName, newClassFullName);
        return this.addRule(rule.getIdentifier(), rule);
    }

    public DriverInferenceRule addClassSimpleNameMapping(String expectedClassSimpleName, String newClassSimpleName) {
        DriverInferenceByRenamingClassSimpleName rule = new DriverInferenceByRenamingClassSimpleName(expectedClassSimpleName, newClassSimpleName);
        return this.addRule(rule.getIdentifier(), rule);
    }

    public <D extends EntityDriver> D build(DriverDependentEntity<D> entity, Location location) {
        Class driverInterface = entity.getDriverInterface();
        Class driverClass = null;
        MutableList exceptions = MutableList.of();
        if (driverInterface.isInterface()) {
            MutableList ruleListInExecutionOrder = MutableList.copyOf(this.rules.values());
            Collections.reverse(ruleListInExecutionOrder);
            for (DriverInferenceRule rule : ruleListInExecutionOrder) {
                ReferenceWithError<Class<D>> clazzR = rule.resolve(entity, driverInterface, location);
                if (clazzR == null) continue;
                if (!clazzR.hasError()) {
                    Class clazz = (Class)clazzR.get();
                    if (clazz == null) continue;
                    driverClass = clazz;
                    break;
                }
                exceptions.add(clazzR.getError());
            }
        } else {
            driverClass = driverInterface;
        }
        LOG.debug("Driver for " + driverInterface.getName() + " in " + location + " is: " + driverClass);
        if (driverClass == null) {
            if (exceptions.isEmpty()) {
                throw new RuntimeException("No drivers could be found for " + driverInterface.getName() + "; " + "currently only SshMachineLocation is supported for autodetection (location " + location + ")");
            }
            throw Exceptions.create((String)("No drivers could be loaded for " + driverInterface.getName() + " in " + location), (Collection)exceptions);
        }
        try {
            Constructor<D> constructor = this.getConstructor(driverClass);
            constructor.setAccessible(true);
            return (D)((EntityDriver)constructor.newInstance(entity, location));
        }
        catch (Exception e) {
            LOG.warn("Unable to instantiate " + driverClass + " (rethrowing): " + e);
            throw Exceptions.propagate((Throwable)e);
        }
    }

    private <D extends EntityDriver> Constructor<D> getConstructor(Class<D> driverClass) {
        for (Constructor<?> constructor : driverClass.getConstructors()) {
            if (constructor.getParameterTypes().length != 2) continue;
            return constructor;
        }
        throw new RuntimeException(String.format("Class [%s] has no constructor with 2 arguments", driverClass.getName()));
    }

    public static class DriverInferenceForWinRmLocation
    extends AbstractDriverInferenceRule {
        public static final String DEFAULT_IDENTIFIER = "winrm-location-driver-inference-rule";

        @Override
        public <D extends EntityDriver> String inferDriverClassName(DriverDependentEntity<D> entity, Class<D> driverInterface, Location location) {
            String driverInterfaceName = driverInterface.getName();
            if (!(location instanceof WinRmMachineLocation)) {
                return null;
            }
            if (!driverInterfaceName.endsWith("Driver")) {
                throw new IllegalArgumentException(String.format("Driver name [%s] doesn't end with 'Driver'; cannot auto-detect WinRmDriver class name", driverInterfaceName));
            }
            return Strings.removeFromEnd((String)driverInterfaceName, (String)"Driver") + "WinRmDriver";
        }
    }

    public static class DriverInferenceForPaasLocation
    extends AbstractDriverInferenceRule {
        public static final String DEFAULT_IDENTIFIER = "paas-location-driver-inference-rule";

        @Override
        public <D extends EntityDriver> String inferDriverClassName(DriverDependentEntity<D> entity, Class<D> driverInterface, Location location) {
            String driverInterfaceName = driverInterface.getName();
            if (!(location instanceof PaasLocation)) {
                return null;
            }
            if (!driverInterfaceName.endsWith("Driver")) {
                throw new IllegalArgumentException(String.format("Driver name [%s] doesn't end with 'Driver'; cannot auto-detect PaasDriver class name", driverInterfaceName));
            }
            return Strings.removeFromEnd((String)driverInterfaceName, (String)"Driver") + ((PaasLocation)location).getPaasProviderName() + "Driver";
        }
    }

    public static class DriverInferenceForSshLocation
    extends AbstractDriverInferenceRule {
        public static final String DEFAULT_IDENTIFIER = "ssh-location-driver-inference-rule";

        @Override
        public <D extends EntityDriver> String inferDriverClassName(DriverDependentEntity<D> entity, Class<D> driverInterface, Location location) {
            String driverInterfaceName = driverInterface.getName();
            if (!(location instanceof SshMachineLocation)) {
                return null;
            }
            if (!driverInterfaceName.endsWith("Driver")) {
                throw new IllegalArgumentException(String.format("Driver name [%s] doesn't end with 'Driver'; cannot auto-detect SshDriver class name", driverInterfaceName));
            }
            return Strings.removeFromEnd((String)driverInterfaceName, (String)"Driver") + "SshDriver";
        }
    }

    public static class DriverInferenceByRenamingClassSimpleName
    extends AbstractDriverInferenceRenamingInferenceRule {
        public DriverInferenceByRenamingClassSimpleName(String expectedClassSimpleName, String newClassSimpleName) {
            super(expectedClassSimpleName, newClassSimpleName);
        }

        @Override
        public <D extends EntityDriver> String inferDriverClassName(DriverDependentEntity<D> entity, Class<D> driverInterface, Location location) {
            if (driverInterface.getSimpleName().equals(this.expectedPattern)) {
                LOG.warn("Using discouraged driver simple class rename to find " + this.replacement + " for " + this.expectedPattern + "; it is recommended to set getDriverInterface() or newDriver() appropriately");
                return Strings.removeFromEnd((String)driverInterface.getName(), (String)this.expectedPattern) + this.replacement;
            }
            return null;
        }
    }

    public static class DriverInferenceByRenamingClassFullName
    extends AbstractDriverInferenceRenamingInferenceRule {
        public DriverInferenceByRenamingClassFullName(String expectedClassFullName, String newClassFullName) {
            super(expectedClassFullName, newClassFullName);
        }

        @Override
        public <D extends EntityDriver> String inferDriverClassName(DriverDependentEntity<D> entity, Class<D> driverInterface, Location location) {
            if (driverInterface.getName().equals(this.expectedPattern)) {
                return this.replacement;
            }
            return null;
        }
    }

    public static abstract class AbstractDriverInferenceRenamingInferenceRule
    extends AbstractDriverInferenceRule {
        protected final String expectedPattern;
        protected final String replacement;

        public AbstractDriverInferenceRenamingInferenceRule(String expectedPattern, String replacement) {
            this.expectedPattern = expectedPattern;
            this.replacement = replacement;
        }

        public String getIdentifier() {
            return this.getClass().getName() + "[" + this.expectedPattern + "]";
        }

        public String toString() {
            return this.getClass().getName() + "[" + this.expectedPattern + "->" + this.replacement + "]";
        }
    }

    public static abstract class AbstractDriverInferenceRule
    implements DriverInferenceRule {
        @Override
        public <D extends EntityDriver> ReferenceWithError<Class<? extends D>> resolve(DriverDependentEntity<D> entity, Class<D> driverInterface, Location location) {
            try {
                String newName = this.inferDriverClassName(entity, driverInterface, location);
                if (newName == null) {
                    return null;
                }
                return this.loadDriverClass(newName, entity, driverInterface);
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                return ReferenceWithError.newInstanceThrowingError(null, (Throwable)e);
            }
        }

        public abstract <D extends EntityDriver> String inferDriverClassName(DriverDependentEntity<D> var1, Class<D> var2, Location var3);

        protected <D extends EntityDriver> ReferenceWithError<Class<? extends D>> loadDriverClass(String className, DriverDependentEntity<D> entity, Class<D> driverInterface) {
            ReferenceWithError<Class<D>> r1 = this.loadClass(className, entity.getClass().getClassLoader());
            if (!r1.hasError()) {
                return r1;
            }
            ReferenceWithError<Class<D>> r2 = this.loadClass(className, driverInterface.getClass().getClassLoader());
            if (!r2.hasError()) {
                return r2;
            }
            return r1;
        }

        protected <D extends EntityDriver> ReferenceWithError<Class<? extends D>> loadClass(String className, ClassLoader classLoader) {
            try {
                return ReferenceWithError.newInstanceWithoutError(classLoader.loadClass(className));
            }
            catch (Exception e) {
                Exceptions.propagateIfFatal((Throwable)e);
                return ReferenceWithError.newInstanceThrowingError(null, (Throwable)e);
            }
        }
    }

    public static interface DriverInferenceRule {
        public <D extends EntityDriver> ReferenceWithError<Class<? extends D>> resolve(DriverDependentEntity<D> var1, Class<D> var2, Location var3);
    }
}

