/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.drivers;

import brooklyn.entity.drivers.DriverDependentEntity;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.drivers.EntityDriverManager;
import brooklyn.entity.drivers.ReflectiveEntityDriverFactory;
import brooklyn.entity.drivers.RegistryEntityDriverFactory;
import brooklyn.location.Location;
import com.google.common.annotations.Beta;

public class BasicEntityDriverManager
implements EntityDriverManager {
    private final RegistryEntityDriverFactory registry = new RegistryEntityDriverFactory();
    private final ReflectiveEntityDriverFactory reflective = new ReflectiveEntityDriverFactory();

    @Beta
    public ReflectiveEntityDriverFactory getReflectiveDriverFactory() {
        return this.reflective;
    }

    public <D extends EntityDriver> void registerDriver(Class<D> driverInterface, Class<? extends Location> locationClazz, Class<? extends D> driverClazz) {
        this.registry.registerDriver(driverInterface, locationClazz, driverClazz);
    }

    public <D extends EntityDriver> D build(DriverDependentEntity<D> entity, Location location) {
        if (this.registry.hasDriver(entity, location)) {
            return this.registry.build(entity, location);
        }
        return this.reflective.build(entity, location);
    }
}

