/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.util.config.ConfigBag;
import com.google.api.client.util.Lists;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Sanitizer {
    public static final List<String> SECRET_NAMES = ImmutableList.of((Object)"password", (Object)"passwd", (Object)"credential", (Object)"secret", (Object)"private", (Object)"access.cert", (Object)"access.key");
    public static final Predicate<Object> IS_SECRET_PREDICATE = new IsSecretPredicate();
    @Deprecated
    private static final Predicate<Object> IS_SECRET_PREDICATE_DEPRECATED = new Predicate<Object>(){

        public boolean apply(Object name) {
            String lowerName = name.toString().toLowerCase();
            for (String secretName : SECRET_NAMES) {
                if (!lowerName.contains(secretName)) continue;
                return true;
            }
            return false;
        }
    };
    private Predicate<Object> predicate;

    public static Sanitizer newInstance(Predicate<Object> sanitizingNeededCheck) {
        return new Sanitizer(sanitizingNeededCheck);
    }

    public static Sanitizer newInstance() {
        return Sanitizer.newInstance(IS_SECRET_PREDICATE);
    }

    public static Map<String, Object> sanitize(ConfigBag input) {
        return Sanitizer.sanitize(input.getAllConfig());
    }

    public static <K> Map<K, Object> sanitize(Map<K, ?> input) {
        return Sanitizer.sanitize(input, Sets.newHashSet());
    }

    static <K> Map<K, Object> sanitize(Map<K, ?> input, Set<Object> visited) {
        return Sanitizer.newInstance().apply(input, visited);
    }

    private Sanitizer(Predicate<Object> sanitizingNeededCheck) {
        this.predicate = sanitizingNeededCheck;
    }

    public <K> Map<K, Object> apply(Map<K, ?> input) {
        return this.apply(input, Sets.newHashSet());
    }

    private <K> Map<K, Object> apply(Map<K, ?> input, Set<Object> visited) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<K, ?> e : input.entrySet()) {
            if (this.predicate.apply(e.getKey())) {
                result.put(e.getKey(), "xxxxxxxx");
                continue;
            }
            if (visited.contains(System.identityHashCode(e.getValue()))) {
                result.put(e.getKey(), e.getValue());
                continue;
            }
            visited.add(System.identityHashCode(e.getValue()));
            if (e.getValue() instanceof Map) {
                result.put(e.getKey(), this.apply((Map)e.getValue(), visited));
                continue;
            }
            if (e.getValue() instanceof List) {
                result.put(e.getKey(), this.applyList((List)e.getValue(), visited));
                continue;
            }
            if (e.getValue() instanceof Set) {
                result.put(e.getKey(), this.applySet((Set)e.getValue(), visited));
                continue;
            }
            result.put(e.getKey(), e.getValue());
        }
        return result;
    }

    private List<Object> applyIterable(Iterable<?> input, Set<Object> visited) {
        ArrayList result = Lists.newArrayList();
        for (Object o : input) {
            if (visited.contains(System.identityHashCode(o))) {
                result.add(o);
                continue;
            }
            visited.add(System.identityHashCode(o));
            if (o instanceof Map) {
                result.add(this.apply((Map)o, visited));
                continue;
            }
            if (o instanceof List) {
                result.add(this.applyList((List)o, visited));
                continue;
            }
            if (o instanceof Set) {
                result.add(this.applySet((Set)o, visited));
                continue;
            }
            result.add(o);
        }
        return result;
    }

    private List<Object> applyList(List<?> input, Set<Object> visited) {
        return this.applyIterable(input, visited);
    }

    private Set<Object> applySet(Set<?> input, Set<Object> visited) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        result.addAll(this.applyIterable(input, visited));
        return result;
    }

    private static class IsSecretPredicate
    implements Predicate<Object> {
        private IsSecretPredicate() {
        }

        public boolean apply(Object name) {
            String lowerName = name.toString().toLowerCase();
            for (String secretName : SECRET_NAMES) {
                if (!lowerName.contains(secretName)) continue;
                return true;
            }
            return false;
        }
    }
}

