/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import java.io.Serializable;

@Deprecated
public interface QuorumCheck
extends brooklyn.util.collections.QuorumCheck {
    public boolean isQuorate(int var1, int var2);

    @Deprecated
    public static class NumericQuorumCheck
    implements QuorumCheck,
    Serializable {
        private static final long serialVersionUID = -5090669237460159621L;
        protected final int minRequiredSize;
        protected final double minRequiredRatio;
        protected final boolean allowEmpty;

        public NumericQuorumCheck(int minRequiredSize, double minRequiredRatio, boolean allowEmpty) {
            this.minRequiredSize = minRequiredSize;
            this.minRequiredRatio = minRequiredRatio;
            this.allowEmpty = allowEmpty;
        }

        @Override
        public boolean isQuorate(int sizeHealthy, int totalSize) {
            if (this.allowEmpty && totalSize == 0) {
                return true;
            }
            if (sizeHealthy < this.minRequiredSize) {
                return false;
            }
            return !((double)sizeHealthy < (double)totalSize * this.minRequiredRatio - 1.0E-9);
        }

        public String toString() {
            return "QuorumCheck[require=" + this.minRequiredSize + "," + 100.0 * this.minRequiredRatio + "%" + (this.allowEmpty ? "|0" : "") + "]";
        }
    }

    public static class QuorumChecks {
        public static QuorumCheck all() {
            return new NumericQuorumCheck(0, 1.0, false);
        }

        public static QuorumCheck allAndAtLeastOne() {
            return new NumericQuorumCheck(1, 1.0, false);
        }

        public static QuorumCheck atLeastOne() {
            return new NumericQuorumCheck(1, 0.0, false);
        }

        public static QuorumCheck atLeastOneUnlessEmpty() {
            return new NumericQuorumCheck(1, 0.0, true);
        }

        public static QuorumCheck alwaysTrue() {
            return new NumericQuorumCheck(0, 0.0, true);
        }

        public static QuorumCheck newInstance(int minRequiredSize, double minRequiredRatio, boolean allowEmpty) {
            return new NumericQuorumCheck(minRequiredSize, minRequiredRatio, allowEmpty);
        }
    }
}

