/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.basic.BrooklynTypeSnapshot;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.EntityType;
import brooklyn.entity.ParameterType;
import brooklyn.event.Sensor;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class EntityTypeSnapshot
extends BrooklynTypeSnapshot
implements EntityType {
    private static final long serialVersionUID = 4670930188951106009L;
    private final Map<String, Sensor<?>> sensors;
    private final Set<Effector<?>> effectors;
    private final Set<Sensor<?>> sensorsSet;

    EntityTypeSnapshot(String name, Map<String, ConfigKey<?>> configKeys, Map<String, Sensor<?>> sensors, Collection<Effector<?>> effectors) {
        super(name, configKeys);
        this.sensors = ImmutableMap.copyOf(sensors);
        this.effectors = ImmutableSet.copyOf(effectors);
        this.sensorsSet = ImmutableSet.copyOf(this.sensors.values());
    }

    public Set<Sensor<?>> getSensors() {
        return this.sensorsSet;
    }

    public Set<Effector<?>> getEffectors() {
        return this.effectors;
    }

    public Maybe<Effector<?>> getEffectorByName(String name) {
        for (Effector<?> contender : this.effectors) {
            if (!name.equals(contender.getName())) continue;
            return Maybe.of(contender);
        }
        return Maybe.absent((String)("No effector matching '" + name + "'"));
    }

    public Effector<?> getEffector(String name, Class<?> ... parameterTypes) {
        block0: for (Effector<?> contender : this.effectors) {
            List contenderParameters;
            if (!name.equals(contender.getName()) || parameterTypes.length != (contenderParameters = contender.getParameters()).size()) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                if (parameterTypes[i] != ((ParameterType)contenderParameters.get(i)).getParameterClass()) continue block0;
            }
            return contender;
        }
        throw new NoSuchElementException("No matching effector " + name + "(" + Joiner.on((String)", ").join((Object[])parameterTypes) + ") on entity " + this.getName());
    }

    public Sensor<?> getSensor(String name) {
        return this.sensors.get(name);
    }

    public boolean hasSensor(String name) {
        return this.sensors.containsKey(name);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.sensors, this.effectors});
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof EntityTypeSnapshot)) {
            return false;
        }
        EntityTypeSnapshot o = (EntityTypeSnapshot)obj;
        return super.equals(obj) && Objects.equal(this.sensors, o.sensors) && Objects.equal(this.effectors, o.effectors);
    }

    @Override
    protected Objects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("sensors", this.sensors).add("effectors", this.effectors);
    }
}

