/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Entity;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.management.Task;
import brooklyn.util.collections.CollectionFunctionals;
import brooklyn.util.time.Duration;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.List;

public class EntityTasks {
    public static <T> Task<Boolean> testingAttributeEventually(Entity entity, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReady(entity, sensor).readiness(condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutReturn(false).onUnmanagedReturn(false).build();
    }

    public static <T> Task<Boolean> requiringAttributeEventually(Entity entity, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReady(entity, sensor).readiness(condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutThrow().onUnmanagedThrow().build();
    }

    public static <T> Task<Boolean> testingAttributeEventually(Iterable<Entity> entities, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReadyFromMultiple(entities, sensor, condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutReturn(false).onUnmanagedReturn(false).postProcessFromMultiple((Predicate<List<Boolean>>)CollectionFunctionals.all((Predicate)Predicates.equalTo((Object)true))).build();
    }

    public static <T> Task<Boolean> requiringAttributeEventually(Iterable<Entity> entities, AttributeSensor<T> sensor, Predicate<T> condition, Duration timeout) {
        return DependentConfiguration.builder().attributeWhenReadyFromMultiple(entities, sensor, condition).postProcess(Functions.constant((Object)true)).timeout(timeout).onTimeoutThrow().onUnmanagedThrow().postProcessFromMultiple(CollectionFunctionals.all((Predicate)Predicates.equalTo((Object)true))).build();
    }
}

