/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.Entities;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.util.collections.CollectionFunctionals;
import brooklyn.util.guava.SerializablePredicate;
import brooklyn.util.javalang.Reflections;
import brooklyn.util.text.StringPredicates;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import java.util.Collection;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class EntityPredicates {
    public static Predicate<Entity> idEqualTo(String val) {
        return EntityPredicates.idSatisfies((Predicate<? super String>)Predicates.equalTo((Object)val));
    }

    public static Predicate<Entity> idSatisfies(Predicate<? super String> condition) {
        return new IdSatisfies(condition);
    }

    @Deprecated
    private static <T> Predicate<Entity> idEqualToOld(final T val) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && Objects.equal((Object)input.getId(), (Object)val);
            }
        };
    }

    public static Predicate<Entity> displayNameEqualTo(String val) {
        return EntityPredicates.displayNameSatisfies((Predicate<? super String>)Predicates.equalTo((Object)val));
    }

    public static Predicate<Entity> displayNameSatisfies(Predicate<? super String> condition) {
        return new DisplayNameSatisfies(condition);
    }

    @Deprecated
    private static <T> Predicate<Entity> displayNameEqualToOld(final T val) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && Objects.equal((Object)input.getDisplayName(), (Object)val);
            }
        };
    }

    public static Predicate<Entity> displayNameMatches(String regex) {
        return EntityPredicates.displayNameSatisfies((Predicate<? super String>)StringPredicates.matchesRegex((String)regex));
    }

    public static Predicate<Entity> applicationIdEqualTo(String val) {
        return EntityPredicates.applicationIdSatisfies((Predicate<? super String>)Predicates.equalTo((Object)val));
    }

    public static Predicate<Entity> applicationIdSatisfies(Predicate<? super String> condition) {
        return new ApplicationIdSatisfies(condition);
    }

    @Deprecated
    private static Predicate<Entity> applicationIdEqualToOld(final String val) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && val.equals(input.getApplicationId());
            }
        };
    }

    public static <T> Predicate<Entity> attributeEqualTo(AttributeSensor<T> attribute, T val) {
        return EntityPredicates.attributeSatisfies(attribute, Predicates.equalTo(val));
    }

    public static <T> Predicate<Entity> attributeSatisfies(AttributeSensor<T> attribute, Predicate<T> condition) {
        return new AttributeSatisfies(attribute, condition);
    }

    @Deprecated
    private static <T> Predicate<Entity> attributeEqualToOld(final AttributeSensor<T> attribute, final T val) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && Objects.equal((Object)input.getAttribute(attribute), (Object)val);
            }
        };
    }

    public static <T> Predicate<Entity> attributeNotEqualTo(AttributeSensor<T> attribute, T val) {
        return EntityPredicates.attributeSatisfies(attribute, Predicates.not((Predicate)Predicates.equalTo(val)));
    }

    public static <T> Predicate<Entity> configEqualTo(ConfigKey<T> configKey, T val) {
        return EntityPredicates.configSatisfies(configKey, Predicates.equalTo(val));
    }

    public static <T> Predicate<Entity> configSatisfies(ConfigKey<T> configKey, Predicate<T> condition) {
        return new ConfigKeySatisfies(configKey, condition);
    }

    public static <T> Predicate<Entity> configEqualTo(ConfigKey.HasConfigKey<T> configKey, T val) {
        return EntityPredicates.configEqualTo(configKey.getConfigKey(), val);
    }

    public static <T> Predicate<Entity> configSatisfies(ConfigKey.HasConfigKey<T> configKey, Predicate<T> condition) {
        return new ConfigKeySatisfies(configKey.getConfigKey(), condition);
    }

    @Deprecated
    private static <T> Predicate<Entity> configEqualToOld(final ConfigKey<T> configKey, final T val) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && Objects.equal((Object)input.getConfig(configKey), (Object)val);
            }
        };
    }

    @Deprecated
    private static <T> Predicate<Entity> configEqualToOld(final ConfigKey.HasConfigKey<T> configKey, final T val) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && Objects.equal((Object)input.getConfig(configKey), (Object)val);
            }
        };
    }

    public static Predicate<Entity> hasInterfaceMatching(String typeRegex) {
        return new ImplementsInterface(typeRegex);
    }

    public static Predicate<Entity> isChildOf(Entity parent) {
        return new IsChildOf(parent);
    }

    @Deprecated
    private static <T> Predicate<Entity> isChildOfOld(final Entity parent) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && Objects.equal((Object)input.getParent(), (Object)parent);
            }
        };
    }

    public static Predicate<Entity> isMemberOf(Group group) {
        return new IsMemberOf(group);
    }

    @Deprecated
    private static <T> Predicate<Entity> isMemberOfOld(final Group group) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && group.hasMember(input);
            }
        };
    }

    public static <T> Predicate<Entity> locationsIncludes(Location location) {
        return EntityPredicates.locationsSatisfy((Predicate<Collection<Location>>)CollectionFunctionals.contains((Object)location));
    }

    public static <T> Predicate<Entity> locationsSatisfy(Predicate<Collection<Location>> condition) {
        return new LocationsSatisfy(condition);
    }

    @Deprecated
    public static <T> Predicate<Entity> withLocation(Location location) {
        return EntityPredicates.locationsIncludes(location);
    }

    @Deprecated
    private static <T> Predicate<Entity> withLocationOld(final Location location) {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && input.getLocations().contains(location);
            }
        };
    }

    public static <T> Predicate<Entity> isManaged() {
        return new IsManaged();
    }

    @Deprecated
    public static <T> Predicate<Entity> managed() {
        return EntityPredicates.isManaged();
    }

    @Deprecated
    private static <T> Predicate<Entity> managedOld() {
        return new SerializablePredicate<Entity>(){

            public boolean apply(@Nullable Entity input) {
                return input != null && Entities.isManaged(input);
            }
        };
    }

    protected static class IsManaged
    implements SerializablePredicate<Entity> {
        protected IsManaged() {
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && Entities.isManaged(input);
        }

        public String toString() {
            return "isManaged()";
        }
    }

    protected static class LocationsSatisfy
    implements SerializablePredicate<Entity> {
        protected final Predicate<Collection<Location>> condition;

        protected LocationsSatisfy(Predicate<Collection<Location>> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && this.condition.apply((Object)input.getLocations());
        }

        public String toString() {
            return "locationsSatisfy(" + this.condition + ")";
        }
    }

    protected static class IsMemberOf
    implements SerializablePredicate<Entity> {
        protected final Group group;

        protected IsMemberOf(Group group) {
            this.group = group;
        }

        public boolean apply(@Nullable Entity input) {
            return this.group != null && input != null && this.group.hasMember(input);
        }

        public String toString() {
            return "isMemberOf(" + this.group + ")";
        }
    }

    protected static class IsChildOf
    implements SerializablePredicate<Entity> {
        protected final Entity parent;

        protected IsChildOf(Entity parent) {
            this.parent = parent;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && Objects.equal((Object)input.getParent(), (Object)this.parent);
        }

        public String toString() {
            return "isChildOf(" + this.parent + ")";
        }
    }

    protected static class ImplementsInterface
    implements SerializablePredicate<Entity> {
        protected final Pattern pattern;

        public ImplementsInterface(String typeRegex) {
            this.pattern = Pattern.compile(typeRegex);
        }

        public boolean apply(@Nullable Entity input) {
            if (input == null) {
                return false;
            }
            for (Class cls : Reflections.getAllInterfaces(input.getClass())) {
                if (!this.pattern.matcher(cls.getName()).matches()) continue;
                return true;
            }
            return false;
        }
    }

    protected static class ConfigKeySatisfies<T>
    implements SerializablePredicate<Entity> {
        protected final ConfigKey<T> configKey;
        protected final Predicate<T> condition;

        private ConfigKeySatisfies(ConfigKey<T> configKey, Predicate<T> condition) {
            this.configKey = configKey;
            this.condition = condition;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && this.condition.apply(input.getConfig(this.configKey));
        }

        public String toString() {
            return "configKeySatisfies(" + this.configKey.getName() + "," + this.condition + ")";
        }
    }

    protected static class AttributeSatisfies<T>
    implements SerializablePredicate<Entity> {
        protected final AttributeSensor<T> attribute;
        protected final Predicate<T> condition;

        private AttributeSatisfies(AttributeSensor<T> attribute, Predicate<T> condition) {
            this.attribute = attribute;
            this.condition = condition;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && this.condition.apply(input.getAttribute(this.attribute));
        }

        public String toString() {
            return "attributeSatisfies(" + this.attribute.getName() + "," + this.condition + ")";
        }
    }

    protected static class ApplicationIdSatisfies
    implements SerializablePredicate<Entity> {
        protected final Predicate<? super String> condition;

        protected ApplicationIdSatisfies(Predicate<? super String> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && this.condition.apply((Object)input.getApplicationId());
        }

        public String toString() {
            return "applicationIdSatisfies(" + this.condition + ")";
        }
    }

    @Deprecated
    private static class DisplayNameMatches
    implements SerializablePredicate<Entity> {
        private final String regex;

        DisplayNameMatches(String regex) {
            this.regex = regex;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && input.getDisplayName() != null && input.getDisplayName().matches(this.regex);
        }

        public String toString() {
            return "DisplayNameMatches(" + this.regex + ")";
        }
    }

    protected static class DisplayNameSatisfies
    implements SerializablePredicate<Entity> {
        protected final Predicate<? super String> condition;

        protected DisplayNameSatisfies(Predicate<? super String> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && this.condition.apply((Object)input.getDisplayName());
        }

        public String toString() {
            return "displayNameSatisfies(" + this.condition + ")";
        }
    }

    protected static class IdSatisfies
    implements SerializablePredicate<Entity> {
        protected final Predicate<? super String> condition;

        protected IdSatisfies(Predicate<? super String> condition) {
            this.condition = condition;
        }

        public boolean apply(@Nullable Entity input) {
            return input != null && this.condition.apply((Object)input.getId());
        }

        public String toString() {
            return "idSatisfies(" + this.condition + ")";
        }
    }
}

