/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.trait.Identifiable;
import brooklyn.event.AttributeSensor;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Functionals;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Map;

public class EntityFunctions {
    public static <T> Function<Entity, T> attribute(AttributeSensor<T> attribute) {
        class GetEntityAttributeFunction
        implements Function<Entity, T> {
            final /* synthetic */ AttributeSensor val$attribute;

            GetEntityAttributeFunction(AttributeSensor attributeSensor) {
                this.val$attribute = attributeSensor;
            }

            public T apply(Entity input) {
                return input == null ? null : input.getAttribute(this.val$attribute);
            }
        }
        return new GetEntityAttributeFunction(attribute);
    }

    public static <T> Function<Entity, T> config(ConfigKey<T> key) {
        class GetEntityConfigFunction
        implements Function<Entity, T> {
            final /* synthetic */ ConfigKey val$key;

            GetEntityConfigFunction(ConfigKey configKey) {
                this.val$key = configKey;
            }

            public T apply(Entity input) {
                return input == null ? null : input.getConfig(this.val$key);
            }
        }
        return new GetEntityConfigFunction(key);
    }

    public static Function<Entity, String> displayName() {
        class GetEntityDisplayName
        implements Function<Entity, String> {
            GetEntityDisplayName() {
            }

            public String apply(Entity input) {
                return input == null ? null : input.getDisplayName();
            }
        }
        return new GetEntityDisplayName();
    }

    public static Function<Identifiable, String> id() {
        class GetIdFunction
        implements Function<Identifiable, String> {
            GetIdFunction() {
            }

            public String apply(Identifiable input) {
                return input == null ? null : input.getId();
            }
        }
        return new GetIdFunction();
    }

    public static Function<Entity, Void> settingSensorsConstant(Map<AttributeSensor<?>, Object> values) {
        Preconditions.checkNotNull(values, (Object)"values");
        class SettingSensorsConstantFunction
        implements Function<Entity, Void> {
            final /* synthetic */ Map val$values;

            SettingSensorsConstantFunction(Map map) {
                this.val$values = map;
            }

            public Void apply(Entity input) {
                for (Map.Entry entry : this.val$values.entrySet()) {
                    AttributeSensor sensor = (AttributeSensor)entry.getKey();
                    Object value = entry.getValue();
                    if (value == Entities.UNCHANGED) continue;
                    if (value == Entities.REMOVE) {
                        ((EntityInternal)input).removeAttribute(sensor);
                        continue;
                    }
                    value = TypeCoercions.coerce(value, sensor.getTypeToken());
                    ((EntityInternal)input).setAttribute(sensor, value);
                }
                return null;
            }
        }
        return new SettingSensorsConstantFunction(values);
    }

    public static Runnable settingSensorsConstant(Entity entity, Map<AttributeSensor<?>, Object> values) {
        Preconditions.checkNotNull((Object)entity, (Object)"entity");
        Preconditions.checkNotNull(values, (Object)"values");
        return Functionals.runnable((Supplier)Suppliers.compose(EntityFunctions.settingSensorsConstant(values), (Supplier)Suppliers.ofInstance((Object)entity)));
    }

    public static <K, V> Function<Entity, Void> updatingSensorMapEntry(final AttributeSensor<Map<K, V>> mapSensor, final K key, final Supplier<? extends V> valueSupplier) {
        class UpdatingSensorMapEntryFunction
        implements Function<Entity, Void> {
            UpdatingSensorMapEntryFunction() {
            }

            public Void apply(Entity input) {
                ServiceStateLogic.updateMapSensorEntry((EntityLocal)input, mapSensor, key, valueSupplier.get());
                return null;
            }
        }
        return new UpdatingSensorMapEntryFunction();
    }

    public static <K, V> Runnable updatingSensorMapEntry(Entity entity, AttributeSensor<Map<K, V>> mapSensor, K key, Supplier<? extends V> valueSupplier) {
        return Functionals.runnable((Supplier)Suppliers.compose(EntityFunctions.updatingSensorMapEntry(mapSensor, key, valueSupplier), (Supplier)Suppliers.ofInstance((Object)entity)));
    }

    public static Supplier<Collection<Application>> applications(ManagementContext mgmt) {
        class AppsSupplier
        implements Supplier<Collection<Application>> {
            final /* synthetic */ ManagementContext val$mgmt;

            AppsSupplier(ManagementContext managementContext) {
                this.val$mgmt = managementContext;
            }

            public Collection<Application> get() {
                return this.val$mgmt.getApplications();
            }
        }
        return new AppsSupplier(mgmt);
    }

    public static Function<Entity, Location> locationMatching(Predicate<? super Location> filter) {
        return new LocationMatching(filter);
    }

    private static class LocationMatching
    implements Function<Entity, Location> {
        private Predicate<? super Location> filter;

        private LocationMatching() {
        }

        public LocationMatching(Predicate<? super Location> filter) {
            this.filter = filter;
        }

        public Location apply(Entity input) {
            return (Location)Iterables.find((Iterable)input.getLocations(), this.filter);
        }
    }
}

