/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.basic.BrooklynDynamicType;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.EntityType;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.EntityTypeSnapshot;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.effector.EffectorAndBody;
import brooklyn.entity.effector.EffectorBody;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.entity.effector.EffectorWithBody;
import brooklyn.entity.effector.Effectors;
import brooklyn.event.Sensor;
import brooklyn.util.javalang.Reflections;
import com.google.common.annotations.Beta;
import com.google.common.base.Joiner;
import com.google.common.base.Throwables;
import com.google.common.collect.Maps;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityDynamicType
extends BrooklynDynamicType<Entity, AbstractEntity> {
    private static final Logger LOG = LoggerFactory.getLogger(EntityDynamicType.class);
    private final Map<String, Effector<?>> effectors = new ConcurrentHashMap();
    private final ConcurrentMap<String, Sensor<?>> sensors = new ConcurrentHashMap();

    public EntityDynamicType(AbstractEntity entity) {
        this(entity.getClass(), entity);
    }

    public EntityDynamicType(Class<? extends Entity> clazz) {
        this(clazz, null);
    }

    private EntityDynamicType(Class<? extends Entity> clazz, AbstractEntity entity) {
        super(clazz, entity);
        String id = entity == null ? clazz.getName() : entity.getId();
        this.effectors.putAll(EntityDynamicType.findEffectors(clazz, null));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Entity {} effectors: {}", (Object)id, (Object)Joiner.on((String)", ").join(this.effectors.keySet()));
        }
        this.sensors.putAll(EntityDynamicType.findSensors(clazz, null));
        if (LOG.isTraceEnabled()) {
            LOG.trace("Entity {} sensors: {}", (Object)id, (Object)Joiner.on((String)", ").join(this.sensors.keySet()));
        }
        this.refreshSnapshot();
    }

    @Deprecated
    public Class<? extends Entity> getEntityClass() {
        return super.getBrooklynClass();
    }

    public EntityType getSnapshot() {
        return (EntityType)super.getSnapshot();
    }

    public Effector<?> getEffector(String name) {
        return this.effectors.get(name);
    }

    public Map<String, Effector<?>> getEffectors() {
        return Collections.unmodifiableMap(this.effectors);
    }

    @Beta
    public void addEffector(Effector<?> newEffector) {
        Effector<?> oldEffector = this.effectors.put(newEffector.getName(), newEffector);
        this.invalidateSnapshot();
        if (oldEffector != null) {
            ((AbstractEntity)this.instance).emit(AbstractEntity.EFFECTOR_CHANGED, newEffector.getName());
        } else {
            ((AbstractEntity)this.instance).emit(AbstractEntity.EFFECTOR_ADDED, newEffector.getName());
        }
    }

    @Beta
    public <T> void addEffector(Effector<T> effector, EffectorTasks.EffectorTaskFactory<T> body) {
        this.addEffector(new EffectorAndBody<T>(effector, body));
    }

    @Beta
    public <T> void addEffector(Effector<T> effector, EffectorBody<T> body) {
        this.addEffector(effector, new EffectorTasks.EffectorBodyTaskFactory<T>(body));
    }

    public Map<String, Sensor<?>> getSensors() {
        return Collections.unmodifiableMap(this.sensors);
    }

    public Sensor<?> getSensor(String sensorName) {
        return (Sensor)this.sensors.get(sensorName);
    }

    public void addSensor(Sensor<?> newSensor) {
        this.sensors.put(newSensor.getName(), newSensor);
        this.invalidateSnapshot();
        ((AbstractEntity)this.instance).emit(AbstractEntity.SENSOR_ADDED, newSensor);
    }

    public void addSensors(Iterable<? extends Sensor<?>> newSensors) {
        for (Sensor<?> sensor : newSensors) {
            this.addSensor(sensor);
        }
    }

    public void addSensorIfAbsent(Sensor<?> newSensor) {
        Sensor<?> prev = this.addSensorIfAbsentWithoutPublishing(newSensor);
        if (prev == null) {
            ((AbstractEntity)this.instance).emit(AbstractEntity.SENSOR_ADDED, newSensor);
        }
    }

    public Sensor<?> addSensorIfAbsentWithoutPublishing(Sensor<?> newSensor) {
        Sensor<?> prev = this.sensors.putIfAbsent(newSensor.getName(), newSensor);
        if (prev == null) {
            this.invalidateSnapshot();
        }
        return prev;
    }

    public Sensor<?> removeSensor(String sensorName) {
        Sensor result = (Sensor)this.sensors.remove(sensorName);
        if (result != null) {
            this.invalidateSnapshot();
            ((AbstractEntity)this.instance).emit(AbstractEntity.SENSOR_REMOVED, result);
        }
        return result;
    }

    public boolean removeSensor(Sensor<?> sensor) {
        return this.removeSensor(sensor.getName()) != null;
    }

    @Override
    protected EntityTypeSnapshot newSnapshot() {
        return new EntityTypeSnapshot(this.name, EntityDynamicType.value(this.configKeys), this.sensors, this.effectors.values());
    }

    public static Map<String, Effector<?>> findEffectors(Class<? extends Entity> clazz, Entity optionalEntity) {
        try {
            LinkedHashMap result = Maps.newLinkedHashMap();
            LinkedHashMap fieldSources = Maps.newLinkedHashMap();
            LinkedHashMap methodSources = Maps.newLinkedHashMap();
            for (Field f : Reflections.findPublicFieldsOrderedBySuper(clazz)) {
                Effector eff;
                if (!Effector.class.isAssignableFrom(f.getType())) continue;
                if (!Modifier.isStatic(f.getModifiers())) {
                    LOG.warn("Discouraged/deprecated use of non-static effector field " + f + " defined in " + (optionalEntity != null ? optionalEntity : clazz));
                    if (optionalEntity == null) continue;
                }
                if ((eff = (Effector)f.get(optionalEntity)) == null) {
                    LOG.warn("Effector " + f + " undefined for " + clazz + " (" + optionalEntity + ")");
                    continue;
                }
                Effector overwritten = result.put(eff.getName(), eff);
                Field overwrittenFieldSource = fieldSources.put(eff.getName(), f);
                if (overwritten == null || Effectors.sameInstance(overwritten, eff)) continue;
                LOG.trace("multiple definitions for effector {} on {}; preferring {} from {} to {} from {}", new Object[]{eff.getName(), optionalEntity != null ? optionalEntity : clazz, eff, f, overwritten, overwrittenFieldSource});
            }
            for (Method m : Reflections.findPublicMethodsOrderedBySuper(clazz)) {
                Effector<?> eff;
                Effector overwritten;
                brooklyn.entity.annotation.Effector effectorAnnotation = m.getAnnotation(brooklyn.entity.annotation.Effector.class);
                if (effectorAnnotation == null) continue;
                if (Modifier.isStatic(m.getModifiers())) {
                    LOG.warn("Discouraged/deprecated use of static annotated effector method " + m + " defined in " + (optionalEntity != null ? optionalEntity : clazz));
                    if (optionalEntity == null) continue;
                }
                if ((overwritten = (Effector)result.get((eff = MethodEffector.create(m)).getName())) instanceof EffectorWithBody && !(overwritten instanceof MethodEffector)) continue;
                result.put(eff.getName(), eff);
                Method overwrittenMethodSource = methodSources.put(eff.getName(), m);
                Field overwrittenFieldSource = (Field)fieldSources.remove(eff.getName());
                LOG.trace("multiple definitions for effector {} on {}; preferring {} from {} to {} from {}", new Object[]{eff.getName(), optionalEntity != null ? optionalEntity : clazz, eff, m, overwritten, overwrittenMethodSource != null ? overwrittenMethodSource : overwrittenFieldSource});
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public static Map<String, Sensor<?>> findSensors(Class<? extends Entity> clazz, Entity optionalEntity) {
        try {
            LinkedHashMap result = Maps.newLinkedHashMap();
            LinkedHashMap sources = Maps.newLinkedHashMap();
            for (Field f : Reflections.findPublicFieldsOrderedBySuper(clazz)) {
                if (!Sensor.class.isAssignableFrom(f.getType())) continue;
                if (!Modifier.isStatic(f.getModifiers())) {
                    LOG.warn("Discouraged use of non-static sensor " + f + " defined in " + (optionalEntity != null ? optionalEntity : clazz));
                    if (optionalEntity == null) continue;
                }
                Sensor sens = (Sensor)f.get(optionalEntity);
                Sensor overwritten = result.put(sens.getName(), sens);
                Field source = sources.put(sens.getName(), f);
                if (overwritten == null || overwritten == sens) continue;
                if (sens instanceof ConfigKey.HasConfigKey) {
                    LOG.trace("multiple definitions for config sensor {} on {}; preferring {} from {} to {} from {}", new Object[]{sens.getName(), optionalEntity != null ? optionalEntity : clazz, sens, f, overwritten, source});
                    continue;
                }
                LOG.warn("multiple definitions for sensor {} on {}; preferring {} from {} to {} from {}", new Object[]{sens.getName(), optionalEntity != null ? optionalEntity : clazz, sens, f, overwritten, source});
            }
            return result;
        }
        catch (IllegalAccessException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }
}

