/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigInheritance;
import brooklyn.config.ConfigKey;
import brooklyn.config.internal.AbstractConfigMapImpl;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Sanitizer;
import brooklyn.event.basic.StructuredConfigKey;
import brooklyn.management.ExecutionContext;
import brooklyn.management.Task;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.internal.ConfigKeySelfExtracting;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityConfigMap
extends AbstractConfigMapImpl {
    private static final Logger LOG = LoggerFactory.getLogger(EntityConfigMap.class);
    private final AbstractEntity entity;
    private final Map<ConfigKey<?>, Object> inheritedConfig = Collections.synchronizedMap(new LinkedHashMap());
    private final ConfigBag localConfigBag;
    private final ConfigBag inheritedConfigBag;

    public EntityConfigMap(AbstractEntity entity, Map<ConfigKey<?>, Object> storage) {
        this.entity = (AbstractEntity)Preconditions.checkNotNull((Object)entity, (Object)"entity must be specified");
        this.ownConfig = (Map)Preconditions.checkNotNull(storage, (Object)"storage map must be specified");
        this.localConfigBag = ConfigBag.newInstance();
        this.inheritedConfigBag = ConfigBag.newInstance();
    }

    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        ConfigKey ownKey = this.entity != null ? (ConfigKey)GroovyJavaMethods.elvis((Object)this.entity.getEntityType().getConfigKey(key.getName()), key) : key;
        ConfigInheritance inheritance = key.getInheritance();
        if (inheritance == null) {
            inheritance = ownKey.getInheritance();
        }
        if (inheritance == null) {
            inheritance = this.getDefaultInheritance();
        }
        if (ownKey instanceof ConfigKeySelfExtracting) {
            Object rawval = this.ownConfig.get(key);
            T result = null;
            boolean complete = false;
            if (((ConfigKeySelfExtracting)ownKey).isSet(this.ownConfig)) {
                ExecutionContext exec = this.entity.getExecutionContext();
                result = ((ConfigKeySelfExtracting)ownKey).extractValue(this.ownConfig, exec);
                complete = true;
            } else if (this.isInherited(ownKey, inheritance) && ((ConfigKeySelfExtracting)ownKey).isSet(this.inheritedConfig)) {
                ExecutionContext exec = this.entity.getExecutionContext();
                result = ((ConfigKeySelfExtracting)ownKey).extractValue(this.inheritedConfig, exec);
                complete = true;
            } else if (this.localConfigBag.containsKey(ownKey)) {
                result = this.localConfigBag.get(ownKey);
                complete = true;
            } else if (this.isInherited(ownKey, inheritance) && this.inheritedConfigBag.containsKey(ownKey)) {
                result = this.inheritedConfigBag.get(ownKey);
                complete = true;
            }
            if (rawval instanceof Task) {
                this.entity.getManagementSupport().getEntityChangeListener().onConfigChanged(key);
            }
            if (complete) {
                return result;
            }
        } else {
            LOG.warn("Config key {} of {} is not a ConfigKeySelfExtracting; cannot retrieve value; returning default", (Object)ownKey, (Object)this);
        }
        return TypeCoercions.coerce(defaultValue != null ? defaultValue : ownKey.getDefaultValue(), key.getTypeToken());
    }

    private <T> boolean isInherited(ConfigKey<T> key) {
        return this.isInherited(key, key.getInheritance());
    }

    private <T> boolean isInherited(ConfigKey<T> key, ConfigInheritance inheritance) {
        if (inheritance == null) {
            inheritance = this.getDefaultInheritance();
        }
        return inheritance.isInherited(key, (Object)this.entity.getParent(), (Object)this.entity);
    }

    private ConfigInheritance getDefaultInheritance() {
        return ConfigInheritance.ALWAYS;
    }

    public Maybe<Object> getConfigRaw(ConfigKey<?> key, boolean includeInherited) {
        if (this.ownConfig.containsKey(key)) {
            return Maybe.of(this.ownConfig.get(key));
        }
        if (includeInherited && this.inheritedConfig.containsKey(key)) {
            return Maybe.of((Object)this.inheritedConfig.get(key));
        }
        return Maybe.absent();
    }

    public Map<ConfigKey<?>, Object> getAllConfig() {
        LinkedHashMap result = new LinkedHashMap(this.inheritedConfig.size() + this.ownConfig.size());
        result.putAll(this.inheritedConfig);
        result.putAll(this.ownConfig);
        return Collections.unmodifiableMap(result);
    }

    public Map<ConfigKey<?>, Object> getLocalConfig() {
        LinkedHashMap result = new LinkedHashMap(this.ownConfig.size());
        result.putAll(this.ownConfig);
        return Collections.unmodifiableMap(result);
    }

    public ConfigBag getAllConfigBag() {
        return ConfigBag.newInstanceCopying(this.localConfigBag).putAll(this.ownConfig).putIfAbsent(this.inheritedConfig).putIfAbsent(this.inheritedConfigBag).seal();
    }

    public ConfigBag getLocalConfigBag() {
        return ConfigBag.newInstanceCopying(this.localConfigBag).putAll(this.ownConfig).seal();
    }

    public Object setConfig(ConfigKey<?> key, Object v) {
        Object oldVal;
        Object val = this.coerceConfigVal(key, v);
        if (key instanceof StructuredConfigKey) {
            oldVal = ((StructuredConfigKey)key).applyValueToMap(val, this.ownConfig);
            this.localConfigBag.remove(key);
        } else {
            oldVal = this.ownConfig.put(key, val);
            this.localConfigBag.put(key, v);
        }
        this.entity.config().refreshInheritedConfigOfChildren();
        return oldVal;
    }

    public void setLocalConfig(Map<ConfigKey<?>, ?> vals) {
        this.ownConfig.clear();
        this.localConfigBag.clear();
        this.ownConfig.putAll(vals);
        this.localConfigBag.putAll(vals);
    }

    public void setInheritedConfig(Map<ConfigKey<?>, ?> valsO, ConfigBag configBagVals) {
        Map<ConfigKey<?>, ?> vals = this.filterUninheritable(valsO);
        this.inheritedConfig.clear();
        this.inheritedConfig.putAll(vals);
        LinkedHashSet valKeyNames = Sets.newLinkedHashSet();
        for (ConfigKey<?> key : vals.keySet()) {
            valKeyNames.add(key.getName());
        }
        MutableMap valsUnmatched = MutableMap.builder().putAll(configBagVals.getAllConfig()).removeAll((Iterable)valKeyNames).build();
        this.inheritedConfigBag.clear();
        Map<ConfigKey<?>, SetFromFlag> annotatedConfigKeys = FlagUtils.getAnnotatedConfigKeys(this.entity.getClass());
        LinkedHashMap renamedConfigKeys = Maps.newLinkedHashMap();
        for (Map.Entry<ConfigKey<?>, SetFromFlag> entry : annotatedConfigKeys.entrySet()) {
            String rename = entry.getValue().value();
            if (rename == null) continue;
            renamedConfigKeys.put(rename, entry.getKey());
        }
        for (Map.Entry<Object, SetFromFlag> entry : valsUnmatched.entrySet()) {
            String name = (String)entry.getKey();
            SetFromFlag value = entry.getValue();
            ConfigKey key = (ConfigKey)renamedConfigKeys.get(name);
            if (key == null) {
                key = this.entity.getEntityType().getConfigKey(name);
            }
            if (key != null) {
                if (!this.isInherited(key)) continue;
                if (this.inheritedConfig.containsKey(key)) {
                    LOG.warn("Entity " + this.entity + " inherited duplicate config for key " + key + ", via explicit config and string name " + name + "; using value of key");
                    continue;
                }
                this.inheritedConfig.put(key, value);
                continue;
            }
            this.inheritedConfigBag.putStringKey(name, value);
        }
    }

    private Map<ConfigKey<?>, ?> filterUninheritable(Map<ConfigKey<?>, ?> vals) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (Map.Entry<ConfigKey<?>, ?> entry : vals.entrySet()) {
            if (!this.isInherited(entry.getKey())) continue;
            result.put(entry.getKey(), entry.getValue());
        }
        return result;
    }

    public void addToLocalBag(Map<String, ?> vals) {
        this.localConfigBag.putAll(vals);
        this.ownConfig.putAll(this.localConfigBag.getAllConfigAsConfigKeyMap());
    }

    public void clearInheritedConfig() {
        this.inheritedConfig.clear();
        this.inheritedConfigBag.clear();
    }

    public EntityConfigMap submap(Predicate<ConfigKey<?>> filter) {
        EntityConfigMap m = new EntityConfigMap(this.entity, Maps.newLinkedHashMap());
        for (Map.Entry<ConfigKey<?>, Object> entry : this.inheritedConfig.entrySet()) {
            if (!filter.apply(entry.getKey())) continue;
            m.inheritedConfig.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : this.ownConfig.entrySet()) {
            if (!filter.apply(entry.getKey())) continue;
            m.ownConfig.put(entry.getKey(), entry.getValue());
        }
        return m;
    }

    public String toString() {
        return super.toString() + "[own=" + Sanitizer.sanitize(this.ownConfig) + "; inherited=" + Sanitizer.sanitize(this.inheritedConfig) + "]";
    }
}

