/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Entity;
import brooklyn.policy.Enricher;
import brooklyn.policy.EntityAdjunct;
import brooklyn.util.collections.MutableList;
import brooklyn.util.guava.Maybe;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;

public class EntityAdjuncts {
    public static final List<String> SYSTEM_ENRICHER_UNIQUE_TAGS = ImmutableList.of((Object)"service.isUp if no service.notUp.indicators", (Object)"service.state.actual", (Object)"service-lifecycle-indicators-from-children-and-members", (Object)"service-not-up-indicators-from-children-and-members");

    public static <T extends EntityAdjunct> Maybe<T> tryFindWithUniqueTag(Iterable<T> adjuncts, Object tag) {
        Preconditions.checkNotNull((Object)tag, (Object)"tag");
        for (EntityAdjunct adjunct : adjuncts) {
            if (!tag.equals(adjunct.getUniqueTag())) continue;
            return Maybe.of((Object)adjunct);
        }
        return Maybe.absent((String)("Not found with tag " + tag));
    }

    public static List<Enricher> getNonSystemEnrichers(Entity entity) {
        MutableList result = MutableList.copyOf((Iterable)entity.getEnrichers());
        Iterator ri = result.iterator();
        while (ri.hasNext()) {
            if (!EntityAdjuncts.isSystemEnricher((Enricher)ri.next())) continue;
            ri.remove();
        }
        return result;
    }

    public static boolean isSystemEnricher(Enricher enr) {
        if (enr.getUniqueTag() == null) {
            return false;
        }
        return SYSTEM_ENRICHER_UNIQUE_TAGS.contains(enr.getUniqueTag());
    }
}

