/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.config.BrooklynProperties;
import brooklyn.config.ConfigKey;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.BrooklynConfigKeys;
import brooklyn.entity.basic.BrooklynShutdownHooks;
import brooklyn.entity.basic.BrooklynTaskTags;
import brooklyn.entity.basic.EntityAndAttribute;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Sanitizer;
import brooklyn.entity.drivers.EntityDriver;
import brooklyn.entity.drivers.downloads.DownloadResolver;
import brooklyn.entity.effector.Effectors;
import brooklyn.entity.proxying.EntityProxyImpl;
import brooklyn.entity.trait.Startable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.DependentConfiguration;
import brooklyn.location.Location;
import brooklyn.location.basic.LocationInternal;
import brooklyn.location.basic.Locations;
import brooklyn.management.ExecutionContext;
import brooklyn.management.ManagementContext;
import brooklyn.management.Task;
import brooklyn.management.TaskAdaptable;
import brooklyn.management.TaskFactory;
import brooklyn.management.internal.EffectorUtils;
import brooklyn.management.internal.LocalManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.management.internal.NonDeploymentManagementContext;
import brooklyn.policy.Enricher;
import brooklyn.policy.Policy;
import brooklyn.util.ResourceUtils;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.guava.Maybe;
import brooklyn.util.repeat.Repeater;
import brooklyn.util.stream.Streams;
import brooklyn.util.task.DynamicTasks;
import brooklyn.util.task.ParallelTask;
import brooklyn.util.task.TaskTags;
import brooklyn.util.task.Tasks;
import brooklyn.util.task.system.ProcessTaskWrapper;
import brooklyn.util.task.system.SystemTasks;
import brooklyn.util.time.Duration;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.google.common.util.concurrent.Atomics;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.io.Closeable;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Entities {
    private static final Logger log = LoggerFactory.getLogger(Entities.class);
    @Deprecated
    public static final List<String> SECRET_NAMES = ImmutableList.of((Object)"password", (Object)"passwd", (Object)"credential", (Object)"secret", (Object)"private", (Object)"access.cert", (Object)"access.key");
    public static final Object UNCHANGED = new Object();
    public static final Object REMOVE = new Object();

    public static <T> Task<List<T>> invokeEffectorList(EntityLocal callingEntity, Iterable<? extends Entity> entitiesToCall, Effector<T> effector, Map<String, ?> parameters) {
        if (entitiesToCall == null) {
            entitiesToCall = ImmutableList.of();
        }
        ArrayList tasks = Lists.newArrayList();
        for (Entity entity : entitiesToCall) {
            tasks.add(Effectors.invocation(entity, effector, parameters));
        }
        ParallelTask invoke = new ParallelTask((Map<String, ?>)MutableMap.of((Object)"displayName", (Object)(effector.getName() + " (parallel)"), (Object)"description", (Object)("Invoking effector \"" + effector.getName() + "\" on " + tasks.size() + (tasks.size() == 1 ? " entity" : " entities")), (Object)"tag", (Object)BrooklynTaskTags.tagForCallerEntity((Entity)callingEntity)), (Collection<? extends Object>)((Collection<Object>)((Collection<? extends Object>)tasks)));
        TaskTags.markInessential(invoke);
        return DynamicTasks.queueIfPossible(invoke).orSubmitAsync((Entity)callingEntity).asTask();
    }

    public static <T> Task<List<T>> invokeEffectorListWithMap(EntityLocal callingEntity, Iterable<? extends Entity> entitiesToCall, Effector<T> effector, Map<String, ?> parameters) {
        return Entities.invokeEffectorList(callingEntity, entitiesToCall, effector, parameters);
    }

    public static <T> Task<List<T>> invokeEffectorListWithArgs(EntityLocal callingEntity, Iterable<? extends Entity> entitiesToCall, Effector<T> effector, Object ... args) {
        return Entities.invokeEffectorListWithMap(callingEntity, entitiesToCall, effector, EffectorUtils.prepareArgsForEffectorAsMapFromArray(effector, args));
    }

    public static <T> Task<List<T>> invokeEffectorList(EntityLocal callingEntity, Iterable<? extends Entity> entitiesToCall, Effector<T> effector) {
        return Entities.invokeEffectorList(callingEntity, entitiesToCall, effector, Collections.emptyMap());
    }

    public static <T> Task<T> invokeEffector(EntityLocal callingEntity, Entity entityToCall, Effector<T> effector, Map<String, ?> parameters) {
        Task t = Effectors.invocation(entityToCall, effector, parameters).asTask();
        TaskTags.markInessential(t);
        t = ((EntityInternal)callingEntity).getManagementSupport().getExecutionContext().submit((Map)MutableMap.of((Object)"tag", (Object)BrooklynTaskTags.tagForCallerEntity((Entity)callingEntity)), (TaskAdaptable)t);
        if (DynamicTasks.getTaskQueuingContext() != null) {
            DynamicTasks.queue(t);
        }
        return t;
    }

    public static <T> Task<T> invokeEffectorWithArgs(EntityLocal callingEntity, Entity entityToCall, Effector<T> effector, Object ... args) {
        return Entities.invokeEffector(callingEntity, entityToCall, effector, EffectorUtils.prepareArgsForEffectorAsMapFromArray(effector, args));
    }

    public static <T> Task<T> invokeEffector(EntityLocal callingEntity, Entity entityToCall, Effector<T> effector) {
        return Entities.invokeEffector(callingEntity, entityToCall, effector, Collections.emptyMap());
    }

    public static Task<?> invokeEffector(EntityLocal callingEntity, Iterable<? extends Entity> entitiesToCall, Effector<?> effector, Map<String, ?> parameters) {
        if (Iterables.size(entitiesToCall) == 1) {
            return Entities.invokeEffector(callingEntity, entitiesToCall.iterator().next(), effector, parameters);
        }
        return Entities.invokeEffectorList(callingEntity, entitiesToCall, effector, parameters);
    }

    public static Task<?> invokeEffector(EntityLocal callingEntity, Iterable<? extends Entity> entitiesToCall, Effector<?> effector) {
        return Entities.invokeEffector(callingEntity, entitiesToCall, effector, Collections.emptyMap());
    }

    @Deprecated
    public static boolean isSecret(String name) {
        return Sanitizer.IS_SECRET_PREDICATE.apply((Object)name);
    }

    public static boolean isTrivial(Object v) {
        if (v instanceof Maybe) {
            if (!((Maybe)v).isPresent()) {
                return true;
            }
            v = ((Maybe)v).get();
        }
        return v == null || v instanceof Map && ((Map)v).isEmpty() || v instanceof Collection && ((Collection)v).isEmpty() || v instanceof CharSequence && ((CharSequence)v).length() == 0;
    }

    @Deprecated
    public static Map<String, Object> sanitize(ConfigBag input) {
        return Sanitizer.sanitize(input);
    }

    @Deprecated
    public static <K> Map<K, Object> sanitize(Map<K, ?> input) {
        return Sanitizer.sanitize(input);
    }

    public static void dumpInfo(Iterable<? extends Entity> entities) {
        for (Entity entity : entities) {
            Entities.dumpInfo(entity);
        }
    }

    public static void dumpInfo(Entity e) {
        try {
            Entities.dumpInfo(e, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Entity e, Writer out) throws IOException {
        Entities.dumpInfo(e, out, "", "  ");
    }

    public static void dumpInfo(Entity e, String currentIndentation, String tab) throws IOException {
        Entities.dumpInfo(e, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    /*
     * WARNING - void declaration
     */
    public static void dumpInfo(Entity e, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + e.toString() + " " + e.getId() + "\n");
        out.append(currentIndentation + tab + tab + "displayName = " + e.getDisplayName() + "\n");
        out.append(currentIndentation + tab + tab + "locations = " + e.getLocations() + "\n");
        LinkedHashSet keys = Sets.newLinkedHashSet(((EntityInternal)e).getConfigMap().getLocalConfig().keySet());
        for (ConfigKey<?> configKey : Entities.sortConfigKeys(keys)) {
            void var6_6;
            Maybe<Object> mv;
            ConfigKey realKey = e.getEntityType().getConfigKey(configKey.getName());
            if (realKey != null) {
                ConfigKey configKey2 = realKey;
            }
            if (Entities.isTrivial(mv = ((EntityInternal)e).config().getLocalRaw((ConfigKey<?>)var6_6))) continue;
            Object v = mv.get();
            out.append(currentIndentation + tab + tab + var6_6.getName());
            out.append(" = ");
            if (Entities.isSecret(var6_6.getName())) {
                out.append("xxxxxxxx");
            } else if (v instanceof Task && ((Task)v).isDone()) {
                if (((Task)v).isError()) {
                    out.append("ERROR in " + v);
                } else {
                    try {
                        out.append(((Task)v).get() + " (from " + v + ")");
                    }
                    catch (ExecutionException ee) {
                        throw new IllegalStateException("task " + v + " done and !isError, but threw exception on get", ee);
                    }
                    catch (InterruptedException ie) {
                        Thread.currentThread().interrupt();
                        return;
                    }
                }
            } else {
                out.append("" + v);
            }
            out.append("\n");
        }
        for (Sensor sensor : Entities.sortSensors(e.getEntityType().getSensors())) {
            Object v;
            if (!(sensor instanceof AttributeSensor) || Entities.isTrivial(v = e.getAttribute((AttributeSensor)sensor))) continue;
            out.append(currentIndentation + tab + tab + sensor.getName());
            out.append(": ");
            if (Entities.isSecret(sensor.getName())) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + v);
            }
            out.append("\n");
        }
        if (e instanceof Group) {
            StringBuilder members = new StringBuilder();
            for (Entity it : ((Group)e).getMembers()) {
                if (members.length() > 0) {
                    members.append(", ");
                }
                members.append(it.getId());
            }
            out.append(currentIndentation + tab + tab + "Members: " + members.toString() + "\n");
        }
        if (!e.getPolicies().isEmpty()) {
            out.append(currentIndentation + tab + tab + "Policies:\n");
            for (Policy policy : e.getPolicies()) {
                Entities.dumpInfo(policy, out, currentIndentation + tab + tab + tab, tab);
            }
        }
        if (!e.getEnrichers().isEmpty()) {
            out.append(currentIndentation + tab + tab + "Enrichers:\n");
            for (Enricher enricher : e.getEnrichers()) {
                Entities.dumpInfo(enricher, out, currentIndentation + tab + tab + tab, tab);
            }
        }
        for (Entity entity : e.getChildren()) {
            Entities.dumpInfo(entity, out, currentIndentation + tab, tab);
        }
        out.flush();
    }

    public static void dumpInfo(Location loc) {
        try {
            Entities.dumpInfo(loc, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Location loc, Writer out) throws IOException {
        Entities.dumpInfo(loc, out, "", "  ");
    }

    public static void dumpInfo(Location loc, String currentIndentation, String tab) throws IOException {
        Entities.dumpInfo(loc, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    public static void dumpInfo(Location loc, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + loc.toString() + "\n");
        for (Map.Entry<String, Object> entry : ((LocationInternal)loc).config().getBag().getAllConfig().entrySet()) {
            String key;
            Map.Entry<String, Object> entry2 = entry;
            String keyO = entry2.getKey();
            String string = keyO instanceof ConfigKey.HasConfigKey ? ((ConfigKey.HasConfigKey)keyO).getConfigKey().getName() : (keyO instanceof ConfigKey ? ((ConfigKey)keyO).getName() : (key = keyO == null ? null : keyO.toString()));
            Object val = entry2.getValue();
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Entities.isSecret(key)) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val);
            }
            out.append("\n");
        }
        for (Map.Entry<String, Object> entry : Entities.sortMap(FlagUtils.getFieldsWithFlags(loc)).entrySet()) {
            String key = entry.getKey();
            Object val = entry.getValue();
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Entities.isSecret(key)) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val);
            }
            out.append("\n");
        }
        for (Location location : loc.getChildren()) {
            Entities.dumpInfo(location, out, currentIndentation + tab, tab);
        }
        out.flush();
    }

    public static void dumpInfo(Enricher enr) {
        try {
            Entities.dumpInfo(enr, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Enricher enr, Writer out) throws IOException {
        Entities.dumpInfo(enr, out, "", "  ");
    }

    public static void dumpInfo(Enricher enr, String currentIndentation, String tab) throws IOException {
        Entities.dumpInfo(enr, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    public static void dumpInfo(Enricher enr, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + enr.toString() + "\n");
        for (ConfigKey<?> key : Entities.sortConfigKeys(enr.getEnricherType().getConfigKeys())) {
            Maybe<Object> val = ((BrooklynObjectInternal)enr).config().getRaw(key);
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Entities.isSecret(key.getName())) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val.get());
            }
            out.append("\n");
        }
        out.flush();
    }

    public static void dumpInfo(Policy pol) {
        try {
            Entities.dumpInfo(pol, (Writer)new PrintWriter(System.out), "", "  ");
        }
        catch (IOException exc) {
            throw new RuntimeException(exc);
        }
    }

    public static void dumpInfo(Policy pol, Writer out) throws IOException {
        Entities.dumpInfo(pol, out, "", "  ");
    }

    public static void dumpInfo(Policy pol, String currentIndentation, String tab) throws IOException {
        Entities.dumpInfo(pol, (Writer)new PrintWriter(System.out), currentIndentation, tab);
    }

    public static void dumpInfo(Policy pol, Writer out, String currentIndentation, String tab) throws IOException {
        out.append(currentIndentation + pol.toString() + "\n");
        for (ConfigKey<?> key : Entities.sortConfigKeys(pol.getPolicyType().getConfigKeys())) {
            Maybe<Object> val = ((BrooklynObjectInternal)pol).config().getRaw(key);
            if (Entities.isTrivial(val)) continue;
            out.append(currentIndentation + tab + tab + key);
            out.append(" = ");
            if (Entities.isSecret(key.getName())) {
                out.append("xxxxxxxx");
            } else {
                out.append("" + val.get());
            }
            out.append("\n");
        }
        out.flush();
    }

    public static List<Sensor<?>> sortSensors(Set<Sensor<?>> sensors) {
        ArrayList result = new ArrayList(sensors);
        Collections.sort(result, new Comparator<Sensor>(){

            @Override
            public int compare(Sensor arg0, Sensor arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return result;
    }

    public static List<ConfigKey<?>> sortConfigKeys(Set<ConfigKey<?>> configs) {
        ArrayList result = new ArrayList(configs);
        Collections.sort(result, new Comparator<ConfigKey>(){

            @Override
            public int compare(ConfigKey arg0, ConfigKey arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        });
        return result;
    }

    public static <T> Map<String, T> sortMap(Map<String, T> map) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        ArrayList order = Lists.newArrayList(map.keySet());
        Collections.sort(order, String.CASE_INSENSITIVE_ORDER);
        for (String key : order) {
            result.put(key, map.get(key));
        }
        return result;
    }

    public static boolean isAncestor(Entity descendant, Entity potentialAncestor) {
        for (Entity ancestor = descendant.getParent(); ancestor != null; ancestor = ancestor.getParent()) {
            if (!ancestor.equals(potentialAncestor)) continue;
            return true;
        }
        return false;
    }

    public static boolean isDescendant(Entity ancestor, Entity potentialDescendant) {
        LinkedHashSet inspected = Sets.newLinkedHashSet();
        Stack<Entity> toinspect = new Stack<Entity>();
        toinspect.add(ancestor);
        while (!toinspect.isEmpty()) {
            Entity e = (Entity)toinspect.pop();
            if (e.getChildren().contains(potentialDescendant)) {
                return true;
            }
            inspected.add(e);
            toinspect.addAll(e.getChildren());
            toinspect.removeAll(inspected);
        }
        return false;
    }

    public static Iterable<Entity> descendants(Entity root, Predicate<? super Entity> matching, boolean includeSelf) {
        Iterable descs = Iterables.concat((Iterable)Iterables.transform((Iterable)root.getChildren(), (Function)new Function<Entity, Iterable<Entity>>(){

            public Iterable<Entity> apply(Entity input) {
                return Entities.descendants(input);
            }
        }));
        return Iterables.filter((Iterable)Iterables.concat((Iterable)descs, Collections.singleton(root)), matching);
    }

    public static Iterable<Entity> descendants(Entity root, Predicate<? super Entity> matching) {
        return Entities.descendants(root, matching, true);
    }

    public static Iterable<Entity> descendants(Entity root) {
        return Entities.descendants(root, (Predicate<? super Entity>)Predicates.alwaysTrue(), true);
    }

    public static <T extends Entity> Iterable<T> descendants(Entity root, Class<T> ofType) {
        return Iterables.filter(Entities.descendants(root), ofType);
    }

    public static Iterable<Entity> ancestors(final Entity root) {
        return new Iterable<Entity>(){

            @Override
            public Iterator<Entity> iterator() {
                return new Iterator<Entity>(){
                    Entity next;
                    {
                        this.next = root;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.next != null;
                    }

                    @Override
                    public Entity next() {
                        Entity result = this.next;
                        this.next = this.next.getParent();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public static void invokeStopOnShutdown(Entity entity) {
        BrooklynShutdownHooks.invokeStopOnShutdown(entity);
    }

    public static void start(Entity e, Collection<? extends Location> locations) {
        if (!Entities.isManaged(e) && !Entities.manage(e)) {
            log.warn("Using discouraged mechanism to start management -- Entities.start(Application, Locations) -- caller should create and use the preferred management context");
            Entities.startManagement(e);
        }
        if (e instanceof Startable) {
            Entities.invokeEffector((EntityLocal)e, e, Startable.START, MutableMap.of((Object)"locations", locations)).getUnchecked();
        }
    }

    public static void destroy(Entity e) {
        if (Entities.isManaged(e)) {
            if (Entities.isReadOnly(e).booleanValue()) {
                Entities.unmanage(e);
                log.debug("destroyed and unmanaged read-only copy of " + e);
            } else {
                if (e instanceof Startable) {
                    Entities.invokeEffector((EntityLocal)e, e, Startable.STOP).getUnchecked();
                }
                if (e instanceof EntityInternal) {
                    ((EntityInternal)e).destroy();
                }
                Entities.unmanage(e);
                log.debug("destroyed and unmanaged " + e + "; mgmt now " + (e.getApplicationId() == null ? "(no app)" : e.getApplication().getManagementContext()) + " - managed? " + Entities.isManaged(e));
            }
        } else {
            log.debug("skipping destroy of " + e + ": not managed");
        }
    }

    public static void destroyCatching(Entity entity) {
        try {
            Entities.destroy(entity);
        }
        catch (Exception e) {
            log.warn("ERROR destroying " + entity + " (ignoring): " + e, (Throwable)e);
            Exceptions.propagateIfFatal((Throwable)e);
        }
    }

    public static void destroy(Location loc) {
        if (loc instanceof Closeable) {
            Streams.closeQuietly((Closeable)((Closeable)loc));
            log.debug("closed " + loc);
        }
    }

    public static void destroyCatching(Location loc) {
        try {
            Entities.destroy(loc);
        }
        catch (Exception e) {
            log.warn("ERROR destroying " + loc + " (ignoring): " + e, (Throwable)e);
            Exceptions.propagateIfFatal((Throwable)e);
        }
    }

    public static void destroyAll(final ManagementContext mgmt) {
        if (mgmt instanceof NonDeploymentManagementContext) {
            log.warn("Entities.destroyAll invoked on non-deployment " + mgmt + " - not likely to have much effect! " + "(This usually means the mgmt context has been taken from an entity that has been destroyed. " + "To destroy other things on the management context ensure you keep a handle to the context " + "before the entity is destroyed, such as by creating the management context first.)");
        }
        if (!mgmt.isRunning()) {
            return;
        }
        ListeningExecutorService executor = MoreExecutors.listeningDecorator((ExecutorService)Executors.newCachedThreadPool());
        ArrayList futures = Lists.newArrayList();
        final AtomicReference error = Atomics.newReference();
        try {
            log.debug("destroying all apps in " + mgmt + ": " + mgmt.getApplications());
            for (final Application app : mgmt.getApplications()) {
                futures.add(executor.submit(new Runnable(){

                    @Override
                    public void run() {
                        log.debug("destroying app " + app + " (managed? " + Entities.isManaged((Entity)app) + "; mgmt is " + mgmt + ")");
                        try {
                            Entities.destroy((Entity)app);
                            log.debug("destroyed app " + app + "; mgmt now " + mgmt);
                        }
                        catch (Exception e) {
                            log.warn("problems destroying app " + app + " (mgmt now " + mgmt + ", will rethrow at least one exception): " + e);
                            error.compareAndSet(null, e);
                        }
                    }
                }));
            }
            Futures.allAsList((Iterable)futures).get();
            for (Location loc : mgmt.getLocationManager().getLocations()) {
                Entities.destroyCatching(loc);
            }
            if (mgmt instanceof ManagementContextInternal) {
                ((ManagementContextInternal)mgmt).terminate();
            }
            if (error.get() != null) {
                throw Exceptions.propagate((Throwable)((Throwable)error.get()));
            }
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        catch (ExecutionException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            executor.shutdownNow();
        }
    }

    public static void destroyAllCatching(ManagementContext mgmt) {
        try {
            Entities.destroyAll(mgmt);
        }
        catch (Exception e) {
            log.warn("ERROR destroying " + mgmt + " (ignoring): " + e, (Throwable)e);
            Exceptions.propagateIfFatal((Throwable)e);
        }
    }

    public static boolean isManaged(Entity e) {
        return ((EntityInternal)e).getManagementSupport().isDeployed() && ((EntityInternal)e).getManagementContext().isRunning();
    }

    public static boolean isNoLongerManaged(Entity e) {
        return ((EntityInternal)e).getManagementSupport().isNoLongerManaged();
    }

    @Beta
    public static Boolean isReadOnly(Entity e) {
        return ((EntityInternal)e).getManagementSupport().isReadOnly();
    }

    @Beta
    @VisibleForTesting
    public static AbstractEntity deproxy(Entity e) {
        if (!Proxy.isProxyClass(e.getClass())) {
            log.warn("Attempt to deproxy non-proxy " + e, new Throwable("Location of attempt to deproxy non-proxy " + e));
            return (AbstractEntity)e;
        }
        return (AbstractEntity)((EntityProxyImpl)Proxy.getInvocationHandler(e)).getDelegate();
    }

    @Beta
    public static <T extends Entity> T proxy(T e) {
        return (T)(e == null ? null : (e instanceof Proxy ? (Entity)e : ((AbstractEntity)e).getProxyIfAvailable()));
    }

    public static boolean manage(Entity e) {
        Entity o = e.getParent();
        Entity eum = e;
        if (o == null) {
            throw new IllegalArgumentException("Can't manage " + e + " because it is an orphan");
        }
        while (o.getParent() != null) {
            if (!Entities.isManaged(o)) {
                eum = o;
            }
            o = o.getParent();
        }
        if (Entities.isManaged(o)) {
            ((EntityInternal)o).getManagementContext().getEntityManager().manage(eum);
            return true;
        }
        if (!(o instanceof Application)) {
            throw new IllegalStateException("Can't manage " + e + " because it is not rooted at an application");
        }
        return false;
    }

    @Beta
    public static ManagementContext startManagement(Entity e) {
        Entity o = e;
        Entity eum = e;
        while (o.getParent() != null) {
            if (!Entities.isManaged(o)) {
                eum = o;
            }
            o = o.getParent();
        }
        if (Entities.isManaged(o)) {
            ManagementContext mgmt = ((EntityInternal)o).getManagementContext();
            mgmt.getEntityManager().manage(eum);
            return mgmt;
        }
        if (!(o instanceof Application)) {
            throw new IllegalStateException("Can't manage " + e + " because it is not rooted at an application");
        }
        log.warn("Deprecated invocation of startManagement for " + e + " without a management context present; " + "a new local management context is being created! (Not recommended unless you really know what you are doing.)");
        LocalManagementContext mgmt = new LocalManagementContext();
        mgmt.getEntityManager().manage(o);
        return mgmt;
    }

    public static ManagementContext startManagement(Application app, ManagementContext mgmt) {
        if (Entities.isManaged((Entity)app)) {
            throw new IllegalStateException("Application " + app + " is already managed, so can't set brooklyn properties");
        }
        mgmt.getEntityManager().manage((Entity)app);
        return mgmt;
    }

    public static ManagementContext startManagement(Application app, BrooklynProperties props) {
        if (Entities.isManaged((Entity)app)) {
            throw new IllegalStateException("Application " + app + " is already managed, so can't set brooklyn properties");
        }
        LocalManagementContext mgmt = new LocalManagementContext(props);
        mgmt.getEntityManager().manage((Entity)app);
        return mgmt;
    }

    public static ManagementContext newManagementContext() {
        return new LocalManagementContext();
    }

    public static ManagementContext newManagementContext(BrooklynProperties props) {
        return new LocalManagementContext(props);
    }

    public static ManagementContext newManagementContext(Map<?, ?> props) {
        return new LocalManagementContext(BrooklynProperties.Factory.newEmpty().addFromMap(props));
    }

    public static void unmanage(Entity entity) {
        if (((EntityInternal)entity).getManagementSupport().isDeployed()) {
            ((EntityInternal)entity).getManagementContext().getEntityManager().unmanage(entity);
        }
    }

    public static DownloadResolver newDownloader(EntityDriver driver) {
        return Entities.newDownloader(driver, ImmutableMap.of());
    }

    public static DownloadResolver newDownloader(EntityDriver driver, Map<String, ?> properties) {
        EntityInternal internal = (EntityInternal)driver.getEntity();
        return internal.getManagementContext().getEntityDownloadsManager().newDownloader(driver, properties);
    }

    public static DownloadResolver newDownloader(EntityDriver driver, String addon) {
        return Entities.newDownloader(driver, addon, ImmutableMap.of());
    }

    public static DownloadResolver newDownloader(EntityDriver driver, String addon, Map<String, ?> properties) {
        EntityInternal internal = (EntityInternal)driver.getEntity();
        return internal.getManagementContext().getEntityDownloadsManager().newDownloader(driver, addon, properties);
    }

    public static <T> Supplier<T> attributeSupplier(Entity entity, AttributeSensor<T> sensor) {
        return EntityAndAttribute.supplier(entity, sensor);
    }

    public static <T> Supplier<T> attributeSupplier(EntityAndAttribute<T> tuple) {
        return tuple;
    }

    public static <T> Supplier<T> attributeSupplierWhenReady(EntityAndAttribute<T> tuple) {
        return Entities.attributeSupplierWhenReady(tuple.getEntity(), tuple.getAttribute());
    }

    public static <T> Supplier<T> attributeSupplierWhenReady(final Entity entity, final AttributeSensor<T> sensor) {
        final Task<T> task = DependentConfiguration.attributeWhenReady(entity, sensor);
        return new Supplier<T>(){

            public T get() {
                try {
                    TypeToken type = new TypeToken<T>(sensor.getType()){};
                    return Tasks.resolveValue(task, type.getRawType(), ((EntityInternal)entity).getExecutionContext(), "attributeSupplierWhenReady");
                }
                catch (Exception e) {
                    throw Exceptions.propagate((Throwable)e);
                }
            }
        };
    }

    @Deprecated
    public static void manage(Location loc, ManagementContext managementContext) {
        Locations.manage(loc, managementContext);
    }

    public static String getRequiredUrlConfig(Entity entity, ConfigKey<String> urlKey) {
        String url = (String)entity.getConfig(urlKey);
        Preconditions.checkNotNull((Object)url, (String)"Key %s on %s should not be null", (Object[])new Object[]{urlKey, entity});
        if (!ResourceUtils.create(entity).doesUrlExist(url)) {
            throw new IllegalStateException(String.format("Key %s on %s contains unavailable URL %s", urlKey, entity, url));
        }
        return url;
    }

    public static String getRequiredUrlConfig(Entity entity, ConfigKey.HasConfigKey<String> urlKey) {
        return Entities.getRequiredUrlConfig(entity, (ConfigKey<String>)urlKey.getConfigKey());
    }

    public static String checkRequiredUrl(Entity entity, String url) {
        Preconditions.checkNotNull((Object)url, (Object)"url");
        if (!ResourceUtils.create(entity).doesUrlExist(url)) {
            throw new IllegalStateException(String.format("URL %s on %s is unavailable", url, entity));
        }
        return url;
    }

    public static <T extends TaskAdaptable<?>> T submit(Entity entity, final TaskFactory<T> taskFactory) {
        final Semaphore s = new Semaphore(0);
        final AtomicReference result = new AtomicReference();
        ExecutionContext executionContext = ((EntityInternal)entity).getManagementSupport().getExecutionContext();
        executionContext.execute(new Runnable(){

            @Override
            public void run() {
                TaskAdaptable t = taskFactory.newTask();
                result.set(t);
                s.release();
            }
        });
        try {
            s.acquire();
        }
        catch (InterruptedException e) {
            throw Exceptions.propagate((Throwable)e);
        }
        executionContext.submit((TaskAdaptable)((TaskAdaptable)result.get()).asTask());
        return (T)((TaskAdaptable)result.get());
    }

    public static <T extends TaskAdaptable<?>> T submit(Entity entity, T task) {
        ExecutionContext executionContext = ((EntityInternal)entity).getManagementSupport().getExecutionContext();
        executionContext.submit((TaskAdaptable)task.asTask());
        return task;
    }

    public static void warnOnIgnoringConfig(Entity entity, ConfigKey<?> key) {
        if (entity.getConfigRaw(key, true).isPresentAndNonNull()) {
            log.warn("Ignoring " + key + " set on " + entity + " (" + entity.getConfig(key) + ")");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForServiceUp(final Entity entity, Duration timeout) {
        String description = "Waiting for SERVICE_UP on " + entity;
        Tasks.setBlockingDetails(description);
        try {
            if (!Repeater.create((String)description).limitTimeTo(timeout).rethrowException().backoffTo(Duration.ONE_SECOND).until((Callable)new Callable<Boolean>(){

                @Override
                public Boolean call() {
                    return Boolean.TRUE.equals(entity.getAttribute(Startable.SERVICE_UP));
                }
            }).run()) {
                throw new IllegalStateException("Timeout waiting for SERVICE_UP from " + entity);
            }
        }
        finally {
            Tasks.resetBlockingDetails();
        }
        log.debug("Detected SERVICE_UP for software {}", (Object)entity);
    }

    public static void waitForServiceUp(Entity entity, long duration, TimeUnit units) {
        Entities.waitForServiceUp(entity, Duration.of((long)duration, (TimeUnit)units));
    }

    public static void waitForServiceUp(Entity entity) {
        Duration timeout = (Duration)entity.getConfig(BrooklynConfigKeys.START_TIMEOUT);
        Entities.waitForServiceUp(entity, timeout);
    }

    @Beta
    public static ProcessTaskWrapper<Integer> shell(ManagementContext mgmt, String command) {
        ProcessTaskWrapper t = (ProcessTaskWrapper)SystemTasks.exec(command).newTask();
        mgmt.getServerExecutionContext().submit((TaskAdaptable)t).getUnchecked();
        System.out.println(t.getStdout());
        System.err.println(t.getStderr());
        return t;
    }
}

