/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.annotation.EffectorParam;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.BasicStartable;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.location.Location;
import brooklyn.util.config.ConfigBag;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EffectorStartableImpl
extends AbstractEntity
implements BasicStartable {
    private static final long serialVersionUID = -7109357808001370568L;
    private static final Logger log = LoggerFactory.getLogger(EffectorStartableImpl.class);

    @Override
    @Effector(description="Start the process/service represented by an entity")
    public void start(@EffectorParam(name="locations") Collection<? extends Location> locations) {
        log.info("Invoking start (method) on " + this);
        this.invoke(START, ConfigBag.newInstance().configure(StartParameters.LOCATIONS, locations).getAllConfig()).getUnchecked();
    }

    @Override
    @Effector(description="Stop the process/service represented by an entity")
    public void stop() {
        log.info("Invoking stop (method) on " + this);
        this.invoke(STOP).getUnchecked();
    }

    @Override
    @Effector(description="Restart the process/service represented by an entity")
    public void restart() {
        log.info("Invoking restart (method) on " + this);
        this.invoke(RESTART).getUnchecked();
    }

    public static class StartParameters {
        public static final ConfigKey<Collection<? extends Location>> LOCATIONS = ConfigKeys.newConfigKey(new TypeToken<Collection<? extends Location>>(){}, "locations", "locations where the entity should be started");
    }
}

