/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.annotation.Effector;
import brooklyn.entity.basic.AbstractGroup;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.DynamicGroupImpl;
import brooklyn.entity.basic.MethodEffector;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.basic.Sensors;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.base.Predicate;
import com.google.common.reflect.TypeToken;
import groovy.lang.Closure;

@ImplementedBy(value=DynamicGroupImpl.class)
public interface DynamicGroup
extends AbstractGroup {
    @SetFromFlag(value="entityFilter")
    public static final ConfigKey<Predicate<? super Entity>> ENTITY_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<? super Entity>>(){}, "dynamicgroup.entityfilter", "Filter for entities which will automatically be in the group");
    public static final AttributeSensor<Boolean> RUNNING = Sensors.newBooleanSensor("dynamicgroup.running", "Whether the entity is running, and will automatically update group membership");
    public static final MethodEffector<Void> RESCAN_EFFECTOR = new MethodEffector(DynamicGroup.class, "rescanEntities");

    @Deprecated
    public void stop();

    @Effector(description="Rescans all entities to determine whether they match the configured filter.")
    public void rescanEntities();

    public void setEntityFilter(Predicate<? super Entity> var1);

    @Deprecated
    public void setEntityFilter(Closure<Boolean> var1);

    public <T> void addSubscription(Entity var1, Sensor<T> var2, Predicate<? super SensorEvent<? super T>> var3);

    public <T> void addSubscription(Entity var1, Sensor<T> var2);

    public Predicate<? super Entity> entityFilter();
}

