/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.DelegateEntityImpl;
import brooklyn.entity.proxying.ImplementedBy;
import brooklyn.event.AttributeSensor;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import com.google.common.base.Function;
import java.util.concurrent.atomic.AtomicBoolean;

@ImplementedBy(value=DelegateEntityImpl.class)
public interface DelegateEntity
extends Entity {
    public static final AttributeSensorAndConfigKey<Entity, Entity> DELEGATE_ENTITY = ConfigKeys.newSensorAndConfigKey(Entity.class, "delegate.entity", "The delegate entity");
    public static final AttributeSensor<String> DELEGATE_ENTITY_LINK = Sensors.newStringSensor("webapp.url", "The delegate entity link");

    public static class EntityUrl {
        private static final AtomicBoolean initialized = new AtomicBoolean(false);
        private static final Function<Entity, String> entityUrlFunction = new Function<Entity, String>(){

            public String apply(Entity input) {
                if (input == null) {
                    return null;
                }
                Entity entity = input;
                String url = String.format("#/v1/applications/%s/entities/%s", entity.getApplicationId(), entity.getId());
                return url;
            }
        };

        public static Function<Entity, String> entityUrl() {
            return entityUrlFunction;
        }

        public static void init() {
            if (initialized.getAndSet(true)) {
                return;
            }
            RendererHints.register(DELEGATE_ENTITY, RendererHints.namedActionWithUrl(EntityUrl.entityUrl()));
            RendererHints.register(DELEGATE_ENTITY_LINK, RendererHints.namedActionWithUrl());
        }

        static {
            EntityUrl.init();
        }
    }
}

