/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.DataEntity;
import brooklyn.event.AttributeSensor;
import brooklyn.event.feed.function.FunctionFeed;
import brooklyn.event.feed.function.FunctionPollConfig;
import brooklyn.location.Location;
import com.google.common.base.Functions;
import com.google.common.base.Supplier;
import java.util.Collection;
import java.util.Map;

public class DataEntityImpl
extends AbstractEntity
implements DataEntity {
    private FunctionFeed feed;

    @Override
    public void start(Collection<? extends Location> locations) {
        this.connectSensors();
        this.setAttribute(SERVICE_UP, Boolean.TRUE);
    }

    @Override
    public void stop() {
        this.setAttribute(SERVICE_UP, Boolean.FALSE);
        this.disconnectSensors();
    }

    @Override
    public void restart() {
        this.stop();
        this.start(this.getLocations());
    }

    protected void connectSensors() {
        FunctionFeed.Builder builder = FunctionFeed.builder().entity(this).period((Long)this.getConfig(POLL_PERIOD));
        Map map = (Map)this.getConfig(SENSOR_SUPPLIER_MAP);
        if (map != null && map.size() > 0) {
            for (Map.Entry entry : map.entrySet()) {
                AttributeSensor sensor = (AttributeSensor)entry.getKey();
                Supplier supplier = (Supplier)entry.getValue();
                builder.poll((FunctionPollConfig)new FunctionPollConfig(sensor).supplier(supplier).onFailureOrException(Functions.constant(null)));
            }
        }
        this.feed = builder.build();
    }

    protected void disconnectSensors() {
        if (this.feed != null) {
            this.feed.stop();
        }
    }
}

