/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicConfigKey;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.TemplatedStringAttributeSensorAndConfigKey;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.text.Strings;
import brooklyn.util.time.Duration;
import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigKeys {
    private static final Logger log = LoggerFactory.getLogger(ConfigKeys.class);

    public static <T> ConfigKey<T> newConfigKey(Class<T> type, String name) {
        return new BasicConfigKey<T>(type, name);
    }

    public static <T> ConfigKey<T> newConfigKey(Class<T> type, String name, String description) {
        return new BasicConfigKey<T>(type, name, description);
    }

    public static <T> ConfigKey<T> newConfigKey(TypeToken<T> type, String name) {
        return new BasicConfigKey<T>(type, name);
    }

    public static <T> ConfigKey<T> newConfigKey(TypeToken<T> type, String name, String description) {
        return new BasicConfigKey<T>(type, name, description);
    }

    public static <T> ConfigKey<T> newConfigKey(Class<T> type, String name, String description, T defaultValue) {
        return new BasicConfigKey<T>(type, name, description, defaultValue);
    }

    public static <T> ConfigKey<T> newConfigKey(TypeToken<T> type, String name, String description, T defaultValue) {
        return new BasicConfigKey<T>(type, name, description, defaultValue);
    }

    public static <T> AttributeSensorAndConfigKey<T, T> newSensorAndConfigKey(Class<T> type, String name, String description) {
        return new BasicAttributeSensorAndConfigKey<T>(type, name, description);
    }

    public static <T> AttributeSensorAndConfigKey<T, T> newSensorAndConfigKey(Class<T> type, String name, String description, T defaultValue) {
        return new BasicAttributeSensorAndConfigKey<T>(type, name, description, defaultValue);
    }

    public static <T> AttributeSensorAndConfigKey<T, T> newSensorAndConfigKey(TypeToken<T> type, String name, String description) {
        return new BasicAttributeSensorAndConfigKey<T>(type, name, description);
    }

    public static <T> AttributeSensorAndConfigKey<T, T> newSensorAndConfigKey(TypeToken<T> type, String name, String description, T defaultValue) {
        return new BasicAttributeSensorAndConfigKey<T>(type, name, description, defaultValue);
    }

    public static AttributeSensorAndConfigKey<String, String> newStringSensorAndConfigKey(String name, String description) {
        return new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey(name, description);
    }

    public static AttributeSensorAndConfigKey<String, String> newStringSensorAndConfigKey(String name, String description, String defaultValue) {
        return new BasicAttributeSensorAndConfigKey.StringAttributeSensorAndConfigKey(name, description, defaultValue);
    }

    public static AttributeSensorAndConfigKey<String, String> newTemplateSensorAndConfigKey(String name, String description) {
        return new TemplatedStringAttributeSensorAndConfigKey(name, description);
    }

    public static AttributeSensorAndConfigKey<String, String> newTemplateSensorAndConfigKey(String name, String description, String defaultValue) {
        return new TemplatedStringAttributeSensorAndConfigKey(name, description, defaultValue);
    }

    public static AttributeSensorAndConfigKey<Integer, Integer> newIntegerSensorAndConfigKey(String name, String description) {
        return new BasicAttributeSensorAndConfigKey.IntegerAttributeSensorAndConfigKey(name, description);
    }

    public static AttributeSensorAndConfigKey<Integer, Integer> newIntegerSensorAndConfigKey(String name, String description, Integer defaultValue) {
        return new BasicAttributeSensorAndConfigKey.IntegerAttributeSensorAndConfigKey(name, description, defaultValue);
    }

    public static PortAttributeSensorAndConfigKey newPortSensorAndConfigKey(String name, String description) {
        return new PortAttributeSensorAndConfigKey(name, description);
    }

    public static PortAttributeSensorAndConfigKey newPortSensorAndConfigKey(String name, String description, Object defaultValue) {
        return new PortAttributeSensorAndConfigKey(name, description, defaultValue);
    }

    public static <T> ConfigKey<T> newConfigKey(String name, String description, @Nonnull T defaultValue) {
        return new BasicConfigKey(Preconditions.checkNotNull(defaultValue, (Object)"Type must be exlicit for ConfigKey if defaultValue is null").getClass(), name, description, defaultValue);
    }

    public static <T> BasicConfigKey.Builder<T> builder(Class<T> type) {
        return BasicConfigKey.builder(type);
    }

    public static <T> BasicConfigKey.Builder<T> builder(TypeToken<T> type) {
        return BasicConfigKey.builder(type);
    }

    public static <T> BasicConfigKey.Builder<T> builder(Class<T> type, String name) {
        return BasicConfigKey.builder(type, name);
    }

    public static <T> BasicConfigKey.Builder<T> builder(TypeToken<T> type, String name) {
        return BasicConfigKey.builder(type, name);
    }

    public static <T> ConfigKey<T> newConfigKeyWithDefault(ConfigKey<T> parent, T defaultValue) {
        return new BasicConfigKey.BasicConfigKeyOverwriting<T>(parent, defaultValue);
    }

    public static <T> ConfigKey<T> newConfigKeyWithDefault(ConfigKey<T> parent, String newDescription, T defaultValue) {
        return new BasicConfigKey.BasicConfigKeyOverwriting<T>(parent, newDescription, defaultValue);
    }

    public static <T> ConfigKey<T> newConfigKeyRenamed(String newName, ConfigKey<T> key) {
        return new BasicConfigKey<Object>(key.getTypeToken(), newName, key.getDescription(), key.getDefaultValue());
    }

    public static <T> ConfigKey<T> newConfigKeyWithPrefix(String prefix, ConfigKey<T> key) {
        return ConfigKeys.newConfigKeyRenamed(prefix + key.getName(), key);
    }

    public static <T> ConfigKey<T> convert(ConfigKey<T> key, CaseFormat inputCaseStrategy, CaseFormat outputCaseStrategy) {
        return ConfigKeys.newConfigKeyRenamed(inputCaseStrategy.to(outputCaseStrategy, key.getName()), key);
    }

    public static ConfigKey<String> newStringConfigKey(String name) {
        return ConfigKeys.newConfigKey(String.class, name);
    }

    public static ConfigKey<String> newStringConfigKey(String name, String description) {
        return ConfigKeys.newConfigKey(String.class, name, description);
    }

    public static ConfigKey<String> newStringConfigKey(String name, String description, String defaultValue) {
        return ConfigKeys.newConfigKey(String.class, name, description, defaultValue);
    }

    public static ConfigKey<Integer> newIntegerConfigKey(String name) {
        return ConfigKeys.newConfigKey(Integer.class, name);
    }

    public static ConfigKey<Integer> newIntegerConfigKey(String name, String description) {
        return ConfigKeys.newConfigKey(Integer.class, name, description);
    }

    public static ConfigKey<Integer> newIntegerConfigKey(String name, String description, Integer defaultValue) {
        return ConfigKeys.newConfigKey(Integer.class, name, description, defaultValue);
    }

    public static ConfigKey<Long> newLongConfigKey(String name) {
        return ConfigKeys.newConfigKey(Long.class, name);
    }

    public static ConfigKey<Long> newLongConfigKey(String name, String description) {
        return ConfigKeys.newConfigKey(Long.class, name, description);
    }

    public static ConfigKey<Long> newLongConfigKey(String name, String description, Long defaultValue) {
        return ConfigKeys.newConfigKey(Long.class, name, description, defaultValue);
    }

    public static ConfigKey<Double> newDoubleConfigKey(String name) {
        return ConfigKeys.newConfigKey(Double.class, name);
    }

    public static ConfigKey<Double> newDoubleConfigKey(String name, String description) {
        return ConfigKeys.newConfigKey(Double.class, name, description);
    }

    public static ConfigKey<Double> newDoubleConfigKey(String name, String description, Double defaultValue) {
        return ConfigKeys.newConfigKey(Double.class, name, description, defaultValue);
    }

    public static ConfigKey<Boolean> newBooleanConfigKey(String name) {
        return ConfigKeys.newConfigKey(Boolean.class, name);
    }

    public static ConfigKey<Boolean> newBooleanConfigKey(String name, String description) {
        return ConfigKeys.newConfigKey(Boolean.class, name, description);
    }

    public static ConfigKey<Boolean> newBooleanConfigKey(String name, String description, Boolean defaultValue) {
        return ConfigKeys.newConfigKey(Boolean.class, name, description, defaultValue);
    }

    public static ConfigKey<Duration> newDurationConfigKey(String name) {
        return ConfigKeys.newConfigKey(Duration.class, name);
    }

    public static ConfigKey<Duration> newDurationConfigKey(String name, String description) {
        return ConfigKeys.newConfigKey(Duration.class, name, description);
    }

    public static ConfigKey<Duration> newDurationConfigKey(String name, String description, Duration defaultValue) {
        return ConfigKeys.newConfigKey(Duration.class, name, description, defaultValue);
    }

    public static class DynamicKeys {
        public static final ConfigKey<String> NAME = ConfigKeys.newStringConfigKey("name");
        public static final ConfigKey<String> DESCRIPTION = ConfigKeys.newStringConfigKey("description");
        public static final ConfigKey<Object> DEFAULT_VALUE = ConfigKeys.newConfigKey(Object.class, "defaultValue");

        public static ConfigKey<?> newInstance(ConfigBag keyDefs) {
            String typeName = Strings.toString((Object)keyDefs.getStringKey("type"));
            if (Strings.isNonBlank((CharSequence)typeName)) {
                log.warn("Setting 'type' is not currently supported for dynamic config keys; ignoring in definition of " + keyDefs);
            }
            Class<Object> type = Object.class;
            String name = keyDefs.get(NAME);
            String description = keyDefs.get(DESCRIPTION);
            Object defaultValue = keyDefs.get(DEFAULT_VALUE);
            return ConfigKeys.newConfigKey(type, name, description, defaultValue);
        }

        public static ConfigKey<?> newInstance(Map<?, ?> keyDefs) {
            return DynamicKeys.newInstance(ConfigBag.newInstance(keyDefs));
        }

        public static ConfigKey<?> newNamedInstance(String name, Map<?, ?> keyDefs) {
            ConfigBag defs = ConfigBag.newInstance(keyDefs);
            String oldName = defs.put(NAME, name);
            if (oldName != null && !oldName.equals(name)) {
                log.warn("Dynamic key '" + oldName + "' being overridden as key '" + name + "' in " + keyDefs);
            }
            return DynamicKeys.newInstance(defs);
        }
    }
}

