/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import com.google.common.annotations.Beta;
import java.io.Serializable;
import org.codehaus.jackson.annotate.JsonProperty;

@Beta
public class BrooklynTags {
    public static final String YAML_SPEC_KIND = "yaml_spec";
    public static final String NOTES_KIND = "notes";

    public static NamedStringTag newYamlSpecTag(String contents) {
        return new NamedStringTag(YAML_SPEC_KIND, contents);
    }

    public static NamedStringTag newNotesTag(String contents) {
        return new NamedStringTag(NOTES_KIND, contents);
    }

    public static NamedStringTag findFirst(String kind, Iterable<Object> tags) {
        for (Object object : tags) {
            if (!(object instanceof NamedStringTag) || !kind.equals(((NamedStringTag)object).kind)) continue;
            return (NamedStringTag)object;
        }
        return null;
    }

    public static class NamedStringTag
    implements Serializable {
        private static final long serialVersionUID = 7932098757009051348L;
        @JsonProperty
        final String kind;
        @JsonProperty
        final String contents;

        public NamedStringTag(@JsonProperty(value="kind") String kind, @JsonProperty(value="contents") String contents) {
            this.kind = kind;
            this.contents = contents;
        }

        public String toString() {
            return this.kind + "[" + this.contents + "]";
        }

        public String getKind() {
            return this.kind;
        }

        public String getContents() {
            return this.contents;
        }
    }
}

