/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.BrooklynServerConfig;
import brooklyn.config.ConfigKey;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.TemplatedStringAttributeSensorAndConfigKey;
import brooklyn.util.internal.ssh.ShellTool;
import brooklyn.util.internal.ssh.SshTool;
import brooklyn.util.time.Duration;
import com.google.common.base.Preconditions;

public class BrooklynConfigKeys {
    @Deprecated
    public static final ConfigKey<String> BROOKLYN_PERSISTENCE_DIR = BrooklynServerConfig.PERSISTENCE_DIR;
    @Deprecated
    public static final ConfigKey<String> BROOKLYN_DATA_DIR = BrooklynServerConfig.BROOKLYN_DATA_DIR;
    public static final ConfigKey<String> ONBOX_BASE_DIR = ConfigKeys.newStringConfigKey("onbox.base.dir", "Default base directory on target machines where Brooklyn config data is stored; default depends on the location, either ~/brooklyn-managed-processes or /tmp/brooklyn-${username} on localhost");
    public static final ConfigKey<Boolean> SKIP_ON_BOX_BASE_DIR_RESOLUTION = ConfigKeys.newBooleanConfigKey("onbox.base.dir.skipResolution", "Whether to skip on-box directory resolution (which can require ssh'ing), and just assume the directory exists; can be set on machine or on entity", false);
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newStringConfigKey("install.version", "Suggested version");
    public static final ConfigKey<String> INSTALL_UNIQUE_LABEL = ConfigKeys.newStringConfigKey("install.unique_label", "Provides a label which uniquely identifies an installation, used in the computation of the install dir; this should include something readable, and must include a hash of all data which differentiates an installation (e.g. version, plugins, etc), but should be the same where install dirs can be shared to allow for re-use");
    public static final ConfigKey<Boolean> SKIP_ENTITY_START = ConfigKeys.newBooleanConfigKey("entity.started", "Skip the startup process entirely, for running services");
    public static final ConfigKey<Boolean> SKIP_ENTITY_START_IF_RUNNING = ConfigKeys.newBooleanConfigKey("entity.running", "Skip the startup process entirely, if service already running");
    public static final ConfigKey<Boolean> SKIP_ENTITY_INSTALLATION = ConfigKeys.newBooleanConfigKey("install.skip", "Skip the driver install commands entirely, for pre-installed software");
    public static final ConfigKey<String> PRE_INSTALL_COMMAND = ConfigKeys.newStringConfigKey("pre.install.command", "Command to be run prior to the install method being called on the driver");
    public static final ConfigKey<String> POST_INSTALL_COMMAND = ConfigKeys.newStringConfigKey("post.install.command", "Command to be run after the install method being called on the driver");
    public static final ConfigKey<String> PRE_LAUNCH_COMMAND = ConfigKeys.newStringConfigKey("pre.launch.command", "Command to be run prior to the launch method being called on the driver");
    public static final ConfigKey<String> POST_LAUNCH_COMMAND = ConfigKeys.newStringConfigKey("post.launch.command", "Command to be run after the launch method being called on the driver");
    public static final AttributeSensorAndConfigKey<String, String> INSTALL_DIR = new TemplatedStringAttributeSensorAndConfigKey("install.dir", "Directory for this software to be installed in", "${config['" + ONBOX_BASE_DIR.getName() + "']!" + "config['" + BROOKLYN_DATA_DIR.getName() + "']!" + "'/<ERROR>-ONBOX_BASE_DIR-not-set'" + "}" + "/" + "installs/" + "${(config['install.unique_label']??)?string(config['install.unique_label']!'X'," + "(entity.entityType.simpleName)+" + "((config['install.version']??)?string('_'+(config['install.version']!'X'),''))" + ")}");
    public static final AttributeSensorAndConfigKey<String, String> RUN_DIR = new TemplatedStringAttributeSensorAndConfigKey("run.dir", "Directory for this software to be run from", "${config['" + ONBOX_BASE_DIR.getName() + "']!" + "config['" + BROOKLYN_DATA_DIR.getName() + "']!" + "'/<ERROR>-ONBOX_BASE_DIR-not-set'" + "}" + "/" + "apps/${entity.applicationId}/" + "entities/${entity.entityType.simpleName}_" + "${entity.id}");
    public static final AttributeSensorAndConfigKey<String, String> EXPANDED_INSTALL_DIR = new TemplatedStringAttributeSensorAndConfigKey("expandedinstall.dir", "Directory for installed artifacts (e.g. expanded dir after unpacking .tgz)", null);
    public static final ConfigKey<String> SUGGESTED_INSTALL_DIR = INSTALL_DIR.getConfigKey();
    public static final ConfigKey<String> SUGGESTED_RUN_DIR = RUN_DIR.getConfigKey();
    public static final ConfigKey<Boolean> PROVISION_LATCH = ConfigKeys.newBooleanConfigKey("provision.latch", "Latch for blocking location provision until ready");
    public static final ConfigKey<Boolean> START_LATCH = ConfigKeys.newBooleanConfigKey("start.latch", "Latch for blocking start until ready");
    public static final ConfigKey<Boolean> SETUP_LATCH = ConfigKeys.newBooleanConfigKey("setup.latch", "Latch for blocking setup until ready");
    public static final ConfigKey<Boolean> PRE_INSTALL_RESOURCES_LATCH = ConfigKeys.newBooleanConfigKey("resources.preInstall.latch", "Latch for blocking pre-install resources until ready");
    public static final ConfigKey<Boolean> INSTALL_RESOURCES_LATCH = ConfigKeys.newBooleanConfigKey("resources.install.latch", "Latch for blocking install resources until ready");
    public static final ConfigKey<Boolean> INSTALL_LATCH = ConfigKeys.newBooleanConfigKey("install.latch", "Latch for blocking install until ready");
    public static final ConfigKey<Boolean> RUNTIME_RESOURCES_LATCH = ConfigKeys.newBooleanConfigKey("resources.runtime.latch", "Latch for blocking runtime resources until ready");
    public static final ConfigKey<Boolean> CUSTOMIZE_LATCH = ConfigKeys.newBooleanConfigKey("customize.latch", "Latch for blocking customize until ready");
    public static final ConfigKey<Boolean> LAUNCH_LATCH = ConfigKeys.newBooleanConfigKey("launch.latch", "Latch for blocking launch until ready");
    public static final ConfigKey<Duration> START_TIMEOUT = ConfigKeys.newConfigKey("start.timeout", "Time to wait for process and for SERVICE_UP before failing (in seconds, default 2m)", Duration.seconds((Number)120));
    public static final String BROOKLYN_SSH_CONFIG_KEY_PREFIX = "brooklyn.ssh.config.";
    public static final ConfigKey<String> SSH_TOOL_CLASS;
    public static final ConfigKey<String> SSH_CONFIG_HOST;
    public static final ConfigKey<Integer> SSH_CONFIG_PORT;
    public static final ConfigKey<String> SSH_CONFIG_USER;
    public static final ConfigKey<String> SSH_CONFIG_PASSWORD;
    public static final ConfigKey<String> SSH_CONFIG_SCRIPT_DIR;
    public static final ConfigKey<String> SSH_CONFIG_SCRIPT_HEADER;
    public static final ConfigKey<String> SSH_CONFIG_DIRECT_HEADER;
    public static final ConfigKey<Boolean> SSH_CONFIG_NO_DELETE_SCRIPT;

    static {
        assert (BROOKLYN_SSH_CONFIG_KEY_PREFIX.equals(BROOKLYN_SSH_CONFIG_KEY_PREFIX)) : "static final initializer classload ordering problem";
        SSH_TOOL_CLASS = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, (ConfigKey)Preconditions.checkNotNull(SshTool.PROP_TOOL_CLASS, (Object)"static final initializer classload ordering problem"));
        SSH_CONFIG_HOST = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_HOST);
        SSH_CONFIG_PORT = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_PORT);
        SSH_CONFIG_USER = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_USER);
        SSH_CONFIG_PASSWORD = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, SshTool.PROP_PASSWORD);
        SSH_CONFIG_SCRIPT_DIR = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, (ConfigKey)Preconditions.checkNotNull(ShellTool.PROP_SCRIPT_DIR, (Object)"static final initializer classload ordering problem"));
        SSH_CONFIG_SCRIPT_HEADER = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, ShellTool.PROP_SCRIPT_HEADER);
        SSH_CONFIG_DIRECT_HEADER = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, ShellTool.PROP_DIRECT_HEADER);
        SSH_CONFIG_NO_DELETE_SCRIPT = ConfigKeys.newConfigKeyWithPrefix(BROOKLYN_SSH_CONFIG_KEY_PREFIX, ShellTool.PROP_NO_DELETE_SCRIPT);
    }
}

