/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.ParameterType;
import com.google.common.base.Objects;
import java.util.Collections;
import java.util.Map;

public class BasicParameterType<T>
implements ParameterType<T> {
    private static final long serialVersionUID = -5521879180483663919L;
    private String name;
    private Class<T> type;
    private String description;
    private Boolean hasDefaultValue = null;
    private T defaultValue = null;

    public BasicParameterType() {
        this(Collections.emptyMap());
    }

    public BasicParameterType(Map<?, ?> arguments) {
        if (arguments.containsKey("name")) {
            this.name = (String)arguments.get("name");
        }
        if (arguments.containsKey("type")) {
            this.type = (Class)arguments.get("type");
        }
        if (arguments.containsKey("description")) {
            this.description = (String)arguments.get("description");
        }
        if (arguments.containsKey("defaultValue")) {
            this.defaultValue = arguments.get("defaultValue");
        }
    }

    public BasicParameterType(String name, Class<T> type) {
        this(name, type, null, null, false);
    }

    public BasicParameterType(String name, Class<T> type, String description) {
        this(name, type, description, null, false);
    }

    public BasicParameterType(String name, Class<T> type, String description, T defaultValue) {
        this(name, type, description, defaultValue, true);
    }

    public BasicParameterType(String name, Class<T> type, String description, T defaultValue, boolean hasDefaultValue) {
        this.name = name;
        this.type = type;
        this.description = description;
        this.defaultValue = defaultValue;
        if (defaultValue != null && !defaultValue.getClass().equals(Object.class)) {
            this.hasDefaultValue = hasDefaultValue;
        }
    }

    public String getName() {
        return this.name;
    }

    public Class<T> getParameterClass() {
        return this.type;
    }

    public String getParameterClassName() {
        return this.type.getCanonicalName();
    }

    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.hasDefaultValue() ? (T)this.defaultValue : null;
    }

    public boolean hasDefaultValue() {
        return this.hasDefaultValue != null ? this.hasDefaultValue : this.defaultValue != null && !this.defaultValue.getClass().equals(Object.class);
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("name", (Object)this.name).add("description", (Object)this.description).add("type", (Object)this.getParameterClassName()).add("defaultValue", this.defaultValue).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.name, this.description, this.type, this.defaultValue});
    }

    public boolean equals(Object obj) {
        return obj instanceof ParameterType && Objects.equal((Object)this.name, (Object)((ParameterType)obj).getName()) && Objects.equal((Object)this.description, (Object)((ParameterType)obj).getDescription()) && Objects.equal(this.type, (Object)((ParameterType)obj).getParameterClass()) && Objects.equal(this.defaultValue, (Object)((ParameterType)obj).getDefaultValue());
    }
}

