/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.render.RendererHints;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.basic.BasicAttributeSensor;
import brooklyn.event.basic.BasicAttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.event.basic.PortAttributeSensorAndConfigKey;
import brooklyn.event.basic.Sensors;
import brooklyn.management.ManagementContext;
import brooklyn.util.net.UserAndHostAndPort;
import com.google.common.annotations.Beta;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.List;
import java.util.Map;

public interface Attributes {
    public static final BasicNotificationSensor<Void> LOCATION_CHANGED = new BasicNotificationSensor<Void>(Void.class, "entity.locationChanged", "Indicates that an entity's location has been changed");
    public static final BasicAttributeSensorAndConfigKey<String> DOWNLOAD_URL = new BasicAttributeSensorAndConfigKey<String>(String.class, "download.url", "URL pattern for downloading the installer (will substitute things like ${version} automatically)");
    public static final BasicAttributeSensorAndConfigKey<Map<String, String>> DOWNLOAD_ADDON_URLS = new BasicAttributeSensorAndConfigKey<Map>(Map.class, "download.addon.urls", "URL patterns for downloading named add-ons (will substitute things like ${version} automatically)");
    public static final AttributeSensor<List<Integer>> PORT_NUMBERS = new BasicAttributeSensor<List>(List.class, "port.list", "List of port numbers");
    public static final AttributeSensor<List<Sensor<Integer>>> PORT_SENSORS = new BasicAttributeSensor<List>(List.class, "port.list.sensors", "List of port number attributes");
    public static final PortAttributeSensorAndConfigKey HTTP_PORT = new PortAttributeSensorAndConfigKey("http.port", "HTTP port", ImmutableList.of((Object)8080, (Object)"18080+"));
    public static final PortAttributeSensorAndConfigKey HTTPS_PORT = new PortAttributeSensorAndConfigKey("https.port", "HTTP port (with SSL/TLS)", ImmutableList.of((Object)8443, (Object)"18443+"));
    public static final PortAttributeSensorAndConfigKey SSH_PORT = new PortAttributeSensorAndConfigKey("ssh.port", "SSH port", 22);
    public static final PortAttributeSensorAndConfigKey SMTP_PORT = new PortAttributeSensorAndConfigKey("smtp.port", "SMTP port", 25);
    public static final PortAttributeSensorAndConfigKey DNS_PORT = new PortAttributeSensorAndConfigKey("dns.port", "DNS port", 53);
    public static final PortAttributeSensorAndConfigKey AMQP_PORT = new PortAttributeSensorAndConfigKey("amqp.port", "AMQP port", (Object)"5672+");
    public static final AttributeSensor<String> HOSTNAME = Sensors.newStringSensor("host.name", "Host name");
    public static final AttributeSensor<String> ADDRESS = Sensors.newStringSensor("host.address", "Host IP address");
    public static final AttributeSensor<UserAndHostAndPort> SSH_ADDRESS = Sensors.newSensor(UserAndHostAndPort.class, "host.sshAddress", "user@host:port for ssh'ing (or null if inappropriate)");
    public static final AttributeSensor<UserAndHostAndPort> WINRM_ADDRESS = Sensors.newSensor(UserAndHostAndPort.class, "host.winrmAddress", "user@host:port for WinRM'ing (or null if inappropriate)");
    public static final AttributeSensor<String> SUBNET_HOSTNAME = Sensors.newStringSensor("host.subnet.hostname", "Host name as known internally in the subnet where it is running (if different to host.name)");
    public static final AttributeSensor<String> SUBNET_ADDRESS = Sensors.newStringSensor("host.subnet.address", "Host address as known internally in the subnet where it is running (if different to host.name)");
    public static final AttributeSensor<String> HOST_AND_PORT = Sensors.newStringSensor("hostandport", "host:port");
    public static final AttributeSensor<Boolean> SERVICE_UP = Sensors.newBooleanSensor("service.isUp", "Whether the service is active and availability (confirmed and monitored)");
    public static final AttributeSensor<Map<String, Object>> SERVICE_NOT_UP_INDICATORS = Sensors.newSensor(new TypeToken<Map<String, Object>>(){}, "service.notUp.indicators", "A map of namespaced indicators that the service is not up");
    public static final AttributeSensor<Map<String, Object>> SERVICE_PROBLEMS = Sensors.newSensor(new TypeToken<Map<String, Object>>(){}, "service.problems", "A map of namespaced indicators of problems with a service");
    public static final AttributeSensor<Lifecycle> SERVICE_STATE_ACTUAL = Sensors.newSensor(Lifecycle.class, "service.state", "Actual lifecycle state of the service");
    public static final AttributeSensor<Lifecycle.Transition> SERVICE_STATE_EXPECTED = Sensors.newSensor(Lifecycle.Transition.class, "service.state.expected", "Last controlled change to service state, indicating what the expected state should be");
    @Deprecated
    public static final AttributeSensor<Lifecycle> SERVICE_STATE = SERVICE_STATE_ACTUAL;
    public static final AttributeSensor<Integer> PID = Sensors.newIntegerSensor("pid", "Process ID for the previously launched instance");
    public static final AttributeSensor<String> LOG_FILE_LOCATION = Sensors.newStringSensor("log.location", "Log file location");
    public static final AttributeSensor<URI> MAIN_URI = MainUri.access$000();
    @Beta
    public static final AttributeSensor<ManagementContext.PropertiesReloadListener> PROPERTIES_RELOAD_LISTENER = Sensors.newSensor(ManagementContext.PropertiesReloadListener.class, "brooklyn.management.propertiesReloadListener", "Properties reload listener");

    public static class MainUri {
        private static final AttributeSensor<URI> MAIN_URI = Sensors.newSensor(URI.class, "main.uri", "Main URI for contacting the service/endpoint offered by this entity");

        static /* synthetic */ AttributeSensor access$000() {
            return MAIN_URI;
        }

        static {
            RendererHints.register(MAIN_URI, RendererHints.namedActionWithUrl());
        }
    }
}

