/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.BasicApplication;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.management.EntityManager;
import brooklyn.management.ManagementContext;
import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Beta
public abstract class ApplicationBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(ApplicationBuilder.class);
    protected volatile boolean managed = false;
    protected final AtomicBoolean inManage = new AtomicBoolean(false);
    private EntitySpec<? extends StartableApplication> appSpec;
    private ManagementContext managementContext;
    private StartableApplication app;

    @Deprecated
    @Beta
    public static <T extends StartableApplication> T newManagedApp(Class<T> type) {
        if (type.isInterface()) {
            return ApplicationBuilder.newManagedApp(EntitySpec.create(type));
        }
        return ApplicationBuilder.newManagedApp(EntitySpec.create(StartableApplication.class, type));
    }

    @Deprecated
    @Beta
    public static <T extends StartableApplication> T newManagedApp(EntitySpec<T> spec) {
        return (T)new ApplicationBuilder((EntitySpec)spec){

            @Override
            protected void doBuild() {
            }
        }.manage();
    }

    @Beta
    public static <T extends StartableApplication> T newManagedApp(Class<T> type, ManagementContext managementContext) {
        if (type.isInterface()) {
            return ApplicationBuilder.newManagedApp(EntitySpec.create(type), managementContext);
        }
        return ApplicationBuilder.newManagedApp(EntitySpec.create(StartableApplication.class, type), managementContext);
    }

    @Beta
    public static <T extends StartableApplication> T newManagedApp(EntitySpec<T> spec, ManagementContext managementContext) {
        return (T)new ApplicationBuilder((EntitySpec)spec){

            @Override
            protected void doBuild() {
            }
        }.manage(managementContext);
    }

    public ApplicationBuilder() {
        this.appSpec = EntitySpec.create(BasicApplication.class);
    }

    public ApplicationBuilder(EntitySpec<? extends StartableApplication> appSpec) {
        this.appSpec = EntitySpec.create(appSpec);
    }

    public final ApplicationBuilder appDisplayName(String val) {
        this.checkPreManage();
        this.appSpec.displayName(val);
        return this;
    }

    protected final <T extends Entity> T createEntity(EntitySpec<T> spec) {
        this.checkDuringManage();
        EntityManager entityManager = this.managementContext.getEntityManager();
        return (T)entityManager.createEntity(spec);
    }

    protected final <T extends Entity> T addChild(T entity) {
        this.checkDuringManage();
        return (T)this.app.addChild(entity);
    }

    public final Class<? extends StartableApplication> getType() {
        return this.appSpec.getType();
    }

    public final ApplicationBuilder configure(Map<?, ?> config) {
        this.checkPreManage();
        this.appSpec.configure(config);
        return this;
    }

    protected final <T extends Entity> T addChild(EntitySpec<T> spec) {
        this.checkDuringManage();
        return this.addChild(this.createEntity(spec));
    }

    protected final <T extends Entity> T addChild(Map<?, ?> config, Class<T> type) {
        this.checkDuringManage();
        EntitySpec spec = EntitySpec.create(type).configure(config);
        return this.addChild(this.createEntity(spec));
    }

    protected final ManagementContext getManagementContext() {
        return (ManagementContext)Preconditions.checkNotNull((Object)this.managementContext, (Object)"must only be called after manage()");
    }

    protected final StartableApplication getApp() {
        return (StartableApplication)Preconditions.checkNotNull((Object)this.app, (Object)"must only be called after manage()");
    }

    protected abstract void doBuild();

    public final StartableApplication manage() {
        return this.manage(Entities.newManagementContext());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final StartableApplication manage(ManagementContext managementContext) {
        if (!this.inManage.compareAndSet(false, true)) {
            throw new IllegalStateException("Concurrent and re-entrant calls to manage() forbidden on " + this);
        }
        try {
            this.checkNotManaged();
            this.app = (StartableApplication)managementContext.getEntityManager().createEntity(this.appSpec);
            this.managementContext = managementContext;
            this.doBuild();
            Entities.startManagement((Application)this.app, managementContext);
            this.managed = true;
            StartableApplication startableApplication = this.app;
            return startableApplication;
        }
        finally {
            this.inManage.set(false);
        }
    }

    protected void checkPreManage() {
        if (this.inManage.get()) {
            throw new IllegalStateException("Builder being managed; cannot perform operation during call to manage(), or in doBuild()");
        }
        if (this.managed) {
            throw new IllegalStateException("Builder already managed; cannot perform operation after call to manage()");
        }
    }

    protected void checkNotManaged() {
        if (this.managed) {
            throw new IllegalStateException("Builder already managed; cannot perform operation after call to manage()");
        }
    }

    protected void checkDuringManage() {
        if (!this.inManage.get() || this.app == null) {
            throw new IllegalStateException("Operation only permitted during manage, e.g. called from doBuild() of " + this);
        }
    }
}

