/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Entity;
import brooklyn.entity.Group;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.AbstractGroup;
import brooklyn.entity.basic.DelegateEntity;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.collections.QuorumCheck;
import brooklyn.util.collections.SetFromLiveMap;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGroupImpl
extends AbstractEntity
implements AbstractGroup {
    private static final Logger log = LoggerFactory.getLogger(AbstractGroupImpl.class);
    private Set<Entity> members = Sets.newLinkedHashSet();

    public AbstractGroupImpl() {
    }

    @Deprecated
    public AbstractGroupImpl(Map flags, Entity parent) {
        super(flags, parent);
    }

    @Override
    public void setManagementContext(ManagementContextInternal managementContext) {
        super.setManagementContext(managementContext);
        if (BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.useBrooklynLiveObjectsDatagridStorage")) {
            Set<Entity> oldMembers = this.members;
            this.members = SetFromLiveMap.create(managementContext.getStorage().getMap(this.getId() + "-members"));
            if (oldMembers.size() > 0) {
                this.members.addAll(oldMembers);
            }
        }
    }

    @Override
    public void init() {
        super.init();
        this.setAttribute(GROUP_SIZE, 0);
        this.setAttribute(GROUP_MEMBERS, ImmutableList.of());
    }

    @Override
    protected void initEnrichers() {
        super.initEnrichers();
        ServiceStateLogic.newEnricherFromChildrenState().checkChildrenAndMembers().requireRunningChildren((QuorumCheck)this.getConfig(RUNNING_QUORUM_CHECK)).addTo(this);
        ServiceStateLogic.newEnricherFromChildrenUp().checkChildrenAndMembers().requireUpChildren((QuorumCheck)this.getConfig(UP_QUORUM_CHECK)).addTo(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMember(Entity member) {
        Set<Entity> set = this.members;
        synchronized (set) {
            if (Entities.isNoLongerManaged(member)) {
                log.debug("Group {} ignoring new member {}, because it is no longer managed", (Object)this, (Object)member);
                return false;
            }
            Entity first = (Entity)this.getAttribute(FIRST);
            if (first == null) {
                ((EntityLocal)member).setAttribute(FIRST_MEMBER, (Object)true);
                ((EntityLocal)member).setAttribute(FIRST, (Object)member);
                this.setAttribute(FIRST, member);
            } else if (!first.equals(member) && !first.equals(member.getAttribute(FIRST))) {
                ((EntityLocal)member).setAttribute(FIRST_MEMBER, (Object)false);
                ((EntityLocal)member).setAttribute(FIRST, (Object)first);
            }
            member.addGroup((Group)this.getProxyIfAvailable());
            boolean changed = this.addMemberInternal(member);
            if (changed) {
                Optional result;
                log.debug("Group {} got new member {}", (Object)this, (Object)member);
                this.setAttribute(GROUP_SIZE, this.getCurrentSize());
                this.setAttribute(GROUP_MEMBERS, this.getMembers());
                this.emit(MEMBER_ADDED, member);
                if (Boolean.TRUE.equals(this.getConfig(MEMBER_DELEGATE_CHILDREN)) && !(result = Iterables.tryFind(this.getChildren(), (Predicate)Predicates.equalTo((Object)member))).isPresent()) {
                    String nameFormat = (String)Optional.fromNullable(this.getConfig(MEMBER_DELEGATE_NAME_FORMAT)).or((Object)"%s");
                    DelegateEntity child = (DelegateEntity)this.addChild((EntitySpec)EntitySpec.create(DelegateEntity.class).configure(DelegateEntity.DELEGATE_ENTITY, (Object)member).displayName(String.format(nameFormat, member.getDisplayName())));
                    Entities.manage(child);
                }
                this.getManagementSupport().getEntityChangeListener().onMembersChanged();
            }
            return changed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addMemberInternal(Entity member) {
        Set<Entity> set = this.members;
        synchronized (set) {
            return this.members.add(member);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeMember(final Entity member) {
        Set<Entity> set = this.members;
        synchronized (set) {
            boolean changed;
            member.removeGroup((Group)this.getProxyIfAvailable());
            boolean bl = changed = member != null && this.members.remove(member);
            if (changed) {
                Optional result;
                log.debug("Group {} lost member {}", (Object)this, (Object)member);
                this.setAttribute(GROUP_SIZE, this.getCurrentSize());
                this.setAttribute(GROUP_MEMBERS, this.getMembers());
                if (member.equals(this.getAttribute(FIRST))) {
                    this.setAttribute(FIRST, null);
                }
                this.emit(MEMBER_REMOVED, member);
                if (Boolean.TRUE.equals(this.getConfig(MEMBER_DELEGATE_CHILDREN)) && (result = Iterables.tryFind(this.getChildren(), (Predicate)new Predicate<Entity>(){

                    public boolean apply(Entity input) {
                        Entity delegate = (Entity)input.getConfig(DelegateEntity.DELEGATE_ENTITY);
                        if (delegate == null) {
                            return false;
                        }
                        return delegate.equals(member);
                    }
                })).isPresent()) {
                    Entity child = (Entity)result.get();
                    this.removeChild(child);
                    Entities.unmanage(child);
                }
                this.getManagementSupport().getEntityChangeListener().onMembersChanged();
            }
            return changed;
        }
    }

    @Override
    public void setMembers(Collection<Entity> m) {
        this.setMembers(m, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setMembers(Collection<Entity> mm, Predicate<Entity> filter) {
        Set<Entity> set = this.members;
        synchronized (set) {
            log.debug("Group {} members set explicitly to {} (of which some possibly filtered)", (Object)this, this.members);
            ArrayList<Entity> mmo = new ArrayList<Entity>(this.getMembers());
            for (Entity m : mmo) {
                if (mm.contains(m) && (filter == null || filter.apply((Object)m))) continue;
                this.removeMember(m);
            }
            for (Entity m : mm) {
                if (mmo.contains(m) || filter != null && !filter.apply((Object)m)) continue;
                this.addMember(m);
            }
            this.getManagementSupport().getEntityChangeListener().onMembersChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Entity> getMembers() {
        Set<Entity> set = this.members;
        synchronized (set) {
            return ImmutableSet.copyOf(this.members);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasMember(Entity e) {
        Set<Entity> set = this.members;
        synchronized (set) {
            return this.members.contains(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getCurrentSize() {
        Set<Entity> set = this.members;
        synchronized (set) {
            return this.members.size();
        }
    }

    public <T extends Entity> T addMemberChild(EntitySpec<T> spec) {
        T child = this.addChild(spec);
        this.addMember((Entity)child);
        return child;
    }

    public <T extends Entity> T addMemberChild(T child) {
        child = this.addChild(child);
        this.addMember(child);
        return child;
    }
}

