/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.basic.AbstractBrooklynObject;
import brooklyn.basic.BrooklynObject;
import brooklyn.basic.BrooklynObjectInternal;
import brooklyn.catalog.internal.CatalogUtils;
import brooklyn.config.BrooklynLogging;
import brooklyn.config.ConfigKey;
import brooklyn.config.internal.AbstractConfigMapImpl;
import brooklyn.config.render.RendererHints;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Application;
import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.EntityType;
import brooklyn.entity.Feed;
import brooklyn.entity.Group;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityConfigMap;
import brooklyn.entity.basic.EntityDynamicType;
import brooklyn.entity.basic.EntityFunctions;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.PolicyDescriptor;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.proxying.EntitySpec;
import brooklyn.entity.rebind.BasicEntityRebindSupport;
import brooklyn.entity.rebind.RebindSupport;
import brooklyn.entity.trait.Configurable;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.AttributeMap;
import brooklyn.event.basic.AttributeSensorAndConfigKey;
import brooklyn.event.basic.BasicNotificationSensor;
import brooklyn.event.basic.Sensors;
import brooklyn.event.feed.AbstractFeed;
import brooklyn.internal.BrooklynFeatureEnablement;
import brooklyn.internal.BrooklynInitialization;
import brooklyn.internal.storage.BrooklynStorage;
import brooklyn.internal.storage.Reference;
import brooklyn.internal.storage.impl.BasicReference;
import brooklyn.location.Location;
import brooklyn.location.basic.Locations;
import brooklyn.management.EntityManager;
import brooklyn.management.ExecutionContext;
import brooklyn.management.ManagementContext;
import brooklyn.management.SubscriptionContext;
import brooklyn.management.SubscriptionHandle;
import brooklyn.management.Task;
import brooklyn.management.internal.EffectorUtils;
import brooklyn.management.internal.EntityManagementSupport;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.management.internal.SubscriptionTracker;
import brooklyn.mementos.EntityMemento;
import brooklyn.policy.Enricher;
import brooklyn.policy.EnricherSpec;
import brooklyn.policy.EntityAdjunct;
import brooklyn.policy.Policy;
import brooklyn.policy.PolicySpec;
import brooklyn.policy.basic.AbstractEntityAdjunct;
import brooklyn.policy.basic.AbstractPolicy;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.collections.SetFromLiveMap;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.flags.FlagUtils;
import brooklyn.util.flags.TypeCoercions;
import brooklyn.util.guava.Maybe;
import brooklyn.util.javalang.Equals;
import brooklyn.util.task.DeferredSupplier;
import brooklyn.util.text.Strings;
import com.google.common.annotations.Beta;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEntity
extends AbstractBrooklynObject
implements EntityLocal,
EntityInternal {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEntity.class);
    public static final BasicNotificationSensor<Location> LOCATION_ADDED;
    public static final BasicNotificationSensor<Location> LOCATION_REMOVED;
    public static final BasicNotificationSensor<Sensor> SENSOR_ADDED;
    public static final BasicNotificationSensor<Sensor> SENSOR_REMOVED;
    public static final BasicNotificationSensor<String> EFFECTOR_ADDED;
    public static final BasicNotificationSensor<String> EFFECTOR_REMOVED;
    public static final BasicNotificationSensor<String> EFFECTOR_CHANGED;
    public static final BasicNotificationSensor<PolicyDescriptor> POLICY_ADDED;
    public static final BasicNotificationSensor<PolicyDescriptor> POLICY_REMOVED;
    public static final BasicNotificationSensor<Entity> CHILD_ADDED;
    public static final BasicNotificationSensor<Entity> CHILD_REMOVED;
    private boolean displayNameAutoGenerated = true;
    private Entity selfProxy;
    private volatile Application application;
    private Reference<Entity> parent = new BasicReference<Entity>();
    private Set<Group> groups = Sets.newLinkedHashSet();
    private Set<Entity> children = Sets.newLinkedHashSet();
    private Reference<List<Location>> locations = new BasicReference<ImmutableList>(ImmutableList.of());
    private Reference<Long> creationTimeUtc = new BasicReference<Long>(System.currentTimeMillis());
    private Reference<String> displayName = new BasicReference<String>();
    private Reference<String> iconUrl = new BasicReference<String>();
    Map<String, Object> presentationAttributes = Maps.newLinkedHashMap();
    Collection<AbstractPolicy> policies = Lists.newCopyOnWriteArrayList();
    Collection<AbstractEnricher> enrichers = Lists.newCopyOnWriteArrayList();
    Collection<Feed> feeds = Lists.newCopyOnWriteArrayList();
    boolean previouslyOwned = false;
    private boolean inConstruction = true;
    private final EntityDynamicType entityType;
    protected final EntityManagementSupport managementSupport = new EntityManagementSupport(this);
    private final BasicConfigurationSupport config = new BasicConfigurationSupport();
    private EntityConfigMap configsInternal = new EntityConfigMap(this, Maps.newLinkedHashMap());
    private AttributeMap attributesInternal = new AttributeMap(this, Maps.newLinkedHashMap());
    @Deprecated
    protected final Map<String, Object> tempWorkings = Maps.newLinkedHashMap();
    protected transient SubscriptionTracker _subscriptionTracker;
    static Set<String> WARNED_READ_ONLY_ATTRIBUTES;

    public AbstractEntity() {
        this(Maps.newLinkedHashMap(), null);
    }

    @Deprecated
    public AbstractEntity(Map flags) {
        this(flags, null);
    }

    @Deprecated
    public AbstractEntity(Entity parent) {
        this(Maps.newLinkedHashMap(), parent);
    }

    @Deprecated
    public AbstractEntity(Map flags, Entity parent) {
        super(AbstractEntity.checkConstructorFlags(flags, parent));
        this.entityType = new EntityDynamicType(this);
        if (this.isLegacyConstruction()) {
            boolean deferConstructionChecks;
            AbstractEntity checkWeGetThis = this.configure(flags);
            assert (this.equals(checkWeGetThis)) : this + " configure method does not return itself; returns " + checkWeGetThis + " instead of " + this;
            boolean bl = deferConstructionChecks = flags.containsKey("deferConstructionChecks") && TypeCoercions.coerce(flags.get("deferConstructionChecks"), Boolean.class) != false;
            if (!deferConstructionChecks) {
                FlagUtils.checkRequiredFields(this);
            }
        }
    }

    private static Map<?, ?> checkConstructorFlags(Map flags, Entity parent) {
        if (flags == null) {
            throw new IllegalArgumentException("Flags passed to entity must not be null (try no-arguments or empty map)");
        }
        if (flags.get("parent") != null && parent != null && flags.get("parent") != parent) {
            throw new IllegalArgumentException("Multiple parents supplied, " + flags.get("parent") + " and " + parent);
        }
        if (flags.get("owner") != null && parent != null && flags.get("owner") != parent) {
            throw new IllegalArgumentException("Multiple parents supplied with flags.parent, " + flags.get("owner") + " and " + parent);
        }
        if (flags.get("parent") != null && flags.get("owner") != null && flags.get("parent") != flags.get("owner")) {
            throw new IllegalArgumentException("Multiple parents supplied with flags.parent and flags.owner, " + flags.get("parent") + " and " + flags.get("owner"));
        }
        if (parent != null) {
            flags.put("parent", parent);
        }
        if (flags.get("owner") != null) {
            LOG.warn("Use of deprecated \"flags.owner\" instead of \"flags.parent\" for entity");
            flags.put("parent", flags.get("owner"));
            flags.remove("owner");
        }
        return flags;
    }

    @Override
    @Deprecated
    public AbstractEntity configure(Map flags) {
        Map suppliedOwnConfig;
        Entity suppliedParent;
        if (!this.inConstruction && this.getManagementSupport().isDeployed()) {
            LOG.warn("bulk/flag configuration being made to {} after deployment: may not be supported in future versions ({})", new Object[]{this, flags});
        }
        if ((suppliedParent = (Entity)flags.remove("parent")) != null) {
            suppliedParent.addChild(this.getProxyIfAvailable());
        }
        if ((suppliedOwnConfig = (Map)flags.remove("config")) != null) {
            for (Map.Entry<Object, Object> entry : suppliedOwnConfig.entrySet()) {
                this.setConfigEvenIfOwned((ConfigKey)entry.getKey(), entry.getValue());
            }
        }
        if (flags.get("displayName") != null) {
            this.displayName.set((String)flags.remove("displayName"));
            this.displayNameAutoGenerated = false;
        } else if (flags.get("name") != null) {
            this.displayName.set((String)flags.remove("name"));
            this.displayNameAutoGenerated = false;
        } else if (this.isLegacyConstruction()) {
            this.displayName.set(this.getClass().getSimpleName() + ":" + Strings.maxlen((String)this.getId(), (int)4));
            this.displayNameAutoGenerated = true;
        }
        if (flags.get("iconUrl") != null) {
            this.iconUrl.set((String)flags.remove("iconUrl"));
        }
        FlagUtils.setFieldsFromFlags(flags, this);
        flags = FlagUtils.setAllConfigKeys(flags, (Configurable)this, false);
        Iterator<Map.Entry<String, ?>> fi = flags.entrySet().iterator();
        while (fi.hasNext()) {
            Map.Entry<Object, Object> entry;
            entry = fi.next();
            Object k = entry.getKey();
            if (k instanceof ConfigKey.HasConfigKey) {
                k = ((ConfigKey.HasConfigKey)k).getConfigKey();
            }
            if (!(k instanceof ConfigKey)) continue;
            this.setConfigEvenIfOwned((ConfigKey)k, entry.getValue());
            fi.remove();
        }
        if (!flags.isEmpty()) {
            LOG.warn("Unsupported flags when configuring {}; storing: {}", (Object)this, flags);
            this.configsInternal.addToLocalBag(flags);
        }
        return this;
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o == this.selfProxy || o instanceof Entity && Objects.equal((Object)this.getId(), (Object)((Entity)o).getId());
    }

    @Beta
    public void setProxy(Entity proxy) {
        if (this.selfProxy != null) {
            throw new IllegalStateException("Proxy is already set; cannot reset proxy for " + this.toString());
        }
        this.resetProxy(proxy);
    }

    @Beta
    public void resetProxy(Entity proxy) {
        this.selfProxy = (Entity)Preconditions.checkNotNull((Object)proxy, (Object)"proxy");
    }

    public Entity getProxy() {
        return this.selfProxy;
    }

    @Beta
    public Entity getProxyIfAvailable() {
        return this.getProxy() != null ? this.getProxy() : this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey<T> key, T value) {
        this.setConfig(key, value);
        return this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey<T> key, String value) {
        this.config().set(key, value);
        return this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey.HasConfigKey<T> key, T value) {
        this.config().set(key, value);
        return this;
    }

    @Deprecated
    public <T> AbstractEntity configure(ConfigKey.HasConfigKey<T> key, String value) {
        this.config().set((ConfigKey)key, value);
        return this;
    }

    @Override
    public void setManagementContext(ManagementContextInternal managementContext) {
        super.setManagementContext(managementContext);
        this.getManagementSupport().setManagementContext(managementContext);
        this.entityType.setName(this.getEntityTypeName());
        if (this.displayNameAutoGenerated) {
            this.displayName.set(this.getEntityType().getSimpleName() + ":" + Strings.maxlen((String)this.getId(), (int)4));
        }
        if (BrooklynFeatureEnablement.isEnabled("brooklyn.experimental.feature.useBrooklynLiveObjectsDatagridStorage")) {
            Entity oldParent = this.parent.get();
            Set<Group> oldGroups = this.groups;
            Set<Entity> oldChildren = this.children;
            List<Location> oldLocations = this.locations.get();
            EntityConfigMap oldConfig = this.configsInternal;
            AttributeMap oldAttribs = this.attributesInternal;
            long oldCreationTimeUtc = this.creationTimeUtc.get();
            String oldDisplayName = this.displayName.get();
            String oldIconUrl = this.iconUrl.get();
            this.parent = managementContext.getStorage().getReference(this.getId() + "-parent");
            this.groups = SetFromLiveMap.create(managementContext.getStorage().getMap(this.getId() + "-groups"));
            this.children = SetFromLiveMap.create(managementContext.getStorage().getMap(this.getId() + "-children"));
            this.locations = managementContext.getStorage().getNonConcurrentList(this.getId() + "-locations");
            this.creationTimeUtc = managementContext.getStorage().getReference(this.getId() + "-creationTime");
            this.displayName = managementContext.getStorage().getReference(this.getId() + "-displayName");
            this.iconUrl = managementContext.getStorage().getReference(this.getId() + "-iconUrl");
            if (oldParent != null) {
                this.parent.set(oldParent);
            }
            if (oldGroups.size() > 0) {
                this.groups.addAll(oldGroups);
            }
            if (oldChildren.size() > 0) {
                this.children.addAll(oldChildren);
            }
            if (oldLocations.size() > 0) {
                this.locations.set((List<Location>)ImmutableList.copyOf(oldLocations));
            }
            if (this.creationTimeUtc.isNull()) {
                this.creationTimeUtc.set(oldCreationTimeUtc);
            }
            if (this.displayName.isNull()) {
                this.displayName.set(oldDisplayName);
            } else {
                this.displayNameAutoGenerated = false;
            }
            if (this.iconUrl.isNull()) {
                this.iconUrl.set(oldIconUrl);
            }
            this.configsInternal = new EntityConfigMap(this, managementContext.getStorage().getMap(this.getId() + "-config"));
            if (oldConfig.getLocalConfig().size() > 0) {
                this.configsInternal.setLocalConfig(oldConfig.getLocalConfig());
            }
            this.config().refreshInheritedConfig();
            this.attributesInternal = new AttributeMap(this, managementContext.getStorage().getMap(this.getId() + "-attributes"));
            if (oldAttribs.asRawMap().size() > 0) {
                for (Map.Entry<Collection<String>, Object> entry : oldAttribs.asRawMap().entrySet()) {
                    this.attributesInternal.update(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    @Override
    public Map<String, String> toMetadataRecord() {
        return ImmutableMap.of();
    }

    public long getCreationTime() {
        return this.creationTimeUtc.get();
    }

    public String getDisplayName() {
        return this.displayName.get();
    }

    public String getIconUrl() {
        return this.iconUrl.get();
    }

    @Override
    public void setDisplayName(String newDisplayName) {
        this.displayName.set(newDisplayName);
        this.displayNameAutoGenerated = false;
        this.getManagementSupport().getEntityChangeListener().onChanged();
    }

    protected void setDefaultDisplayName(String displayNameIfDefault) {
        if (this.displayNameAutoGenerated) {
            this.displayName.set(displayNameIfDefault);
        }
    }

    protected String getEntityTypeName() {
        try {
            Class typeClazz = this.getManagementContext().getEntityManager().getEntityTypeRegistry().getEntityTypeOf(this.getClass());
            String typeName = typeClazz.getCanonicalName();
            if (typeName == null) {
                typeName = typeClazz.getName();
            }
            return typeName;
        }
        catch (IllegalArgumentException e) {
            String typeName = this.getClass().getCanonicalName();
            if (typeName == null) {
                typeName = this.getClass().getName();
            }
            LOG.debug("Entity type interface not found for entity " + this + "; instead using " + typeName + " as entity type name");
            return typeName;
        }
    }

    public AbstractEntity setParent(Entity entity) {
        if (!this.parent.isNull()) {
            if (this.parent.contains(entity)) {
                return this;
            }
            if (entity == null) {
                this.clearParent();
                return this;
            }
            throw new UnsupportedOperationException("Cannot change parent of " + this + " from " + this.parent + " to " + entity + " (parent change not supported)");
        }
        if (this.previouslyOwned && entity != null) {
            throw new UnsupportedOperationException("Cannot set a parent of " + this + " because it has previously had a parent");
        }
        if (this.equals(entity)) {
            throw new IllegalStateException("entity " + this + " cannot own itself");
        }
        if (Entities.isDescendant((Entity)this, entity)) {
            throw new IllegalStateException("loop detected trying to set parent of " + this + " as " + entity + ", which is already a descendent");
        }
        this.parent.set(entity);
        entity.addChild(this.getProxyIfAvailable());
        this.config().refreshInheritedConfig();
        this.previouslyOwned = true;
        this.getApplication();
        return this;
    }

    public void clearParent() {
        if (this.parent.isNull()) {
            return;
        }
        Entity oldParent = this.parent.get();
        this.parent.clear();
        if (oldParent != null && !Entities.isNoLongerManaged(oldParent)) {
            oldParent.removeChild(this.getProxyIfAvailable());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends Entity> T addChild(T child) {
        boolean changed;
        Preconditions.checkNotNull(child, (String)"child must not be null (for entity %s)", (Object[])new Object[]{this});
        CatalogUtils.setCatalogItemIdOnAddition((Entity)this, child);
        Set<Entity> set = this.children;
        synchronized (set) {
            if (Entities.isAncestor((Entity)this, child)) {
                throw new IllegalStateException("loop detected trying to add child " + child + " to " + this + "; it is already an ancestor");
            }
            child.setParent(this.getProxyIfAvailable());
            changed = this.children.add(child);
            this.getManagementSupport().getEntityChangeListener().onChildrenChanged();
        }
        if (changed) {
            this.emit(CHILD_ADDED, child);
        }
        return child;
    }

    public <T extends Entity> T addChild(EntitySpec<T> spec) {
        if (spec.getParent() == null) {
            spec = EntitySpec.create(spec).parent((Entity)this);
        }
        if (!this.equals(spec.getParent())) {
            throw new IllegalArgumentException("Attempt to create child of " + this + " with entity spec " + spec + " failed because spec has different parent: " + spec.getParent());
        }
        return (T)this.addChild(this.getEntityManager().createEntity(spec));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeChild(Entity child) {
        boolean changed;
        Set<Entity> set = this.children;
        synchronized (set) {
            changed = this.children.remove(child);
            child.clearParent();
            if (changed) {
                this.getManagementSupport().getEntityChangeListener().onChildrenChanged();
            }
        }
        if (changed) {
            this.emit(CHILD_REMOVED, child);
        }
        return changed;
    }

    public void addGroup(Group e) {
        this.groups.add(e);
        this.getApplication();
    }

    public void removeGroup(Group e) {
        this.groups.remove(e);
        this.getApplication();
    }

    public Entity getParent() {
        return this.parent.get();
    }

    public Collection<Entity> getChildren() {
        return ImmutableList.copyOf(this.children);
    }

    public Collection<Group> getGroups() {
        return ImmutableList.copyOf(this.groups);
    }

    public Application getApplication() {
        Application app;
        if (this.application != null) {
            return this.application;
        }
        Entity parent = this.getParent();
        Application application = app = parent != null ? parent.getApplication() : null;
        if (app != null && this.getManagementSupport().isFullyManaged()) {
            this.setApplication(app);
        }
        return app;
    }

    protected synchronized void setApplication(Application app) {
        if (this.application != null && this.application.getId() != app.getId()) {
            throw new IllegalStateException("Cannot change application of entity (attempted for " + this + " from " + this.getApplication() + " to " + app);
        }
        this.application = app;
    }

    public String getApplicationId() {
        Application app = this.getApplication();
        return app == null ? null : app.getId();
    }

    @Override
    public ManagementContext getManagementContext() {
        return this.getManagementSupport().getManagementContext();
    }

    protected EntityManager getEntityManager() {
        return this.getManagementContext().getEntityManager();
    }

    public EntityType getEntityType() {
        if (this.entityType == null) {
            return null;
        }
        return this.entityType.getSnapshot();
    }

    @Override
    public EntityDynamicType getMutableEntityType() {
        return this.entityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Location> getLocations() {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            return ImmutableList.copyOf((Collection)this.locations.get());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLocations(Collection<? extends Location> newLocations) {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            List<Location> list = this.locations.get();
            LinkedHashSet truelyNewLocations = Sets.newLinkedHashSet(newLocations);
            truelyNewLocations.removeAll(list);
            if (truelyNewLocations.size() > 0) {
                this.locations.set((List<Location>)ImmutableList.builder().addAll(list).addAll((Iterable)truelyNewLocations).build());
            }
            for (Location loc : truelyNewLocations) {
                this.emit(LOCATION_ADDED, loc);
            }
        }
        if (this.getManagementSupport().isDeployed()) {
            for (Location location : newLocations) {
                Locations.manage(location, this.getManagementContext());
            }
        }
        this.getManagementSupport().getEntityChangeListener().onLocationsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLocations(Collection<? extends Location> removedLocations) {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            List<Location> oldLocations = this.locations.get();
            Sets.SetView trulyRemovedLocations = Sets.intersection((Set)ImmutableSet.copyOf(removedLocations), (Set)ImmutableSet.copyOf(oldLocations));
            this.locations.set((List<Location>)MutableList.builder().addAll(oldLocations).removeAll(removedLocations).buildImmutable());
            for (Location loc : trulyRemovedLocations) {
                this.emit(LOCATION_REMOVED, loc);
            }
        }
        this.getManagementSupport().getEntityChangeListener().onLocationsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearLocations() {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            this.locations.set((List<Location>)ImmutableList.of());
        }
        this.getManagementSupport().getEntityChangeListener().onLocationsChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Location firstLocation() {
        Reference<List<Location>> reference = this.locations;
        synchronized (reference) {
            return (Location)Iterables.get((Iterable)this.locations.get(), (int)0);
        }
    }

    @Override
    public void destroy() {
    }

    public <T> T getAttribute(AttributeSensor<T> attribute) {
        return this.attributesInternal.getValue(attribute);
    }

    public <T> T getAttributeByNameParts(List<String> nameParts) {
        return (T)this.attributesInternal.getValue(nameParts);
    }

    public <T> T setAttribute(AttributeSensor<T> attribute, T val) {
        T result;
        T oldVal;
        if (LOG.isTraceEnabled()) {
            LOG.trace("" + this + " setAttribute " + attribute + " " + val);
        }
        if (Boolean.TRUE.equals(this.getManagementSupport().isReadOnlyRaw()) && !Equals.approximately(val, oldVal = this.getAttribute(attribute))) {
            String message = this + " setting " + attribute + " = " + val + " (was " + oldVal + ") in read only mode; will have very little effect";
            if (!this.getManagementSupport().isDeployed()) {
                message = this.getManagementSupport().wasDeployed() ? message + " (no longer deployed)" : message + " (not yet deployed)";
            }
            if (WARNED_READ_ONLY_ATTRIBUTES.add(attribute.getName())) {
                LOG.warn(message + " (future messages for this sensor logged at trace)");
            } else if (LOG.isTraceEnabled()) {
                LOG.trace(message);
            }
        }
        if ((result = this.attributesInternal.update(attribute, val)) == null) {
            this.entityType.addSensorIfAbsent((Sensor<?>)attribute);
        }
        this.getManagementSupport().getEntityChangeListener().onAttributeChanged(attribute);
        return result;
    }

    @Override
    public <T> T setAttributeWithoutPublishing(AttributeSensor<T> attribute, T val) {
        T result;
        if (LOG.isTraceEnabled()) {
            LOG.trace("" + this + " setAttributeWithoutPublishing " + attribute + " " + val);
        }
        if ((result = this.attributesInternal.updateWithoutPublishing(attribute, val)) == null) {
            this.entityType.addSensorIfAbsentWithoutPublishing((Sensor<?>)attribute);
        }
        this.getManagementSupport().getEntityChangeListener().onAttributeChanged(attribute);
        return result;
    }

    @Beta
    public <T> T modifyAttribute(AttributeSensor<T> attribute, Function<? super T, Maybe<T>> modifier) {
        T result;
        if (LOG.isTraceEnabled()) {
            LOG.trace("" + this + " modifyAttribute " + attribute + " " + modifier);
        }
        if (Boolean.TRUE.equals(this.getManagementSupport().isReadOnlyRaw())) {
            String message = this + " modifying " + attribute + " = " + modifier + " in read only mode; will have very little effect";
            if (!this.getManagementSupport().isDeployed()) {
                message = this.getManagementSupport().wasDeployed() ? message + " (no longer deployed)" : message + " (not yet deployed)";
            }
            if (WARNED_READ_ONLY_ATTRIBUTES.add(attribute.getName())) {
                LOG.warn(message + " (future messages for this sensor logged at trace)");
            } else if (LOG.isTraceEnabled()) {
                LOG.trace(message);
            }
        }
        if ((result = this.attributesInternal.modify(attribute, modifier)) == null) {
            this.entityType.addSensorIfAbsent((Sensor<?>)attribute);
        }
        this.getManagementSupport().getEntityChangeListener().onAttributeChanged(attribute);
        return result;
    }

    @Override
    public void removeAttribute(AttributeSensor<?> attribute) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("" + this + " removeAttribute " + attribute);
        }
        this.attributesInternal.remove(attribute);
        this.entityType.removeSensor((Sensor<?>)attribute);
    }

    public <T> T setAttribute(AttributeSensorAndConfigKey<?, T> configuredSensor) {
        T v = this.getAttribute(configuredSensor);
        if (v != null) {
            return v;
        }
        v = configuredSensor.getAsSensorValue((Entity)this);
        if (v != null) {
            return this.setAttribute(configuredSensor, v);
        }
        return null;
    }

    @Override
    public Map<AttributeSensor, Object> getAllAttributes() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        Map<String, Object> attribs = this.attributesInternal.asMap();
        for (Map.Entry<String, Object> entry : attribs.entrySet()) {
            AttributeSensor<Object> attribKey = (AttributeSensor<Object>)this.entityType.getSensor(entry.getKey());
            if (attribKey == null) {
                LOG.warn("When retrieving all attributes of {}, no AttributeSensor for attribute {} (creating synthetic)", (Object)this, (Object)entry.getKey());
                attribKey = Sensors.newSensor(Object.class, entry.getKey());
            }
            result.put(attribKey, entry.getValue());
        }
        return result;
    }

    @Override
    @Beta
    public BasicConfigurationSupport config() {
        return this.config;
    }

    public <T> T getConfig(ConfigKey<T> key) {
        return this.config().get(key);
    }

    public <T> T getConfig(ConfigKey.HasConfigKey<T> key) {
        return this.config().get(key);
    }

    @Deprecated
    public <T> T getConfig(ConfigKey.HasConfigKey<T> key, T defaultValue) {
        return ((AbstractConfigMapImpl)this.configsInternal).getConfig(key, defaultValue);
    }

    @Deprecated
    public <T> T getConfig(ConfigKey<T> key, T defaultValue) {
        return this.configsInternal.getConfig(key, defaultValue);
    }

    @Deprecated
    public Maybe<Object> getConfigRaw(ConfigKey<?> key, boolean includeInherited) {
        return includeInherited ? this.config().getRaw(key) : this.config().getLocalRaw(key);
    }

    @Deprecated
    public Maybe<Object> getConfigRaw(ConfigKey.HasConfigKey<?> key, boolean includeInherited) {
        return includeInherited ? this.config().getRaw(key) : this.config().getLocalRaw(key);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, T val) {
        return this.config().set(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, Task<T> val) {
        return this.config().set(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey<T> key, DeferredSupplier val) {
        return (T)this.config.setConfigInternal(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey.HasConfigKey<T> key, T val) {
        return this.config().set(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey.HasConfigKey<T> key, Task<T> val) {
        return this.config().set(key, val);
    }

    @Deprecated
    public <T> T setConfig(ConfigKey.HasConfigKey<T> key, DeferredSupplier val) {
        return this.setConfig(key.getConfigKey(), val);
    }

    public <T> T setConfigEvenIfOwned(ConfigKey<T> key, T val) {
        return (T)this.configsInternal.setConfig(key, val);
    }

    public <T> T setConfigEvenIfOwned(ConfigKey.HasConfigKey<T> key, T val) {
        return this.setConfigEvenIfOwned(key.getConfigKey(), val);
    }

    @Deprecated
    protected void setConfigIfValNonNull(ConfigKey key, Object val) {
        if (val != null) {
            this.config().set(key, val);
        }
    }

    @Deprecated
    protected void setConfigIfValNonNull(ConfigKey.HasConfigKey key, Object val) {
        if (val != null) {
            this.config().set(key, val);
        }
    }

    @Override
    @Deprecated
    public void refreshInheritedConfig() {
        this.config().refreshInheritedConfig();
    }

    @Deprecated
    void refreshInheritedConfigOfChildren() {
        this.config().refreshInheritedConfigOfChildren();
    }

    @Override
    @Deprecated
    public EntityConfigMap getConfigMap() {
        return this.configsInternal;
    }

    @Override
    @Deprecated
    public Map<ConfigKey<?>, Object> getAllConfig() {
        return this.configsInternal.getAllConfig();
    }

    @Override
    @Deprecated
    @Beta
    public ConfigBag getAllConfigBag() {
        return this.config().getBag();
    }

    @Override
    @Deprecated
    @Beta
    public ConfigBag getLocalConfigBag() {
        return this.config().getLocalBag();
    }

    public <T> SubscriptionHandle subscribe(Entity producer, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.getSubscriptionTracker().subscribe(producer, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToChildren(Entity parent, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.getSubscriptionTracker().subscribeToChildren(parent, sensor, listener);
    }

    public <T> SubscriptionHandle subscribeToMembers(Group group, Sensor<T> sensor, SensorEventListener<? super T> listener) {
        return this.getSubscriptionTracker().subscribeToMembers(group, sensor, listener);
    }

    public boolean unsubscribe(Entity producer) {
        return this.getSubscriptionTracker().unsubscribe(producer);
    }

    public boolean unsubscribe(Entity producer, SubscriptionHandle handle) {
        return this.getSubscriptionTracker().unsubscribe(producer, handle);
    }

    @Override
    public synchronized SubscriptionContext getSubscriptionContext() {
        return this.getManagementSupport().getSubscriptionContext();
    }

    protected synchronized SubscriptionTracker getSubscriptionTracker() {
        if (this._subscriptionTracker == null) {
            this._subscriptionTracker = new SubscriptionTracker(this.getSubscriptionContext());
        }
        return this._subscriptionTracker;
    }

    @Override
    public synchronized ExecutionContext getExecutionContext() {
        return this.getManagementSupport().getExecutionContext();
    }

    public String toString() {
        return this.toStringHelper().toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper((Object)this).omitNullValues().add("id", (Object)this.getId());
    }

    @Override
    public void init() {
        super.init();
        this.initEnrichers();
    }

    protected void initEnrichers() {
        this.addEnricher(ServiceStateLogic.ServiceNotUpLogic.newEnricherForServiceUpIfNotUpIndicatorsEmpty());
        this.addEnricher(ServiceStateLogic.newEnricherForServiceStateFromProblemsAndUp());
    }

    public Collection<Policy> getPolicies() {
        return ImmutableList.copyOf(this.policies);
    }

    public void addPolicy(Policy policy) {
        Policy old = this.findApparentlyEqualAndWarnIfNotSameUniqueTag(this.policies, policy);
        if (old != null) {
            LOG.debug("Removing " + old + " when adding " + policy + " to " + this);
            this.removePolicy(old);
        }
        CatalogUtils.setCatalogItemIdOnAddition((Entity)this, (BrooklynObject)policy);
        this.policies.add((AbstractPolicy)policy);
        ((AbstractPolicy)policy).setEntity(this);
        this.getManagementSupport().getEntityChangeListener().onPolicyAdded(policy);
        this.emit(POLICY_ADDED, new PolicyDescriptor(policy));
    }

    public <T extends Policy> T addPolicy(PolicySpec<T> spec) {
        Policy policy = this.getManagementContext().getEntityManager().createPolicy(spec);
        this.addPolicy(policy);
        return (T)policy;
    }

    public <T extends Enricher> T addEnricher(EnricherSpec<T> spec) {
        Enricher enricher = this.getManagementContext().getEntityManager().createEnricher(spec);
        this.addEnricher(enricher);
        return (T)enricher;
    }

    public boolean removePolicy(Policy policy) {
        ((AbstractPolicy)policy).destroy();
        boolean changed = this.policies.remove(policy);
        if (changed) {
            this.getManagementSupport().getEntityChangeListener().onPolicyRemoved(policy);
            this.emit(POLICY_REMOVED, new PolicyDescriptor(policy));
        }
        return changed;
    }

    public boolean removeAllPolicies() {
        boolean changed = false;
        for (Policy policy : this.policies) {
            this.removePolicy(policy);
            changed = true;
        }
        return changed;
    }

    public Collection<Enricher> getEnrichers() {
        return ImmutableList.copyOf(this.enrichers);
    }

    public void addEnricher(Enricher enricher) {
        Enricher old = this.findApparentlyEqualAndWarnIfNotSameUniqueTag(this.enrichers, enricher);
        if (old != null) {
            LOG.debug("Removing " + old + " when adding " + enricher + " to " + this);
            this.removeEnricher(old);
        }
        CatalogUtils.setCatalogItemIdOnAddition((Entity)this, (BrooklynObject)enricher);
        this.enrichers.add((AbstractEnricher)enricher);
        ((AbstractEnricher)enricher).setEntity(this);
        this.getManagementSupport().getEntityChangeListener().onEnricherAdded(enricher);
    }

    private <T extends EntityAdjunct> T findApparentlyEqualAndWarnIfNotSameUniqueTag(Collection<? extends T> items, T newItem) {
        T oldItem = this.findApparentlyEqual(items, newItem, true);
        if (oldItem != null) {
            String oldItemTag = oldItem.getUniqueTag();
            String newItemTag = newItem.getUniqueTag();
            if (oldItemTag != null || newItemTag != null) {
                if (Objects.equal((Object)oldItemTag, (Object)newItemTag)) {
                    return oldItem;
                }
                T tagged = oldItemTag != null ? oldItem : newItem;
                T tagless = oldItemTag != null ? newItem : oldItem;
                LOG.warn("Apparently equal items " + oldItem + " and " + newItem + "; but one has a unique tag " + tagged.getUniqueTag() + "; applying to the other");
                ((AbstractEntityAdjunct.AdjunctTagSupport)tagless.tags()).setUniqueTag(tagged.getUniqueTag());
            }
            if (this.isRebinding()) {
                LOG.warn("Adding to " + this + ", " + newItem + " appears identical to existing " + oldItem + "; will replace. " + "Underlying addition should be modified so it is not added twice during rebind or unique tag should be used to indicate it is identical.");
                return oldItem;
            }
            LOG.warn("Adding to " + this + ", " + newItem + " appears identical to existing " + oldItem + "; may get removed on rebind. " + "Underlying addition should be modified so it is not added twice.");
            return null;
        }
        return null;
    }

    private <T extends EntityAdjunct> T findApparentlyEqual(Collection<? extends T> itemsCopy, T newItem, boolean transferUniqueTag) {
        Class<?> beforeEntityAdjunct = newItem.getClass();
        while (beforeEntityAdjunct.getSuperclass() != null && !beforeEntityAdjunct.getSuperclass().equals(AbstractEntityAdjunct.class)) {
            beforeEntityAdjunct = beforeEntityAdjunct.getSuperclass();
        }
        String newItemTag = newItem.getUniqueTag();
        for (EntityAdjunct oldItem : itemsCopy) {
            String oldItemTag = oldItem.getUniqueTag();
            if (!(oldItemTag != null && newItemTag != null ? oldItemTag.equals(newItemTag) : oldItem.getClass().equals(newItem.getClass()) && EqualsBuilder.reflectionEquals((Object)oldItem, newItem, (boolean)false, beforeEntityAdjunct, (String[])new String[]{"transformation", "values", "timestamps", "lastAverage", "poller", "pollerStateMutex"}))) continue;
            return (T)oldItem;
        }
        return null;
    }

    public boolean removeEnricher(Enricher enricher) {
        ((AbstractEnricher)enricher).destroy();
        boolean changed = this.enrichers.remove(enricher);
        if (changed) {
            this.getManagementSupport().getEntityChangeListener().onEnricherRemoved(enricher);
        }
        return changed;
    }

    public boolean removeAllEnrichers() {
        boolean changed = false;
        for (AbstractEnricher enricher : this.enrichers) {
            changed = this.removeEnricher(enricher) || changed;
        }
        return changed;
    }

    public <T extends Feed> T addFeed(T feed) {
        return this.feeds().addFeed(feed);
    }

    @Override
    public EntityInternal.FeedSupport feeds() {
        return new BasicFeedSupport();
    }

    @Override
    @Deprecated
    public EntityInternal.FeedSupport getFeedSupport() {
        return this.feeds();
    }

    public <T> void emit(Sensor<T> sensor, T val) {
        if (sensor instanceof AttributeSensor) {
            LOG.warn("Strongly discouraged use of emit with attribute sensor " + sensor + " " + val + "; use setAttribute instead!", new Throwable("location of discouraged attribute " + sensor + " emit"));
        }
        if (val instanceof SensorEvent) {
            LOG.warn("Strongly discouraged use of emit with sensor event as value " + sensor + " " + val + "; value should be unpacked!", new Throwable("location of discouraged event " + sensor + " emit"));
        }
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly((Entity)this), "Emitting sensor notification {} value {} on {}", sensor.getName(), val, this);
        this.emitInternal(sensor, val);
    }

    public <T> void emitInternal(Sensor<T> sensor, T val) {
        if (this.getManagementSupport().isNoLongerManaged()) {
            throw new IllegalStateException("Entity " + this + " is no longer managed, when trying to publish " + sensor + " " + val);
        }
        SubscriptionContext subsContext = this.getSubscriptionContext();
        if (subsContext != null) {
            subsContext.publish(sensor.newEvent(this.getProxyIfAvailable(), val));
        }
    }

    @Override
    public Effector<?> getEffector(String effectorName) {
        return this.entityType.getEffector(effectorName);
    }

    public <T> Task<T> invoke(Effector<T> eff) {
        return this.invoke((Map)MutableMap.of(), eff);
    }

    public <T> Task<T> invoke(Map parameters, Effector<T> eff) {
        return this.invoke(eff, parameters);
    }

    public <T> Task<T> invoke(Effector<T> eff, Map<String, ?> parameters) {
        return EffectorUtils.invokeEffectorAsync((Entity)this, eff, parameters);
    }

    public void onManagementStarting() {
        if (this.isLegacyConstruction()) {
            this.entityType.setName(this.getEntityTypeName());
            if (this.displayNameAutoGenerated) {
                this.displayName.set(this.getEntityType().getSimpleName() + ":" + Strings.maxlen((String)this.getId(), (int)4));
            }
        }
    }

    public void onManagementStarted() {
    }

    public void onManagementBecomingMaster() {
    }

    public void onManagementNoLongerMaster() {
    }

    public void onManagementStopped() {
        if (this.getManagementContext().isRunning()) {
            BrooklynStorage storage = ((ManagementContextInternal)this.getManagementContext()).getStorage();
            storage.remove(this.getId() + "-parent");
            storage.remove(this.getId() + "-groups");
            storage.remove(this.getId() + "-children");
            storage.remove(this.getId() + "-locations");
            storage.remove(this.getId() + "-creationTime");
            storage.remove(this.getId() + "-displayName");
            storage.remove(this.getId() + "-config");
            storage.remove(this.getId() + "-attributes");
        }
    }

    public void invalidateReferences() {
        this.application = null;
    }

    @Override
    public EntityManagementSupport getManagementSupport() {
        return this.managementSupport;
    }

    @Override
    public void requestPersist() {
        this.getManagementSupport().getEntityChangeListener().onChanged();
    }

    @Override
    @Beta
    public RebindSupport<EntityMemento> getRebindSupport() {
        return new BasicEntityRebindSupport(this);
    }

    @Override
    protected void onTagsChanged() {
        super.onTagsChanged();
        this.getManagementSupport().getEntityChangeListener().onTagsChanged();
    }

    public Set<Object> getTags() {
        return this.tags().getTags();
    }

    public boolean addTag(Object tag) {
        return this.tags().addTag(tag);
    }

    public boolean removeTag(Object tag) {
        return this.tags().removeTag(tag);
    }

    public boolean containsTag(Object tag) {
        return this.tags().containsTag(tag);
    }

    static {
        BrooklynInitialization.initAll();
        LOCATION_ADDED = new BasicNotificationSensor<Location>(Location.class, "entity.location.added", "Location dynamically added to entity");
        LOCATION_REMOVED = new BasicNotificationSensor<Location>(Location.class, "entity.location.removed", "Location dynamically removed from entity");
        SENSOR_ADDED = new BasicNotificationSensor<Sensor>(Sensor.class, "entity.sensor.added", "Sensor dynamically added to entity");
        SENSOR_REMOVED = new BasicNotificationSensor<Sensor>(Sensor.class, "entity.sensor.removed", "Sensor dynamically removed from entity");
        EFFECTOR_ADDED = new BasicNotificationSensor<String>(String.class, "entity.effector.added", "Effector dynamically added to entity");
        EFFECTOR_REMOVED = new BasicNotificationSensor<String>(String.class, "entity.effector.removed", "Effector dynamically removed from entity");
        EFFECTOR_CHANGED = new BasicNotificationSensor<String>(String.class, "entity.effector.changed", "Effector dynamically changed on entity");
        POLICY_ADDED = new BasicNotificationSensor<PolicyDescriptor>(PolicyDescriptor.class, "entity.policy.added", "Policy dynamically added to entity");
        POLICY_REMOVED = new BasicNotificationSensor<PolicyDescriptor>(PolicyDescriptor.class, "entity.policy.removed", "Policy dynamically removed from entity");
        CHILD_ADDED = new BasicNotificationSensor<Entity>(Entity.class, "entity.children.added", "Child dynamically added to entity");
        CHILD_REMOVED = new BasicNotificationSensor<Entity>(Entity.class, "entity.children.removed", "Child dynamically removed from entity");
        RendererHints.register(Entity.class, RendererHints.displayValue(EntityFunctions.displayName()));
        WARNED_READ_ONLY_ATTRIBUTES = Collections.synchronizedSet(MutableSet.of());
    }

    protected class BasicFeedSupport
    implements EntityInternal.FeedSupport {
        protected BasicFeedSupport() {
        }

        @Override
        public Collection<Feed> getFeeds() {
            return ImmutableList.copyOf(AbstractEntity.this.feeds);
        }

        @Override
        public <T extends Feed> T addFeed(T feed) {
            Feed old = (Feed)AbstractEntity.this.findApparentlyEqualAndWarnIfNotSameUniqueTag(AbstractEntity.this.feeds, feed);
            if (old != null) {
                LOG.debug("Removing " + old + " when adding " + feed + " to " + this);
                this.removeFeed(old);
            }
            CatalogUtils.setCatalogItemIdOnAddition((Entity)AbstractEntity.this, feed);
            AbstractEntity.this.feeds.add(feed);
            if (!AbstractEntity.this.equals(((AbstractFeed)feed).getEntity())) {
                ((AbstractFeed)feed).setEntity(AbstractEntity.this);
            }
            AbstractEntity.this.getManagementContext().getRebindManager().getChangeListener().onManaged(feed);
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onFeedAdded(feed);
            return feed;
        }

        @Override
        public boolean removeFeed(Feed feed) {
            feed.stop();
            boolean changed = AbstractEntity.this.feeds.remove(feed);
            if (changed) {
                AbstractEntity.this.getManagementContext().getRebindManager().getChangeListener().onUnmanaged((BrooklynObject)feed);
                AbstractEntity.this.getManagementSupport().getEntityChangeListener().onFeedRemoved(feed);
            }
            return changed;
        }

        @Override
        public boolean removeAllFeeds() {
            boolean changed = false;
            for (Feed feed : AbstractEntity.this.feeds) {
                changed = this.removeFeed(feed) || changed;
            }
            return changed;
        }
    }

    @Beta
    protected class BasicConfigurationSupport
    implements BrooklynObjectInternal.ConfigurationSupportInternal {
        protected BasicConfigurationSupport() {
        }

        public <T> T get(ConfigKey<T> key) {
            return AbstractEntity.this.configsInternal.getConfig(key);
        }

        public <T> T get(ConfigKey.HasConfigKey<T> key) {
            return this.get(key.getConfigKey());
        }

        public <T> T set(ConfigKey<T> key, T val) {
            return this.setConfigInternal(key, val);
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, T val) {
            return this.set(key.getConfigKey(), val);
        }

        public <T> T set(ConfigKey<T> key, Task<T> val) {
            return this.setConfigInternal(key, val);
        }

        public <T> T set(ConfigKey.HasConfigKey<T> key, Task<T> val) {
            return this.set(key.getConfigKey(), val);
        }

        @Override
        public ConfigBag getBag() {
            return AbstractEntity.this.configsInternal.getAllConfigBag();
        }

        @Override
        public ConfigBag getLocalBag() {
            return AbstractEntity.this.configsInternal.getLocalConfigBag();
        }

        @Override
        public Maybe<Object> getRaw(ConfigKey<?> key) {
            return AbstractEntity.this.configsInternal.getConfigRaw(key, true);
        }

        @Override
        public Maybe<Object> getRaw(ConfigKey.HasConfigKey<?> key) {
            return this.getRaw(key.getConfigKey());
        }

        @Override
        public Maybe<Object> getLocalRaw(ConfigKey<?> key) {
            return AbstractEntity.this.configsInternal.getConfigRaw(key, false);
        }

        @Override
        public Maybe<Object> getLocalRaw(ConfigKey.HasConfigKey<?> key) {
            return this.getLocalRaw(key.getConfigKey());
        }

        @Override
        public void addToLocalBag(Map<String, ?> vals) {
            AbstractEntity.this.configsInternal.addToLocalBag(vals);
        }

        @Override
        public void refreshInheritedConfig() {
            if (AbstractEntity.this.getParent() != null) {
                AbstractEntity.this.configsInternal.setInheritedConfig(((EntityInternal)AbstractEntity.this.getParent()).getAllConfig(), ((EntityInternal)AbstractEntity.this.getParent()).config().getBag());
            } else {
                AbstractEntity.this.configsInternal.clearInheritedConfig();
            }
            this.refreshInheritedConfigOfChildren();
        }

        @Override
        public void refreshInheritedConfigOfChildren() {
            for (Entity it : AbstractEntity.this.getChildren()) {
                ((EntityInternal)it).config().refreshInheritedConfig();
            }
        }

        private <T> T setConfigInternal(ConfigKey<T> key, Object val) {
            if (!AbstractEntity.this.inConstruction && AbstractEntity.this.getManagementSupport().isDeployed()) {
                LOG.debug("configuration being made to {} after deployment: {} = {}; change may not be visible in other contexts", new Object[]{this, key, val});
            }
            Object result = AbstractEntity.this.configsInternal.setConfig(key, val);
            AbstractEntity.this.getManagementSupport().getEntityChangeListener().onConfigChanged(key);
            return (T)result;
        }
    }
}

