/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.entity.Effector;
import brooklyn.entity.Entity;
import brooklyn.entity.ParameterType;
import brooklyn.entity.effector.EffectorBase;
import brooklyn.entity.effector.EffectorTasks;
import brooklyn.entity.effector.EffectorWithBody;
import brooklyn.management.Task;
import brooklyn.management.internal.EffectorUtils;
import brooklyn.util.config.ConfigBag;
import brooklyn.util.task.DynamicSequentialTask;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEffector<T>
extends EffectorBase<T>
implements EffectorWithBody<T> {
    private static final long serialVersionUID = 1832435915652457843L;
    private static final Logger LOG = LoggerFactory.getLogger(AbstractEffector.class);

    public AbstractEffector(String name, Class<T> returnType, List<ParameterType<?>> parameters, String description) {
        super(name, returnType, parameters, description);
    }

    public abstract T call(Entity var1, Map var2);

    public T call(Entity entity) {
        return this.call((Map)ImmutableMap.of(), entity);
    }

    public T call(Map parameters, Entity entity) {
        return this.call(entity, parameters);
    }

    @Deprecated
    protected final Map<Object, Object> getFlagsForTaskInvocationAt(Entity entity) {
        return this.getFlagsForTaskInvocationAt(entity, this, null);
    }

    protected Map<Object, Object> getFlagsForTaskInvocationAt(Entity entity, Effector<T> effector, ConfigBag parameters) {
        return EffectorUtils.getTaskFlagsForEffectorInvocation(entity, effector, parameters);
    }

    @Override
    public final EffectorTasks.EffectorTaskFactory<T> getBody() {
        return new EffectorTasks.EffectorTaskFactory<T>(){

            @Override
            public Task<T> newTask(final Entity entity, Effector<T> effector, final ConfigBag parameters) {
                return new DynamicSequentialTask(AbstractEffector.this.getFlagsForTaskInvocationAt(entity, AbstractEffector.this, parameters), new Callable<T>(){

                    @Override
                    public T call() {
                        return AbstractEffector.this.call(parameters.getAllConfig(), entity);
                    }
                });
            }
        };
    }
}

