/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.ConfigKey;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigurableEntityFactory;
import java.io.Serializable;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConfigurableEntityFactory<T extends Entity>
implements ConfigurableEntityFactory<T>,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(AbstractConfigurableEntityFactory.class);
    protected final Map config = new LinkedHashMap();

    public AbstractConfigurableEntityFactory() {
        this(new HashMap());
    }

    public AbstractConfigurableEntityFactory(Map flags) {
        this.config.putAll(flags);
    }

    @Override
    public AbstractConfigurableEntityFactory<T> configure(Map flags) {
        this.config.putAll(flags);
        return this;
    }

    @Override
    public AbstractConfigurableEntityFactory<T> configure(ConfigKey key, Object value) {
        this.config.put(key, value);
        return this;
    }

    @Override
    public AbstractConfigurableEntityFactory<T> configure(ConfigKey.HasConfigKey key, Object value) {
        return this.setConfig(key.getConfigKey(), value);
    }

    @Override
    public AbstractConfigurableEntityFactory<T> setConfig(ConfigKey key, Object value) {
        return this.configure(key, value);
    }

    @Override
    public AbstractConfigurableEntityFactory<T> setConfig(ConfigKey.HasConfigKey key, Object value) {
        return this.configure(key.getConfigKey(), value);
    }

    public T newEntity(Entity parent) {
        return this.newEntity(new HashMap(), parent);
    }

    @Override
    public T newEntity(Map flags, Entity parent) {
        HashMap flags2 = new HashMap();
        flags2.putAll(this.config);
        flags2.putAll(flags);
        T result = this.newEntity2(flags2, parent);
        log.warn("Deprecated legacy compatibility, using factory (init will not be invoked): " + result);
        return result;
    }

    public abstract T newEntity2(Map var1, Entity var2);
}

