/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.entity.basic;

import brooklyn.config.BrooklynProperties;
import brooklyn.entity.Application;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.AbstractEntity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.entity.basic.Lifecycle;
import brooklyn.entity.basic.ServiceStateLogic;
import brooklyn.entity.basic.StartableApplication;
import brooklyn.entity.trait.StartableMethods;
import brooklyn.location.Location;
import brooklyn.management.ManagementContext;
import brooklyn.management.internal.ManagementContextInternal;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.exceptions.RuntimeInterruptedException;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.time.Time;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractApplication
extends AbstractEntity
implements StartableApplication {
    public static final Logger log = LoggerFactory.getLogger(AbstractApplication.class);
    @SetFromFlag(value="mgmt")
    private volatile ManagementContext mgmt;
    private boolean deployed = false;
    BrooklynProperties brooklynProperties = null;
    private volatile Application application;

    public AbstractApplication() {
    }

    @Override
    public void init() {
        super.init();
        this.initApp();
    }

    protected void initApp() {
    }

    @Deprecated
    public AbstractApplication(Map properties) {
        super(properties);
    }

    @Deprecated
    public AbstractApplication(Map properties, Entity parent) {
        super(properties, parent);
    }

    @Override
    public Application getApplication() {
        if (this.application != null) {
            if (this.application.getId().equals(this.getId())) {
                return (Application)this.getProxyIfAvailable();
            }
            return this.application;
        }
        if (this.getParent() == null) {
            return (Application)this.getProxyIfAvailable();
        }
        return this.getParent().getApplication();
    }

    @Override
    protected synchronized void setApplication(Application app) {
        if (app.getId().equals(this.getId())) {
            this.application = this.getProxy() != null ? (Application)this.getProxy() : app;
        } else {
            this.application = app;
            if (this.getParent() == null) {
                log.warn("Setting application of " + this + " to " + app + ", but " + this + " is not parented");
            } else if (this.getParent().getApplicationId().equals(app.getParent())) {
                log.warn("Setting application of " + this + " to " + app + ", but parent " + this.getParent() + " has different app " + this.getParent().getApplication());
            }
        }
        super.setApplication(app);
    }

    @Override
    public AbstractApplication setParent(Entity parent) {
        super.setParent(parent);
        return this;
    }

    @Override
    protected void initEnrichers() {
        super.initEnrichers();
        ServiceStateLogic.newEnricherFromChildren().checkChildrenAndMembers().addTo((Entity)this);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this, Attributes.SERVICE_STATE_ACTUAL, (Object)("Application created but not yet started, at " + Time.makeDateString()));
    }

    @Override
    public void start(Collection<? extends Location> locations) {
        this.addLocations(locations);
        Collection<Location> locationsToUse = this.getLocations();
        ServiceStateLogic.ServiceProblemsLogic.clearProblemsIndicator((EntityLocal)this, START);
        ServiceStateLogic.setExpectedState((Entity)this, Lifecycle.STARTING);
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this, Attributes.SERVICE_STATE_ACTUAL, (Object)"Application starting");
        this.recordApplicationEvent(Lifecycle.STARTING);
        try {
            this.preStart(locationsToUse);
            ServiceStateLogic.ServiceNotUpLogic.clearNotUpIndicator((EntityLocal)this, Attributes.SERVICE_STATE_ACTUAL);
            this.doStart(locationsToUse);
            this.postStart(locationsToUse);
        }
        catch (Exception e) {
            this.recordApplicationEvent(Lifecycle.ON_FIRE);
            throw Exceptions.propagate((Throwable)e);
        }
        finally {
            ServiceStateLogic.setExpectedState((Entity)this, Lifecycle.RUNNING);
        }
        this.deployed = true;
        this.recordApplicationEvent(Lifecycle.RUNNING);
        this.logApplicationLifecycle("Started");
    }

    protected void logApplicationLifecycle(String message) {
        log.info(message + " application " + this);
    }

    protected void doStart(Collection<? extends Location> locations) {
        StartableMethods.start(this, locations);
    }

    public void preStart(Collection<? extends Location> locations) {
    }

    public void postStart(Collection<? extends Location> locations) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        this.logApplicationLifecycle("Stopping");
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this, Attributes.SERVICE_STATE_ACTUAL, (Object)"Application stopping");
        this.setAttribute(SERVICE_UP, false);
        ServiceStateLogic.setExpectedState((Entity)this, Lifecycle.STOPPING);
        this.recordApplicationEvent(Lifecycle.STOPPING);
        try {
            this.doStop();
        }
        catch (Exception e) {
            ServiceStateLogic.setExpectedState((Entity)this, Lifecycle.ON_FIRE);
            this.recordApplicationEvent(Lifecycle.ON_FIRE);
            log.warn("Error stopping application " + this + " (rethrowing): " + e);
            throw Exceptions.propagate((Throwable)e);
        }
        ServiceStateLogic.ServiceNotUpLogic.updateNotUpIndicator((EntityLocal)this, Attributes.SERVICE_STATE_ACTUAL, (Object)"Application stopping");
        ServiceStateLogic.setExpectedState((Entity)this, Lifecycle.STOPPED);
        this.recordApplicationEvent(Lifecycle.STOPPED);
        if (this.getParent() == null) {
            AbstractApplication abstractApplication = this;
            synchronized (abstractApplication) {
                this.deployed = false;
                this.getEntityManager().unmanage((Entity)this);
            }
        }
        this.logApplicationLifecycle("Stopped");
    }

    protected void doStop() {
        StartableMethods.stop(this);
    }

    @Override
    public void restart() {
        StartableMethods.restart(this);
    }

    @Override
    public void onManagementStopped() {
        super.onManagementStopped();
        if (this.getManagementContext().isRunning()) {
            this.recordApplicationEvent(Lifecycle.DESTROYED);
        }
    }

    private void recordApplicationEvent(Lifecycle state) {
        block3: {
            try {
                ((ManagementContextInternal)this.getManagementContext()).getUsageManager().recordApplicationEvent(this, state);
            }
            catch (RuntimeInterruptedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                if (!this.getManagementContext().isRunning()) break block3;
                log.warn("Problem recording application event '" + (Object)((Object)state) + "' for " + this, (Throwable)e);
            }
        }
    }
}

