/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.Entities;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.reflect.TypeToken;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdatingMap<S, TKey, TVal>
extends AbstractEnricher
implements SensorEventListener<S> {
    private static final Logger LOG = LoggerFactory.getLogger(UpdatingMap.class);
    @SetFromFlag(value="fromSensor")
    public static final ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor");
    @SetFromFlag(value="targetSensor")
    public static final ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor");
    @SetFromFlag(value="key")
    public static final ConfigKey<?> KEY_IN_TARGET_SENSOR = ConfigKeys.newConfigKey(Object.class, "enricher.updatingMap.keyInTargetSensor", "Key to update in the target sensor map, defaulting to the name of the source sensor");
    @SetFromFlag(value="computing")
    public static final ConfigKey<Function<?, ?>> COMPUTING = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.updatingMap.computing");
    @SetFromFlag(value="removingIfResultIsNull")
    public static final ConfigKey<Boolean> REMOVING_IF_RESULT_IS_NULL = ConfigKeys.newBooleanConfigKey("enricher.updatingMap.removingIfResultIsNull", "Whether the key in the target map is removed if the result if the computation is null");
    protected AttributeSensor<S> sourceSensor;
    protected AttributeSensor<Map<TKey, TVal>> targetSensor;
    protected TKey key;
    protected Function<S, ? extends TVal> computing;
    protected Boolean removingIfResultIsNull;

    public UpdatingMap() {
        this((Map<Object, Object>)Maps.newLinkedHashMap());
    }

    public UpdatingMap(Map<Object, Object> flags) {
        super(flags);
        this.suppressDuplicates = false;
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.sourceSensor = (AttributeSensor)this.getRequiredConfig(SOURCE_SENSOR);
        this.targetSensor = (AttributeSensor)this.getRequiredConfig(TARGET_SENSOR);
        this.key = this.getConfig(KEY_IN_TARGET_SENSOR);
        this.computing = this.getRequiredConfig(COMPUTING);
        this.removingIfResultIsNull = this.getConfig(REMOVING_IF_RESULT_IS_NULL);
        this.subscribe((Entity)entity, this.sourceSensor, this);
        this.onUpdated();
    }

    public void onEvent(SensorEvent<S> event) {
        this.onUpdated();
    }

    protected void onUpdated() {
        try {
            Object v = this.computing.apply(this.entity.getAttribute(this.sourceSensor));
            if (v == null && !Boolean.FALSE.equals(this.removingIfResultIsNull)) {
                v = Entities.REMOVE;
            }
            if (v != Entities.UNCHANGED) {
                boolean changed;
                Map map;
                boolean created;
                Object key = this.key;
                if (key == null) {
                    key = this.sourceSensor.getName();
                }
                boolean bl = created = (map = (Map)this.entity.getAttribute(this.targetSensor)) == null;
                if (created) {
                    map = MutableMap.of();
                }
                if (v == Entities.REMOVE) {
                    changed = map.containsKey(key);
                    if (changed) {
                        map.remove(key);
                    }
                } else {
                    Object oldV = map.get(key);
                    if (oldV == null) {
                        changed = v != null || !map.containsKey(key);
                    } else {
                        boolean bl2 = changed = !oldV.equals(v);
                    }
                    if (changed) {
                        map.put(key, v);
                    }
                }
                if (changed || created) {
                    this.emit(this.targetSensor, map);
                }
            }
        }
        catch (Throwable t) {
            LOG.warn("Error calculating map update for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }
}

