/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityInternal;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.BasicSensorEvent;
import brooklyn.util.collections.MutableSet;
import brooklyn.util.task.Tasks;
import brooklyn.util.time.Duration;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Transformer<T, U>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Transformer.class);
    public static ConfigKey<?> TARGET_VALUE = ConfigKeys.newConfigKey(Object.class, "enricher.targetValue");
    public static ConfigKey<Function<?, ?>> TRANSFORMATION_FROM_VALUE = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.transformation");
    public static ConfigKey<Function<?, ?>> TRANSFORMATION_FROM_EVENT = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.transformation.fromevent");
    public static ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer");
    public static ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor");
    public static ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor");
    protected Entity producer;
    protected Sensor<T> sourceSensor;
    protected Sensor<U> targetSensor;

    @Override
    public void setEntity(EntityLocal entity) {
        Object value;
        super.setEntity(entity);
        Function<SensorEvent<T>, U> transformation = this.getTransformation();
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        this.sourceSensor = this.getRequiredConfig(SOURCE_SENSOR);
        Sensor<?> targetSensorSpecified = this.getConfig(TARGET_SENSOR);
        Object object = this.targetSensor = targetSensorSpecified != null ? targetSensorSpecified : this.sourceSensor;
        if (this.producer.equals(entity) && targetSensorSpecified == null) {
            LOG.error("Refusing to add an enricher which reads and publishes on the same sensor: " + this.producer + "." + this.sourceSensor + " (computing " + transformation + ")");
            return;
        }
        this.subscribe(this.producer, this.sourceSensor, this);
        if (this.sourceSensor instanceof AttributeSensor && (value = this.producer.getAttribute((AttributeSensor)this.sourceSensor)) != null) {
            this.onEvent(new BasicSensorEvent<Object>(this.sourceSensor, this.producer, value, -1L));
        }
    }

    protected Function<SensorEvent<T>, U> getTransformation() {
        MutableSet suppliers = MutableSet.of();
        suppliers.addIfNotNull(this.config().getRaw(TARGET_VALUE).orNull());
        suppliers.addIfNotNull(this.config().getRaw(TRANSFORMATION_FROM_EVENT).orNull());
        suppliers.addIfNotNull(this.config().getRaw(TRANSFORMATION_FROM_VALUE).orNull());
        Preconditions.checkArgument((suppliers.size() == 1 ? 1 : 0) != 0, (String)"Must set exactly one of: %s, %s, %s", (Object[])new Object[]{TARGET_VALUE.getName(), TRANSFORMATION_FROM_VALUE.getName(), TRANSFORMATION_FROM_EVENT.getName()});
        Function fromEvent = (Function)this.config().get(TRANSFORMATION_FROM_EVENT);
        if (fromEvent != null) {
            return fromEvent;
        }
        final Function fromValueFn = (Function)this.config().get(TRANSFORMATION_FROM_VALUE);
        if (fromValueFn != null) {
            return new Function<SensorEvent<T>, U>(){

                public U apply(SensorEvent<T> input) {
                    return fromValueFn.apply(input.getValue());
                }

                public String toString() {
                    return "" + fromValueFn;
                }
            };
        }
        final Object targetValueRaw = this.config().getRaw(TARGET_VALUE).orNull();
        return new Function<SensorEvent<T>, U>(){

            public U apply(SensorEvent<T> input) {
                return Tasks.resolving(targetValueRaw).as(Transformer.this.targetSensor.getType()).context(((EntityInternal)Transformer.this.entity).getExecutionContext()).description("Computing sensor " + Transformer.this.targetSensor + " from " + targetValueRaw).timeout(Duration.millis((Number)200)).getMaybe().orNull();
            }

            public String toString() {
                return "" + targetValueRaw;
            }
        };
    }

    public void onEvent(SensorEvent<T> event) {
        this.emit(this.targetSensor, this.compute(event));
    }

    protected Object compute(SensorEvent<T> event) {
        Object result = this.getTransformation().apply(event);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Enricher " + this + " computed " + result + " from " + event);
        }
        return result;
    }
}

