/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.enricher.basic.AbstractTypeTransformingEnricher;
import brooklyn.entity.Entity;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.util.GroovyJavaMethods;
import brooklyn.util.javalang.JavaClassNames;
import com.google.common.base.Function;
import groovy.lang.Closure;

public class SensorTransformingEnricher<T, U>
extends AbstractTypeTransformingEnricher {
    private Function<? super T, ? extends U> transformation;

    public SensorTransformingEnricher(Entity producer, Sensor<T> source, Sensor<U> target, Function<? super T, ? extends U> transformation) {
        super(producer, source, target);
        this.transformation = transformation;
        this.uniqueTag = JavaClassNames.simpleClassName(this.getClass()) + ":" + source.getName() + "*->" + target.getName();
    }

    public SensorTransformingEnricher(Entity producer, Sensor<T> source, Sensor<U> target, Closure transformation) {
        this(producer, source, target, GroovyJavaMethods.functionFromClosure((Closure)transformation));
    }

    public SensorTransformingEnricher(Sensor<T> source, Sensor<U> target, Function<T, U> transformation) {
        this(null, source, target, transformation);
    }

    public SensorTransformingEnricher(Sensor<T> source, Sensor<U> target, Closure transformation) {
        this(null, source, target, GroovyJavaMethods.functionFromClosure((Closure)transformation));
    }

    public void onEvent(SensorEvent event) {
        if (this.accept(event.getValue())) {
            if (this.target instanceof AttributeSensor) {
                this.entity.setAttribute((AttributeSensor)this.target, this.compute(event.getValue()));
            } else {
                this.entity.emit(this.target, this.compute(event.getValue()));
            }
        }
    }

    protected boolean accept(T value) {
        return true;
    }

    protected U compute(T value) {
        return (U)this.transformation.apply(value);
    }

    public static <U, V> SensorTransformingEnricher<U, V> newInstanceTransforming(Entity producer, AttributeSensor<U> source, Function<U, V> transformation, AttributeSensor<V> target) {
        return new SensorTransformingEnricher<U, V>(producer, source, target, transformation);
    }

    public static <T> SensorTransformingEnricher<T, T> newInstanceTransforming(Entity producer, AttributeSensor<T> sensor, Function<T, T> transformation) {
        return SensorTransformingEnricher.newInstanceTransforming(producer, sensor, transformation, sensor);
    }
}

