/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.policy.Enricher;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensorPropagatingEnricher
extends AbstractEnricher
implements SensorEventListener<Object> {
    public static final Logger log = LoggerFactory.getLogger(SensorPropagatingEnricher.class);
    private final Entity source;
    private final Set<Sensor<?>> sensors;
    private final Map<Sensor<?>, Sensor<?>> sensorMappings;

    public static SensorPropagatingEnricher newInstanceListeningToAllSensors(Entity source) {
        return SensorPropagatingEnricher.newInstanceListeningToAllSensorsBut(source, new Sensor[0]);
    }

    public static SensorPropagatingEnricher newInstanceListeningToAllSensorsBut(Entity source, Sensor<?> ... excludes) {
        ImmutableSet excluded = ImmutableSet.copyOf((Object[])excludes);
        LinkedHashSet includes = Sets.newLinkedHashSet();
        for (Sensor it : source.getEntityType().getSensors()) {
            if (excluded.contains(it)) continue;
            includes.add(it);
        }
        return new SensorPropagatingEnricher(source, includes);
    }

    public static SensorPropagatingEnricher newInstanceListeningTo(Entity source, Sensor<?> ... includes) {
        return new SensorPropagatingEnricher(source, includes);
    }

    public static SensorPropagatingEnricher newInstanceRenaming(Entity source, Map<? extends Sensor<?>, ? extends Sensor<?>> sensors) {
        return new SensorPropagatingEnricher(source, sensors);
    }

    public SensorPropagatingEnricher(Entity source, Sensor<?> ... sensors) {
        this(source, (Collection<Sensor<?>>)ImmutableList.copyOf((Object[])sensors));
    }

    public SensorPropagatingEnricher(Entity source, Collection<Sensor<?>> sensors) {
        this.source = source;
        this.sensors = ImmutableSet.copyOf(sensors);
        this.sensorMappings = ImmutableMap.of();
    }

    public SensorPropagatingEnricher(Entity source, Map<? extends Sensor<?>, ? extends Sensor<?>> sensors) {
        this.source = source;
        this.sensors = ImmutableSet.copyOf(sensors.keySet());
        this.sensorMappings = ImmutableMap.copyOf(sensors);
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        for (Sensor<?> s : this.sensors) {
            this.subscribe(this.source, s, this);
        }
    }

    public void onEvent(SensorEvent<Object> event) {
        Sensor sourceSensor = event.getSensor();
        Sensor<?> destinationSensor = this.getDestinationSensor(sourceSensor);
        if (log.isTraceEnabled()) {
            log.trace("policy {} got {}, propagating via {}{}", new Object[]{this, event, this.entity, sourceSensor == destinationSensor ? "" : " (as " + destinationSensor + ")"});
        }
        if (event.getSensor() instanceof AttributeSensor) {
            this.entity.setAttribute((AttributeSensor)destinationSensor, event.getValue());
        } else {
            this.entity.emit(destinationSensor, event.getValue());
        }
    }

    public void emitAllAttributes() {
        this.emitAllAttributes(false);
    }

    public void emitAllAttributes(boolean includeNullValues) {
        for (Sensor<?> s : this.sensors) {
            if (!(s instanceof AttributeSensor)) continue;
            AttributeSensor destinationSensor = (AttributeSensor)this.getDestinationSensor(s);
            Object v = this.source.getAttribute((AttributeSensor)s);
            if (v == null && !includeNullValues) continue;
            this.entity.setAttribute(destinationSensor, v);
        }
    }

    public SensorPropagatingEnricher addToEntityAndEmitAll(Entity host) {
        host.addEnricher((Enricher)this);
        this.emitAllAttributes();
        return this;
    }

    private Sensor<?> getDestinationSensor(Sensor<?> sourceSensor) {
        return this.sensorMappings.containsKey(sourceSensor) ? this.sensorMappings.get(sourceSensor) : sourceSensor;
    }
}

