/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.Attributes;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.SetFromFlag;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Propagator
extends AbstractEnricher
implements SensorEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(Propagator.class);
    public static final Set<Sensor<?>> SENSORS_NOT_USUALLY_PROPAGATED = ImmutableSet.of(Attributes.SERVICE_UP, Attributes.SERVICE_NOT_UP_INDICATORS, Attributes.SERVICE_STATE_ACTUAL, Attributes.SERVICE_STATE_EXPECTED, Attributes.SERVICE_PROBLEMS);
    @SetFromFlag(value="producer")
    public static ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer");
    @SetFromFlag(value="propagatingAllBut")
    public static ConfigKey<Collection<Sensor<?>>> PROPAGATING_ALL_BUT = ConfigKeys.newConfigKey(new TypeToken<Collection<Sensor<?>>>(){}, "enricher.propagating.propagatingAllBut");
    @SetFromFlag(value="propagatingAll")
    public static ConfigKey<Boolean> PROPAGATING_ALL = ConfigKeys.newBooleanConfigKey("enricher.propagating.propagatingAll");
    @SetFromFlag(value="propagating")
    public static ConfigKey<Collection<? extends Sensor<?>>> PROPAGATING = ConfigKeys.newConfigKey(new TypeToken<Collection<? extends Sensor<?>>>(){}, "enricher.propagating.inclusions");
    @SetFromFlag(value="sensorMapping")
    public static ConfigKey<Map<? extends Sensor<?>, ? extends Sensor<?>>> SENSOR_MAPPING = ConfigKeys.newConfigKey(new TypeToken<Map<? extends Sensor<?>, ? extends Sensor<?>>>(){}, "enricher.propagating.sensorMapping");
    protected Entity producer;
    protected Map<? extends Sensor<?>, ? extends Sensor<?>> sensorMapping;
    protected boolean propagatingAll;
    protected Collection<Sensor<?>> propagatingAllBut;
    protected Predicate<Sensor<?>> sensorFilter;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        boolean sensorMappingSet = this.getConfig(SENSOR_MAPPING) != null;
        MutableMap sensorMappingTemp = MutableMap.copyOf(this.getConfig(SENSOR_MAPPING));
        boolean bl = this.propagatingAll = Boolean.TRUE.equals(this.getConfig(PROPAGATING_ALL)) || this.getConfig(PROPAGATING_ALL_BUT) != null;
        if (this.getConfig(PROPAGATING) != null) {
            if (this.propagatingAll) {
                throw new IllegalStateException("Propagator enricher " + this + " must not have 'propagating' set at same time as either 'propagatingAll' or 'propagatingAllBut'");
            }
            for (Sensor<?> sensor : this.getConfig(PROPAGATING)) {
                if (sensorMappingTemp.containsKey(sensor)) continue;
                sensorMappingTemp.put(sensor, sensor);
            }
            this.sensorMapping = ImmutableMap.copyOf((Map)sensorMappingTemp);
            this.sensorFilter = new Predicate<Sensor<?>>(){

                public boolean apply(Sensor<?> input) {
                    return true;
                }
            };
        } else if (sensorMappingSet) {
            if (this.propagatingAll) {
                throw new IllegalStateException("Propagator enricher " + this + " must not have 'sensorMapping' set at same time as either 'propagatingAll' or 'propagatingAllBut'");
            }
            this.sensorMapping = ImmutableMap.copyOf((Map)sensorMappingTemp);
            this.sensorFilter = Predicates.alwaysTrue();
        } else {
            this.sensorMapping = ImmutableMap.of();
            if (!this.propagatingAll) {
                this.propagatingAll = true;
                this.propagatingAllBut = SENSORS_NOT_USUALLY_PROPAGATED;
            } else {
                this.propagatingAllBut = this.getConfig(PROPAGATING_ALL_BUT);
            }
            this.sensorFilter = new Predicate<Sensor<?>>(){

                public boolean apply(Sensor<?> input) {
                    Collection<Sensor<?>> exclusions = Propagator.this.propagatingAllBut;
                    if (Propagator.this.propagatingAllBut == null) {
                        exclusions = Propagator.this.getConfig(PROPAGATING_ALL_BUT);
                    }
                    return input != null && (exclusions == null || !exclusions.contains(input));
                }
            };
        }
        Preconditions.checkState((boolean)(this.propagatingAll ^ this.sensorMapping.size() > 0), (String)"Nothing to propagate; detected: propagatingAll (%s, excluding %s), sensorMapping (%s)", (Object[])new Object[]{this.propagatingAll, this.getConfig(PROPAGATING_ALL_BUT), this.sensorMapping});
        if (this.propagatingAll) {
            this.subscribe(this.producer, null, this);
        } else {
            for (Sensor<?> sensor : this.sensorMapping.keySet()) {
                this.subscribe(this.producer, sensor, this);
            }
        }
        this.emitAllAttributes();
    }

    public void onEvent(SensorEvent<Object> event) {
        Sensor sourceSensor = event.getSensor();
        Sensor<?> destinationSensor = this.getDestinationSensor(sourceSensor);
        if (!this.sensorFilter.apply((Object)sourceSensor)) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("enricher {} got {}, propagating via {}{}", new Object[]{this, event, this.entity, sourceSensor == destinationSensor ? "" : " (as " + destinationSensor + ")"});
        }
        this.emit(destinationSensor, event.getValue());
    }

    public void emitAllAttributes() {
        this.emitAllAttributes(false);
    }

    public void emitAllAttributes(boolean includeNullValues) {
        Set<Sensor<?>> sensorsToPopulate = this.propagatingAll ? Iterables.filter((Iterable)this.producer.getEntityType().getSensors(), this.sensorFilter) : this.sensorMapping.keySet();
        for (Sensor sensor : sensorsToPopulate) {
            if (!(sensor instanceof AttributeSensor)) continue;
            AttributeSensor destinationSensor = (AttributeSensor)this.getDestinationSensor(sensor);
            Object v = this.producer.getAttribute((AttributeSensor)sensor);
            if (v == null && !includeNullValues) continue;
            this.entity.setAttribute(destinationSensor, v);
        }
    }

    private Sensor<?> getDestinationSensor(Sensor<?> sourceSensor) {
        return this.sensorMapping.containsKey(sourceSensor) ? this.sensorMapping.get(sourceSensor) : sourceSensor;
    }
}

