/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.BasicSensorEvent;
import brooklyn.util.collections.MutableList;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.text.StringEscapes;
import brooklyn.util.text.Strings;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Joiner<T>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Joiner.class);
    public static ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer");
    public static ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor");
    public static ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor");
    @SetFromFlag(value="separator")
    public static ConfigKey<String> SEPARATOR = ConfigKeys.newStringConfigKey("enricher.joiner.separator", "Separator string to insert between each argument", ",");
    @SetFromFlag(value="quote")
    public static ConfigKey<Boolean> QUOTE = ConfigKeys.newBooleanConfigKey("enricher.joiner.quote", "Whether to bash-escape each parameter and wrap in double-quotes, defaulting to true", true);
    @SetFromFlag(value="minimum")
    public static ConfigKey<Integer> MINIMUM = ConfigKeys.newIntegerConfigKey("enricher.joiner.minimum", "Minimum number of elements to join; if fewer than this, sets null; default 0 (no minimum)");
    @SetFromFlag(value="maximum")
    public static ConfigKey<Integer> MAXIMUM = ConfigKeys.newIntegerConfigKey("enricher.joiner.maximum", "Maximum number of elements to join; default null means all elements always taken");
    protected Entity producer;
    protected AttributeSensor<T> sourceSensor;
    protected Sensor<String> targetSensor;

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        this.sourceSensor = (AttributeSensor)this.getRequiredConfig(SOURCE_SENSOR);
        this.targetSensor = this.getRequiredConfig(TARGET_SENSOR);
        this.subscribe(this.producer, this.sourceSensor, this);
        Object value = this.producer.getAttribute(this.sourceSensor);
        if (value != null) {
            this.onEvent(new BasicSensorEvent<Object>((Sensor<Object>)this.sourceSensor, this.producer, value, -1L));
        }
    }

    public void onEvent(SensorEvent<T> event) {
        this.emit(this.targetSensor, this.compute(event));
    }

    protected Object compute(SensorEvent<T> event) {
        Collection v = event.getValue();
        String result = null;
        if (v != null) {
            if (v instanceof Map) {
                v = ((Map)((Object)v)).values();
            }
            if (!(v instanceof Iterable)) {
                LOG.warn("Enricher " + this + " received a non-iterable value " + v.getClass() + " " + v + "; refusing to join");
            } else {
                Integer minimum;
                MutableList c1 = MutableList.of();
                Integer maximum = this.getConfig(MAXIMUM);
                for (Object ci : (Iterable)v) {
                    if (maximum != null && maximum >= 0 && c1.size() >= maximum) break;
                    c1.appendIfNotNull((Object)Strings.toString(ci));
                }
                if ((minimum = this.getConfig(MINIMUM)) == null || c1.size() >= minimum) {
                    if (this.getConfig(QUOTE).booleanValue()) {
                        MutableList c2 = MutableList.of();
                        for (Object ci : c1) {
                            c2.add((Object)StringEscapes.BashStringEscapes.wrapBash((String)((String)ci)));
                        }
                        c1 = c2;
                    }
                    result = Strings.join((Iterable)c1, (String)this.getConfig(SEPARATOR));
                }
            }
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Enricher " + this + " computed " + result + " from " + event);
        }
        return result;
    }
}

