/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.ConfigKey;
import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.BasicSensorEvent;
import brooklyn.util.collections.MutableList;
import brooklyn.util.exceptions.Exceptions;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Combiner<T, U>
extends AbstractEnricher
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Combiner.class);
    public static ConfigKey<Function<?, ?>> TRANSFORMATION = ConfigKeys.newConfigKey(new TypeToken<Function<?, ?>>(){}, "enricher.transformation");
    public static ConfigKey<Entity> PRODUCER = ConfigKeys.newConfigKey(Entity.class, "enricher.producer");
    public static ConfigKey<Set<Sensor<?>>> SOURCE_SENSORS = ConfigKeys.newConfigKey(new TypeToken<Set<Sensor<?>>>(){}, "enricher.sourceSensors");
    public static ConfigKey<Sensor<?>> TARGET_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.targetSensor");
    public static final ConfigKey<Predicate<?>> VALUE_FILTER = ConfigKeys.newConfigKey(new TypeToken<Predicate<?>>(){}, "enricher.aggregating.valueFilter");
    protected Function<? super Collection<T>, ? extends U> transformation;
    protected Entity producer;
    protected Set<Sensor<T>> sourceSensors;
    protected Sensor<U> targetSensor;
    protected Predicate<? super T> valueFilter;
    protected final Map<Sensor<T>, T> values = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        this.transformation = this.getRequiredConfig(TRANSFORMATION);
        this.producer = this.getConfig(PRODUCER) == null ? entity : this.getConfig(PRODUCER);
        this.sourceSensors = this.getRequiredConfig(SOURCE_SENSORS);
        this.targetSensor = this.getRequiredConfig(TARGET_SENSOR);
        this.valueFilter = this.getConfig(VALUE_FILTER) == null ? Predicates.alwaysTrue() : this.getConfig(VALUE_FILTER);
        Preconditions.checkState((this.sourceSensors.size() > 0 ? 1 : 0) != 0, (Object)"must specify at least one sourceSensor");
        for (Sensor<T> sourceSensor : this.sourceSensors) {
            this.subscribe(this.producer, sourceSensor, this);
        }
        for (Sensor<T> sourceSensor : this.sourceSensors) {
            Object value;
            if (!(sourceSensor instanceof AttributeSensor) || (value = this.producer.getAttribute((AttributeSensor)sourceSensor)) == null) continue;
            this.onEvent(new BasicSensorEvent<Object>(sourceSensor, this.producer, value, -1L));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SensorEvent<T> event) {
        Map<Sensor<T>, T> map = this.values;
        synchronized (map) {
            this.values.put(event.getSensor(), event.getValue());
        }
        this.onUpdated();
    }

    protected void onUpdated() {
        try {
            this.emit(this.targetSensor, this.compute());
        }
        catch (Throwable t) {
            LOG.warn("Error calculating and setting combination for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object compute() {
        Map<Sensor<T>, T> map = this.values;
        synchronized (map) {
            MutableList vs = MutableList.copyOf((Iterable)Iterables.filter(this.values.values(), this.valueFilter));
            return this.transformation.apply((Object)vs);
        }
    }
}

