/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.BrooklynLogging;
import brooklyn.config.ConfigKey;
import brooklyn.enricher.Enrichers;
import brooklyn.enricher.basic.AbstractAggregator;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.ConfigKeys;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.util.collections.MutableList;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.exceptions.Exceptions;
import brooklyn.util.flags.SetFromFlag;
import brooklyn.util.text.StringPredicates;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Aggregator<T, U>
extends AbstractAggregator<T, U>
implements SensorEventListener<T> {
    private static final Logger LOG = LoggerFactory.getLogger(Aggregator.class);
    public static final ConfigKey<Sensor<?>> SOURCE_SENSOR = ConfigKeys.newConfigKey(new TypeToken<Sensor<?>>(){}, "enricher.sourceSensor");
    @SetFromFlag(value="transformation")
    public static final ConfigKey<Object> TRANSFORMATION_UNTYPED = ConfigKeys.newConfigKey(Object.class, "enricher.transformation.untyped", "Specifies a transformation, as a function from a collection to the value, or as a string matching a pre-defined named transformation, such as 'average' (for numbers), 'add' (for numbers), or 'list' (the default, putting any collection of items into a list)");
    public static final ConfigKey<Function<? super Collection<?>, ?>> TRANSFORMATION = ConfigKeys.newConfigKey(new TypeToken<Function<? super Collection<?>, ?>>(){}, "enricher.transformation");
    public static final ConfigKey<Boolean> EXCLUDE_BLANK = ConfigKeys.newBooleanConfigKey("enricher.aggregator.excludeBlank", "Whether explicit nulls or blank strings should be excluded (default false); this only applies if no value filter set", false);
    protected Sensor<T> sourceSensor;
    protected Function<? super Collection<T>, ? extends U> transformation;
    protected final Map<Entity, T> values = Collections.synchronizedMap(new LinkedHashMap());

    @Override
    protected void setEntityLoadingConfig() {
        super.setEntityLoadingConfig();
        this.sourceSensor = this.getRequiredConfig(SOURCE_SENSOR);
        Function<Collection<?>, ?> t1 = this.config().get(TRANSFORMATION_UNTYPED);
        if (t1 instanceof String) {
            t1 = this.lookupTransformation((String)t1);
        }
        this.transformation = (Function)this.config().get(TRANSFORMATION);
        if (this.transformation == null) {
            this.transformation = t1;
        } else if (t1 != null && !t1.equals(this.transformation)) {
            throw new IllegalStateException("Cannot supply both " + TRANSFORMATION_UNTYPED + " and " + TRANSFORMATION + " unless they are equal.");
        }
    }

    protected Function<? super Collection<?>, ?> lookupTransformation(String t1) {
        if ("average".equalsIgnoreCase(t1)) {
            return new Enrichers.ComputingAverage(null, null, this.targetSensor.getTypeToken());
        }
        if ("sum".equalsIgnoreCase(t1)) {
            return new Enrichers.ComputingAverage(null, null, this.targetSensor.getTypeToken());
        }
        if ("list".equalsIgnoreCase(t1)) {
            return new ComputingList();
        }
        return null;
    }

    @Override
    protected void setEntityBeforeSubscribingProducerChildrenEvents() {
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly(this.producer), "{} subscribing to children of {}", this, this.producer);
        this.subscribeToChildren(this.producer, this.sourceSensor, this);
    }

    @Override
    protected void addProducerHardcoded(Entity producer) {
        this.subscribe(producer, this.sourceSensor, this);
        this.onProducerAdded(producer);
    }

    @Override
    protected void addProducerChild(Entity producer) {
        this.onProducerAdded(producer);
    }

    @Override
    protected void addProducerMember(Entity producer) {
        this.subscribe(producer, this.sourceSensor, this);
        this.onProducerAdded(producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onProducerAdded(Entity producer) {
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly(producer), "{} listening to {}", this, producer);
        Map<Entity, T> map = this.values;
        synchronized (map) {
            T vo = this.values.get(producer);
            if (vo == null) {
                Object initialVal = this.sourceSensor instanceof AttributeSensor ? producer.getAttribute((AttributeSensor)this.sourceSensor) : null;
                this.values.put(producer, initialVal != null ? initialVal : this.defaultMemberValue);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} already had value ({}) for producer ({}); but that producer has just been added", new Object[]{this, vo, producer});
            }
        }
    }

    @Override
    protected Predicate<?> getDefaultValueFilter() {
        if (this.getConfig(EXCLUDE_BLANK).booleanValue()) {
            return StringPredicates.isNonBlank();
        }
        return Predicates.alwaysTrue();
    }

    @Override
    protected void onProducerRemoved(Entity producer) {
        this.values.remove(producer);
        this.onUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SensorEvent<T> event) {
        Entity e = event.getSource();
        Map<Entity, T> map = this.values;
        synchronized (map) {
            if (this.values.containsKey(e)) {
                this.values.put(e, event.getValue());
            } else if (LOG.isDebugEnabled()) {
                LOG.debug("{} received event for unknown producer ({}); presumably that producer has recently been removed", (Object)this, (Object)e);
            }
        }
        this.onUpdated();
    }

    @Override
    protected void onUpdated() {
        try {
            this.emit(this.targetSensor, this.compute());
        }
        catch (Throwable t) {
            LOG.warn("Error calculating and setting aggregate for enricher " + this, t);
            throw Exceptions.propagate((Throwable)t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object compute() {
        Map<Entity, T> map = this.values;
        synchronized (map) {
            MutableList vs = MutableList.copyOf((Iterable)Iterables.filter(this.values.values(), (Predicate)this.valueFilter));
            if (this.transformation == null) {
                return vs;
            }
            return this.transformation.apply((Object)vs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Entity, T> copyOfValues() {
        Map<Entity, T> map = this.values;
        synchronized (map) {
            return Collections.unmodifiableMap(MutableMap.copyOf(this.values));
        }
    }

    private class ComputingList<TT>
    implements Function<Collection<TT>, List<TT>> {
        private ComputingList() {
        }

        public List<TT> apply(Collection<TT> input) {
            if (input == null) {
                return null;
            }
            return MutableList.copyOf(input).asUnmodifiable();
        }
    }
}

