/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.enricher.basic.AbstractEnricher;
import brooklyn.entity.Entity;
import brooklyn.entity.basic.EntityLocal;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.event.basic.BasicSensorEvent;

public class AddingEnricher
extends AbstractEnricher
implements SensorEventListener {
    private Sensor[] sources;
    private Sensor<? extends Number> target;

    public AddingEnricher(Sensor[] sources, Sensor<? extends Number> target) {
        this.sources = sources;
        this.target = target;
    }

    @Override
    public void setEntity(EntityLocal entity) {
        super.setEntity(entity);
        for (Sensor source : this.sources) {
            Object value;
            this.subscribe((Entity)entity, source, this);
            if (!(source instanceof AttributeSensor) || (value = entity.getAttribute((AttributeSensor)source)) == null) continue;
            this.onEvent(new BasicSensorEvent<Object>(source, (Entity)entity, value, -1L));
        }
    }

    public void onEvent(SensorEvent event) {
        Number value = this.recompute();
        Number typedValue = (Number)AddingEnricher.cast(value, this.target.getType());
        if (this.target instanceof AttributeSensor) {
            this.entity.setAttribute((AttributeSensor)this.target, (Object)typedValue);
        } else if (typedValue != null) {
            this.entity.emit(this.target, (Object)typedValue);
        }
    }

    public static <V> V cast(Number value, Class<V> type) {
        if (value == null) {
            return null;
        }
        if (type.isInstance(value)) {
            return (V)value;
        }
        if (type == Integer.class) {
            return (V)Integer.valueOf((int)Math.round(value.doubleValue()));
        }
        if (type == Long.class) {
            return (V)Long.valueOf(Math.round(value.doubleValue()));
        }
        if (type == Double.class) {
            return (V)Double.valueOf(value.doubleValue());
        }
        if (type == Float.class) {
            return (V)Float.valueOf(value.floatValue());
        }
        if (type == Byte.class) {
            return (V)Byte.valueOf((byte)Math.round(value.doubleValue()));
        }
        if (type == Short.class) {
            return (V)Short.valueOf((short)Math.round(value.doubleValue()));
        }
        throw new UnsupportedOperationException("conversion of mathematical operation to " + type + " not supported");
    }

    protected Number recompute() {
        if (this.sources.length == 0) {
            return null;
        }
        Double result = 0.0;
        for (Sensor source : this.sources) {
            Object value = this.entity.getAttribute((AttributeSensor)source);
            if (value == null) {
                return null;
            }
            result = result + ((Number)value).doubleValue();
        }
        return result;
    }
}

