/*
 * Decompiled with CFR 0.152.
 */
package brooklyn.enricher.basic;

import brooklyn.config.BrooklynLogging;
import brooklyn.enricher.basic.AbstractAggregator;
import brooklyn.entity.Entity;
import brooklyn.event.AttributeSensor;
import brooklyn.event.Sensor;
import brooklyn.event.SensorEvent;
import brooklyn.event.SensorEventListener;
import brooklyn.util.collections.MutableMap;
import brooklyn.util.flags.TypeCoercions;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMultipleSensorAggregator<U>
extends AbstractAggregator<Object, U>
implements SensorEventListener<Object> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractMultipleSensorAggregator.class);
    private final Map<String, Map<Entity, Object>> values = Collections.synchronizedMap(new LinkedHashMap());

    protected abstract Collection<Sensor<?>> getSourceSensors();

    @Override
    protected void setEntityLoadingConfig() {
        super.setEntityLoadingConfig();
        Preconditions.checkNotNull(this.getSourceSensors(), (Object)"sourceSensors must be set");
    }

    @Override
    protected void setEntityBeforeSubscribingProducerChildrenEvents() {
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly(this.producer), "{} subscribing to children of {}", this, this.producer);
        for (Sensor<?> sourceSensor : this.getSourceSensors()) {
            this.subscribeToChildren(this.producer, sourceSensor, this);
        }
    }

    @Override
    protected void addProducerHardcoded(Entity producer) {
        for (Sensor<?> sourceSensor : this.getSourceSensors()) {
            this.subscribe(producer, sourceSensor, this);
        }
        this.onProducerAdded(producer);
    }

    @Override
    protected void addProducerChild(Entity producer) {
        this.onProducerAdded(producer);
    }

    @Override
    protected void addProducerMember(Entity producer) {
        this.addProducerHardcoded(producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onProducerAdded(Entity producer) {
        BrooklynLogging.log(LOG, BrooklynLogging.levelDebugOrTraceIfReadOnly(producer), "{} listening to {}", this, producer);
        Map<String, Map<Entity, Object>> map = this.values;
        synchronized (map) {
            for (Sensor<?> sensor : this.getSourceSensors()) {
                Object vo;
                Map<Entity, Object> vs = this.values.get(sensor.getName());
                if (vs == null) {
                    vs = new LinkedHashMap<Entity, Object>();
                    this.values.put(sensor.getName(), vs);
                }
                if ((vo = vs.get(producer)) != null) continue;
                Object initialVal = sensor instanceof AttributeSensor ? producer.getAttribute((AttributeSensor)sensor) : null;
                vs.put(producer, initialVal != null ? initialVal : this.defaultMemberValue);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void onProducerRemoved(Entity producer) {
        Map<String, Map<Entity, Object>> map = this.values;
        synchronized (map) {
            for (Sensor<?> sensor : this.getSourceSensors()) {
                Map<Entity, Object> vs = this.values.get(sensor.getName());
                if (vs == null) continue;
                vs.remove(producer);
            }
        }
        this.onUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(SensorEvent<Object> event) {
        Entity e = event.getSource();
        Map<String, Map<Entity, Object>> map = this.values;
        synchronized (map) {
            Map<Entity, Object> vs = this.values.get(event.getSensor().getName());
            if (vs == null) {
                LOG.debug(this + " received event when no entry for sensor (" + event + "); likely just added or removed, and will initialize subsequently if needed");
            } else {
                vs.put(e, event.getValue());
            }
        }
        this.onUpdated();
    }

    public <T> Map<Entity, T> getValues(Sensor<T> sensor) {
        Map<Entity, T> valuesCopy = this.copyValues(sensor);
        return this.coerceValues(valuesCopy, sensor.getType());
    }

    private <T> Map<Entity, T> coerceValues(Map<Entity, T> values, Class<? super T> type) {
        MutableMap typedValues = MutableMap.of();
        for (Map.Entry<Entity, T> entry : values.entrySet()) {
            T typedValue = TypeCoercions.coerce(entry.getValue(), type);
            typedValues.put(entry.getKey(), typedValue);
        }
        return typedValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> Map<Entity, T> copyValues(Sensor<T> sensor) {
        Map<String, Map<Entity, Object>> map = this.values;
        synchronized (map) {
            Map<Entity, Object> sv = this.values.get(sensor.getName());
            return MutableMap.copyOf(sv).asUnmodifiable();
        }
    }

    @Override
    protected abstract Object compute();
}

